/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.plugin;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.PluginMessageListener;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.FileUtil;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.annotation.AutoRegister;
import sk.adonikeoffice.epicchat.lib.bungee.BungeeListener;
import sk.adonikeoffice.epicchat.lib.command.SimpleCommand;
import sk.adonikeoffice.epicchat.lib.command.SimpleCommandGroup;
import sk.adonikeoffice.epicchat.lib.command.SimpleSubCommand;
import sk.adonikeoffice.epicchat.lib.debug.Debugger;
import sk.adonikeoffice.epicchat.lib.event.SimpleListener;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.menu.Menu;
import sk.adonikeoffice.epicchat.lib.menu.MenuListener;
import sk.adonikeoffice.epicchat.lib.menu.tool.ToolsListener;
import sk.adonikeoffice.epicchat.lib.metrics.Metrics;
import sk.adonikeoffice.epicchat.lib.model.DiscordListener;
import sk.adonikeoffice.epicchat.lib.model.FolderWatcher;
import sk.adonikeoffice.epicchat.lib.model.HookManager;
import sk.adonikeoffice.epicchat.lib.model.JavaScriptExecutor;
import sk.adonikeoffice.epicchat.lib.model.SimpleHologram;
import sk.adonikeoffice.epicchat.lib.model.SimpleScoreboard;
import sk.adonikeoffice.epicchat.lib.model.SpigotUpdater;
import sk.adonikeoffice.epicchat.lib.plugin.AutoRegisterScanner;
import sk.adonikeoffice.epicchat.lib.plugin.FoundationFilter;
import sk.adonikeoffice.epicchat.lib.plugin.FoundationListener;
import sk.adonikeoffice.epicchat.lib.plugin.Library;
import sk.adonikeoffice.epicchat.lib.plugin.Reloadables;
import sk.adonikeoffice.epicchat.lib.remain.CompMetadata;
import sk.adonikeoffice.epicchat.lib.remain.Remain;
import sk.adonikeoffice.epicchat.lib.settings.FileConfig;
import sk.adonikeoffice.epicchat.lib.settings.Lang;
import sk.adonikeoffice.epicchat.lib.settings.SimpleLocalization;
import sk.adonikeoffice.epicchat.lib.settings.SimpleSettings;
import sk.adonikeoffice.epicchat.lib.visual.BlockVisualizer;

public abstract class SimplePlugin
extends JavaPlugin
implements Listener {
    private static volatile SimplePlugin instance;
    private static String version;
    private static String named;
    private static File source;
    private static File data;
    private static volatile boolean reloading;
    private final Reloadables reloadables = new Reloadables();
    private boolean startingReloadables = false;
    private final boolean canLoad = true;
    private SimpleCommandGroup mainCommand;
    private BungeeListener bungeeListener;

    public static SimplePlugin getInstance() {
        if (instance == null) {
            try {
                instance = (SimplePlugin)JavaPlugin.getPlugin(SimplePlugin.class);
            }
            catch (IllegalStateException ex) {
                if (Bukkit.getPluginManager().getPlugin("PlugMan") != null) {
                    Bukkit.getLogger().severe("Failed to get instance of the plugin, if you reloaded using PlugMan you need to do a clean restart instead.");
                }
                throw ex;
            }
            Objects.requireNonNull(instance, "Cannot get a new instance! Have you reloaded?");
        }
        return instance;
    }

    public static final boolean hasInstance() {
        return instance != null;
    }

    public final void onLoad() {
        try {
            SimplePlugin.getInstance();
        }
        catch (Throwable ex) {
            if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_7)) {
                instance = this;
            }
            throw ex;
        }
        version = instance.getDescription().getVersion();
        named = instance.getDataFolder().getName();
        source = instance.getFile();
        data = instance.getDataFolder();
        String version = Bukkit.getVersion();
        if (this.suggestPaper() && !version.contains("Paper") && !version.contains("Purpur") && !version.contains("NachoSpigot") && !version.contains("-Spigot") && MinecraftVersion.atLeast(MinecraftVersion.V.v1_8)) {
            this.getLogger().warning(Common.consoleLine());
            this.getLogger().warning("You're not using Paper!");
            this.getLogger().warning("Detected: " + version);
            this.getLogger().warning("");
            this.getLogger().warning("Third party forks are known to alter server in unwanted ways.");
            this.getLogger().warning("If you experience issues with " + named + ", download Paper");
            this.getLogger().warning("from PaperMC.io, otherwise you may not receive support.");
            this.getLogger().warning(Common.consoleLine());
        }
        this.loadLibraries();
        this.onPluginLoad();
    }

    public final void onEnable() {
        Objects.requireNonNull(this);
        for (StackTraceElement element : new Throwable().getStackTrace()) {
            if (!element.toString().contains("com.rylinaux.plugman.util.PluginUtil.load")) continue;
            Common.warning("Detected PlugMan reload, which is poorly designed. It causes Bukkit not able to get our plugin from a static initializer. It may or may not run. Use our own reload command or do a clean restart!");
            break;
        }
        this.checkShading();
        if (!this.isEnabled()) {
            return;
        }
        if (!this.checkLibraries0() || !this.checkServerVersions0()) {
            this.setEnabled(false);
            return;
        }
        Debugger.detectDebugMode();
        if (this.getStartupLogo() != null) {
            String oldLogPrefix = Common.getLogPrefix();
            Common.setLogPrefix("");
            Common.log(this.getStartupLogo());
            Common.setLogPrefix(oldLogPrefix);
        }
        Remain.injectServerName();
        try {
            HookManager.loadDependencies();
        }
        catch (Throwable throwable) {
            Common.throwError(throwable, "Error while loading " + this.getDataFolder().getName() + " dependencies!");
        }
        if (!this.isEnabled()) {
            return;
        }
        try {
            Messenger messenger = this.getServer().getMessenger();
            if (!messenger.isOutgoingChannelRegistered((Plugin)this, "BungeeCord")) {
                messenger.registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
            }
            String oldLogPrefix = Common.getLogPrefix();
            Common.setLogPrefix("");
            this.startingReloadables = true;
            try {
                AutoRegisterScanner.scanAndRegister();
            }
            catch (Throwable t) {
                Remain.sneaky(t);
                return;
            }
            this.onReloadablesStart();
            this.startingReloadables = false;
            this.onPluginStart();
            if (!this.isEnabled()) {
                return;
            }
            if (this.getUpdateCheck() != null) {
                this.getUpdateCheck().run();
            }
            this.registerEvents(this);
            this.registerEvents(new MenuListener());
            this.registerEvents(new FoundationListener());
            if (this.areToolsEnabled()) {
                this.registerEvents(new ToolsListener());
            }
            if (HookManager.isDiscordSRVLoaded()) {
                DiscordListener.DiscordListenerImpl discord = DiscordListener.DiscordListenerImpl.getInstance();
                discord.resubscribe();
                discord.registerHook();
                this.reloadables.registerEvents(DiscordListener.DiscordListenerImpl.getInstance());
            }
            JavaScriptExecutor.run("");
            if (this.getMetricsPluginId() != -1) {
                new Metrics(this.getMetricsPluginId());
            }
            Common.setTellPrefix(SimpleSettings.PLUGIN_PREFIX);
            Common.runLater(() -> Common.setLogPrefix(oldLogPrefix));
        }
        catch (Throwable t) {
            this.displayError0(t);
        }
    }

    private void loadLibraries() {
        List<Library> manualLibraries;
        int javaVersion = SimplePlugin.getJavaVersion();
        ArrayList<Library> libraries = new ArrayList<Library>();
        if (!ReflectionUtil.isClassAvailable("net.md_5.bungee.api.ChatColor")) {
            libraries.add(Library.fromMavenRepo("net.md-5", "bungeecord-chat", "1.16-R0.4"));
        }
        if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_16)) {
            YamlConfiguration pluginFile = new YamlConfiguration();
            try {
                pluginFile.loadFromString(String.join((CharSequence)"\n", FileUtil.getInternalFileContent("plugin.yml")));
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            for (String libraryPath : pluginFile.getStringList("legacy-libraries")) {
                if (javaVersion < 15 && libraryPath.contains("org.openjdk.nashorn:nashorn-core")) continue;
                Library library = Library.fromMavenRepo(libraryPath);
                libraries.add(library);
            }
            if (!libraries.isEmpty() && javaVersion >= 9) {
                Common.logFramed("Warning: Unsupported Java version: " + javaVersion + " for your server", "version! Minecraft " + MinecraftVersion.getServerVersion() + " was designed for Java 8", "and we're unable unable to load 'legacy-libraries'", "that this plugin uses:", Common.join(libraries, ", ", Library::getGroupId), "", "To fix this, start your server using Java 8 or", "upgrade to Minecraft 1.16 or greater.");
            } else {
                for (Library library : libraries) {
                    library.load();
                }
            }
        }
        if (!(manualLibraries = this.getLibraries()).isEmpty() && javaVersion > 8) {
            Common.warning("The getLibraries() feature only supports Java 8 for now and does not work on Java " + javaVersion + ". To load the following libraries, install Java 8 or upgrade to Minecraft 16 where you use the 'libraries' feature of plugin.yml to load. Skipping loading: " + manualLibraries);
        } else {
            block4: for (Library library : manualLibraries) {
                for (Library otherLibrary : libraries) {
                    if (!library.getArtifactId().equals(otherLibrary.getArtifactId()) || !library.getGroupId().equals(otherLibrary.getGroupId())) continue;
                    Common.warning("Detected library conflict: '" + library.getGroupId() + "." + library.getArtifactId() + "' is defined both in getLibraries() and plugin.yml! We'll prefer the version from plugin.yml, if you want to use the one from getLibraries() then remove it from your plugin.yml file.");
                    continue block4;
                }
                library.load();
            }
        }
    }

    public static int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        if (version.contains("-")) {
            version = version.split("\\-")[0];
        }
        return Integer.parseInt(version);
    }

    @Deprecated
    protected List<Library> getLibraries() {
        return new ArrayList<Library>();
    }

    protected final void registerBungeeCord(@NonNull BungeeListener bungee) {
        if (bungee == null) {
            throw new NullPointerException("bungee is marked non-null but is null");
        }
        Messenger messenger = this.getServer().getMessenger();
        messenger.registerIncomingPluginChannel((Plugin)this, bungee.getChannel(), (PluginMessageListener)bungee);
        messenger.registerOutgoingPluginChannel((Plugin)this, bungee.getChannel());
        this.reloadables.registerEvents(bungee);
    }

    private void checkShading() {
        try {
            throw new ShadingException();
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private boolean checkLibraries0() {
        boolean md_5 = false;
        boolean gson = false;
        try {
            Class.forName("net.md_5.bungee.api.chat.BaseComponent");
            md_5 = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("com.google.gson.JsonSyntaxException");
            gson = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!md_5 || !gson) {
            Bukkit.getLogger().severe(Common.consoleLine());
            Bukkit.getLogger().severe("Your Minecraft version (" + (Object)((Object)MinecraftVersion.getCurrent()) + ")");
            Bukkit.getLogger().severe("lacks libraries " + this.getDataFolder().getName() + " needs:");
            Bukkit.getLogger().severe("JSON Chat (by md_5) found: " + md_5);
            Bukkit.getLogger().severe("Gson (by Google) found: " + gson);
            Bukkit.getLogger().severe(" ");
            Bukkit.getLogger().severe("To fix that, please install BungeeChatAPI:");
            Bukkit.getLogger().severe("https://mineacademy.org/plugins/#misc");
            Bukkit.getLogger().severe(Common.consoleLine());
        }
        return true;
    }

    private boolean checkServerVersions0() {
        MinecraftVersion.V minimumVersion;
        if (!MinecraftVersion.getCurrent().isTested()) {
            Common.logFramed("*** WARNING ***", "Your Minecraft version " + (Object)((Object)MinecraftVersion.getCurrent()) + " has not yet", "been officialy tested with the Foundation,", "the library that " + SimplePlugin.getNamed() + " plugin uses.", "", "Loading the plugin at your own risk...", Common.consoleLine());
        }
        if ((minimumVersion = this.getMinimumVersion()) != null && MinecraftVersion.olderThan(minimumVersion)) {
            Common.logFramed(false, this.getDataFolder().getName() + " requires Minecraft " + (Object)((Object)minimumVersion) + " or newer to run.", "Please upgrade your server.");
            return false;
        }
        MinecraftVersion.V maximumVersion = this.getMaximumVersion();
        if (maximumVersion != null && MinecraftVersion.newerThan(maximumVersion)) {
            Common.logFramed(false, this.getDataFolder().getName() + " requires Minecraft " + (Object)((Object)maximumVersion) + " or older to run.", "Please downgrade your server or", "wait for the new version.");
            return false;
        }
        return true;
    }

    protected final void displayError0(Throwable throwable) {
        Debugger.printStackTrace(throwable);
        boolean privateDistro = this.getServer().getBukkitVersion().contains("1.8.8-R0.2");
        Common.log("&4    ___                  _ ", "&4   / _ \\  ___  _ __  ___| |", "&4  | | | |/ _ \\| '_ \\/ __| |", "&4  | |_| | (_) | |_) \\__ \\_|", "&4   \\___/ \\___/| .__/|___(_)", "&4             |_|          ", "&4!-----------------------------------------------------!", " &cError loading " + this.getDescription().getName() + " v" + this.getDescription().getVersion() + ", plugin is disabled!", privateDistro ? null : " &cRunning on " + this.getServer().getBukkitVersion() + " (" + MinecraftVersion.getServerVersion() + ") & Java " + System.getProperty("java.version"), "&4!-----------------------------------------------------!");
        if (throwable instanceof InvalidConfigurationException) {
            Common.log(" &cSeems like your config is not a valid YAML.");
            Common.log(" &cUse online services like");
            Common.log(" &chttp://yaml-online-parser.appspot.com/");
            Common.log(" &cto check for syntax errors!");
        } else if (throwable instanceof UnsupportedOperationException || throwable.getCause() != null && throwable.getCause() instanceof UnsupportedOperationException) {
            if (this.getServer().getBukkitVersion().startsWith("1.2.5")) {
                Common.log(" &cSorry but Minecraft 1.2.5 is no longer supported!");
            } else {
                Common.log(" &cUnable to setup reflection!");
                Common.log(" &cYour server is either too old or");
                Common.log(" &cthe plugin broke on the new version :(");
            }
        }
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        String error = "Unable to get the error message, search above.";
        if (throwable.getMessage() != null && !throwable.getMessage().isEmpty() && !throwable.getMessage().equals("null")) {
            error = throwable.getMessage();
        }
        Common.log(" &cError: " + error);
        Common.log("&4!-----------------------------------------------------!");
        this.getPluginLoader().disablePlugin((Plugin)this);
    }

    public final void onDisable() {
        try {
            this.onPluginStop();
        }
        catch (Throwable t) {
            Common.log("&cPlugin might not shut down property. Got " + t.getClass().getSimpleName() + ": " + t.getMessage());
        }
        this.unregisterReloadables();
        try {
            for (Player player : Remain.getOnlinePlayers()) {
                SimpleScoreboard.clearBoardsFor(player);
            }
        }
        catch (Throwable t) {
            Common.log("Error clearing scoreboards for players..");
            t.printStackTrace();
        }
        try {
            for (Player player : Remain.getOnlinePlayers()) {
                Menu menu = Menu.getMenu(player);
                if (menu == null) continue;
                player.closeInventory();
            }
        }
        catch (Throwable t) {
            Common.log("Error closing menu inventories for players..");
            t.printStackTrace();
        }
        Objects.requireNonNull(instance, "Instance of " + this.getDataFolder().getName() + " already nulled!");
        instance = null;
    }

    protected void onPluginLoad() {
    }

    protected abstract void onPluginStart();

    protected void onPluginStop() {
    }

    protected void onPluginPreReload() {
    }

    protected void onPluginReload() {
    }

    protected void onReloadablesStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reload() {
        String oldLogPrefix = Common.getLogPrefix();
        Common.setLogPrefix("");
        Common.log(Common.consoleLineSmooth());
        Common.log(" ");
        Common.log("Reloading plugin " + this.getDataFolder().getName() + " v" + SimplePlugin.getVersion());
        Common.log(" ");
        reloading = true;
        try {
            Debugger.detectDebugMode();
            this.unregisterReloadables();
            Messenger messenger = this.getServer().getMessenger();
            if (!messenger.isOutgoingChannelRegistered((Plugin)this, "BungeeCord")) {
                messenger.registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
            }
            try {
                HookManager.loadDependencies();
            }
            catch (Throwable throwable) {
                Common.throwError(throwable, "Error while loading " + this.getDataFolder().getName() + " dependencies!");
            }
            this.onPluginPreReload();
            this.reloadables.reload();
            CompMetadata.MetadataFile metadata = CompMetadata.MetadataFile.getInstance();
            metadata.save();
            metadata.reload();
            SimpleHologram.onReload();
            Common.setTellPrefix(SimpleSettings.PLUGIN_PREFIX);
            this.onPluginReload();
            if (!this.isEnabled()) {
                return;
            }
            this.startingReloadables = true;
            AutoRegisterScanner.scanAndRegister();
            Lang.reloadLang();
            Lang.loadPrefixes();
            this.onReloadablesStart();
            this.startingReloadables = false;
            if (HookManager.isDiscordSRVLoaded()) {
                DiscordListener.DiscordListenerImpl.getInstance().resubscribe();
                this.reloadables.registerEvents(DiscordListener.DiscordListenerImpl.getInstance());
            }
            Common.log(Common.consoleLineSmooth());
        }
        catch (Throwable t) {
            Common.throwError(t, "Error reloading " + this.getDataFolder().getName() + " " + SimplePlugin.getVersion());
        }
        finally {
            Common.setLogPrefix(oldLogPrefix);
            reloading = false;
        }
    }

    private void unregisterReloadables() {
        SimpleSettings.resetSettingsCall();
        SimpleLocalization.resetLocalizationCall();
        BlockVisualizer.stopAll();
        FolderWatcher.stopThreads();
        FileConfig.clearLoadedSections();
        try {
            if (HookManager.isDiscordSRVLoaded()) {
                DiscordListener.clearRegisteredListeners();
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            HookManager.unloadDependencies((Plugin)this);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        this.getServer().getMessenger().unregisterIncomingPluginChannel((Plugin)this);
        this.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this);
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        this.mainCommand = null;
    }

    protected final <T extends Listener> void registerAllEvents(Class<T> extendingClass) {
        Valid.checkBoolean(!extendingClass.equals(Listener.class), "registerAllEvents does not support Listener.class due to conflicts, create your own middle class instead", new Object[0]);
        Valid.checkBoolean(!extendingClass.equals(SimpleListener.class), "registerAllEvents does not support SimpleListener.class due to conflicts, create your own middle class instead", new Object[0]);
        block0: for (Class<T> pluginClass : ReflectionUtil.getClasses((Plugin)instance, extendingClass)) {
            if (pluginClass.isAnnotationPresent(AutoRegister.class)) continue;
            for (Constructor<?> con : pluginClass.getConstructors()) {
                if (con.getParameterCount() != 0) continue;
                Listener instance = (Listener)ReflectionUtil.instantiate(con, new Object[0]);
                this.registerEvents(instance);
                continue block0;
            }
        }
    }

    protected final void registerEvents(Listener listener) {
        if (this.startingReloadables) {
            this.reloadables.registerEvents(listener);
        } else {
            this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
        }
        if (listener instanceof DiscordListener) {
            ((DiscordListener)listener).register();
        }
    }

    protected final void registerEvents(SimpleListener<? extends Event> listener) {
        if (this.startingReloadables) {
            this.reloadables.registerEvents(listener);
        } else {
            listener.register();
        }
    }

    protected final <T extends Command> void registerAllCommands(Class<T> extendingClass) {
        Valid.checkBoolean(!extendingClass.equals(Command.class), "registerAllCommands does not support Command.class due to conflicts, create your own middle class instead", new Object[0]);
        Valid.checkBoolean(!extendingClass.equals(SimpleCommand.class), "registerAllCommands does not support SimpleCommand.class due to conflicts, create your own middle class instead", new Object[0]);
        Valid.checkBoolean(!extendingClass.equals(SimpleSubCommand.class), "registerAllCommands does not support SubCommand.class", new Object[0]);
        block2: for (Class<T> pluginClass : ReflectionUtil.getClasses((Plugin)instance, extendingClass)) {
            if (pluginClass.isAnnotationPresent(AutoRegister.class) || SimpleSubCommand.class.isAssignableFrom(pluginClass)) continue;
            try {
                for (Constructor<?> con : pluginClass.getConstructors()) {
                    if (con.getParameterCount() != 0) continue;
                    Command instance = (Command)ReflectionUtil.instantiate(con, new Object[0]);
                    if (instance instanceof SimpleCommand) {
                        this.registerCommand(instance);
                        continue block2;
                    }
                    this.registerCommand(instance);
                    continue block2;
                }
            }
            catch (LinkageError ex) {
                Common.log("Unable to register commands in '" + pluginClass.getSimpleName() + "' due to error: " + ex);
            }
        }
    }

    protected final void registerCommand(Command command) {
        if (command instanceof SimpleCommand) {
            ((SimpleCommand)command).register();
        } else {
            Remain.registerCommand(command);
        }
    }

    protected final void registerCommands(SimpleCommandGroup group) {
        if (this.startingReloadables) {
            this.reloadables.registerCommands(group);
        } else {
            group.register();
        }
    }

    protected String[] getStartupLogo() {
        return null;
    }

    public MinecraftVersion.V getMinimumVersion() {
        return null;
    }

    public MinecraftVersion.V getMaximumVersion() {
        return null;
    }

    @Nullable
    public SimpleCommandGroup getMainCommand() {
        return this.mainCommand;
    }

    @Deprecated
    public final void setMainCommand(SimpleCommandGroup group) {
        Valid.checkBoolean(this.mainCommand == null, "Main command has already been set to " + this.mainCommand, new Object[0]);
        this.mainCommand = group;
    }

    public int getFoundedYear() {
        return -1;
    }

    public SpigotUpdater getUpdateCheck() {
        return null;
    }

    public int getMetricsPluginId() {
        return -1;
    }

    public Set<String> getConsoleFilter() {
        return new HashSet<String>();
    }

    public int getRegexTimeout() {
        throw new FoException("Must override getRegexTimeout()");
    }

    public boolean regexStripColors() {
        return true;
    }

    public boolean regexCaseInsensitive() {
        return true;
    }

    public boolean regexUnicode() {
        return true;
    }

    public boolean regexStripAccents() {
        return true;
    }

    public boolean similarityStripAccents() {
        return true;
    }

    public boolean suggestPaper() {
        return true;
    }

    @Deprecated
    public final BungeeListener getBungeeCord() {
        return this.bungeeListener;
    }

    @Deprecated
    public final void setBungeeCord(BungeeListener bungeeListener) {
        this.bungeeListener = bungeeListener;
    }

    public boolean areToolsEnabled() {
        return true;
    }

    public final ClassLoader getClazzLoader() {
        return this.getClassLoader();
    }

    protected final File getFile() {
        return super.getFile();
    }

    @Deprecated
    public final PluginCommand getCommand(String name) {
        return super.getCommand(name);
    }

    @Deprecated
    public final boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        throw this.unsupported("onCommand");
    }

    @Deprecated
    public final List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        throw this.unsupported("onTabComplete");
    }

    @Deprecated
    public final FileConfiguration getConfig() {
        throw this.unsupported("getConfig");
    }

    @Deprecated
    public final void saveConfig() {
        throw this.unsupported("saveConfig");
    }

    @Deprecated
    public final void saveDefaultConfig() {
        throw this.unsupported("saveDefaultConfig");
    }

    @Deprecated
    public final void reloadConfig() {
        throw new FoException("Cannot call reloadConfig in " + this.getDataFolder().getName() + ", use reload()!");
    }

    private FoException unsupported(String method) {
        return new FoException("Cannot call " + method + " in " + this.getDataFolder().getName() + ", use YamlConfig or SimpleCommand classes in Foundation for that!");
    }

    public static String getVersion() {
        return version;
    }

    public static String getNamed() {
        return named;
    }

    public static File getSource() {
        return source;
    }

    public static File getData() {
        return data;
    }

    public static boolean isReloading() {
        return reloading;
    }

    static {
        reloading = false;
        if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_4) && !ReflectionUtil.isClassAvailable("org.bukkit.Sound")) {
            Bukkit.getLogger().severe("Ancient MC version detected, please follow install steps here: https://mineacademy.org/oldmcsupport");
            Bukkit.getLogger().severe("Please note that many features won't work and due to time constraints we can't provide support for such old Minecraft versions.");
            throw new RuntimeException("Ancient MC detected, see above for installation steps.");
        }
        FoundationFilter.inject();
    }

    private class ShadingException
    extends Throwable {
        private static final long serialVersionUID = 1L;

        public ShadingException() {
            if (!SimplePlugin.getNamed().equals(SimplePlugin.this.getDescription().getName())) {
                Bukkit.getLogger().severe(Common.consoleLine());
                Bukkit.getLogger().severe("We have a class path problem in the Foundation library");
                Bukkit.getLogger().severe("preventing " + SimplePlugin.this.getDescription().getName() + " from loading correctly!");
                Bukkit.getLogger().severe("");
                Bukkit.getLogger().severe("This is likely caused by two plugins having the");
                Bukkit.getLogger().severe("same Foundation library paths - make sure you");
                Bukkit.getLogger().severe("relocale the package! If you are testing using");
                Bukkit.getLogger().severe("Ant, only test one plugin at the time.");
                Bukkit.getLogger().severe("");
                Bukkit.getLogger().severe("Possible cause: " + SimplePlugin.getNamed());
                Bukkit.getLogger().severe("Foundation package: " + SimplePlugin.class.getPackage().getName());
                Bukkit.getLogger().severe(Common.consoleLine());
                throw new FoException("Shading exception, see above for details.");
            }
        }
    }
}

