/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.plugin;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;

public final class Library {
    private static final int JAVA_VERSION = SimplePlugin.getJavaVersion();
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String jarPath;
    @Nullable
    private MinecraftVersion.V minimumMinecraftVersion;
    @Nullable
    private MinecraftVersion.V maximumMinecraftVersion;
    @Nullable
    private Integer minimumJavaVersion;
    @Nullable
    private Integer maximumJavaVersion;
    @Nullable
    private String userAgent = null;

    private Library(String groupId, String artifactId, String version, String repositoryPath) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.jarPath = repositoryPath;
    }

    public boolean load() {
        Valid.checkBoolean(JAVA_VERSION <= 8, "Library feature requires Java 8 and does not work on Java " + JAVA_VERSION, new Object[0]);
        if (this.minimumJavaVersion != null && JAVA_VERSION < this.minimumJavaVersion) {
            return false;
        }
        if (this.maximumJavaVersion != null && JAVA_VERSION > this.maximumJavaVersion) {
            return false;
        }
        if (this.minimumMinecraftVersion != null && MinecraftVersion.olderThan(this.minimumMinecraftVersion)) {
            return false;
        }
        if (this.maximumMinecraftVersion != null && MinecraftVersion.newerThan(this.maximumMinecraftVersion)) {
            return false;
        }
        try {
            URL url;
            File libraries = new File(Bukkit.getWorldContainer(), "libraries");
            File file = new File(libraries, this.groupId.replace(".", "/") + "/" + this.artifactId.replace(".", "/") + "/" + this.version + "/" + this.artifactId + "-" + this.version + ".jar");
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                Bukkit.getLogger().info("Downloading library: " + this.getName());
                url = new URL(this.jarPath);
                URLConnection connection = url.openConnection();
                if (this.userAgent != null) {
                    connection.setRequestProperty("User-Agent", this.userAgent);
                }
                try (InputStream in = connection.getInputStream();){
                    Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            url = file.toURI().toURL();
            ClassLoader classLoader = SimplePlugin.class.getClassLoader();
            Method method = ReflectionUtil.getDeclaredMethod(URLClassLoader.class, "addURL", URL.class);
            ReflectionUtil.invoke(method, (Object)classLoader, url);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Unable to load library " + this.getName() + ".", throwable);
        }
        return true;
    }

    public String getName() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    public String toString() {
        return this.getName();
    }

    public static Library fromMavenRepo(String path) {
        String[] split = path.split("\\:");
        Valid.checkBoolean(split.length == 3, "Malformed library path, expected <groupId>:<name>:<version>, got: " + path, new Object[0]);
        return Library.fromMavenRepo(split[0], split[1], split[2]);
    }

    public static Library fromMavenRepo(String groupId, String artifactId, String version) {
        String jarPath = "https://repo1.maven.org/maven2/" + groupId.replace(".", "/") + "/" + artifactId + "/" + version + "/" + artifactId + "-" + version + ".jar";
        return new Library(groupId, artifactId, version, jarPath);
    }

    public static Library fromPath(String groupId, String artifactId, String version, String jarPath) {
        return new Library(groupId, artifactId, version, jarPath);
    }

    public Library setMinimumMinecraftVersion(@Nullable MinecraftVersion.V minimumMinecraftVersion) {
        this.minimumMinecraftVersion = minimumMinecraftVersion;
        return this;
    }

    public Library setMaximumMinecraftVersion(@Nullable MinecraftVersion.V maximumMinecraftVersion) {
        this.maximumMinecraftVersion = maximumMinecraftVersion;
        return this;
    }

    public Library setMinimumJavaVersion(@Nullable Integer minimumJavaVersion) {
        this.minimumJavaVersion = minimumJavaVersion;
        return this;
    }

    public Library setMaximumJavaVersion(@Nullable Integer maximumJavaVersion) {
        this.maximumJavaVersion = maximumJavaVersion;
        return this;
    }

    public Library setUserAgent(@Nullable String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }
}

