/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.plugin;

import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.ServiceRegisterEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.MathUtil;
import sk.adonikeoffice.epicchat.lib.Messenger;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.PlayerUtil;
import sk.adonikeoffice.epicchat.lib.model.ChatPaginator;
import sk.adonikeoffice.epicchat.lib.model.HookManager;
import sk.adonikeoffice.epicchat.lib.model.SimpleComponent;
import sk.adonikeoffice.epicchat.lib.model.SimpleScoreboard;
import sk.adonikeoffice.epicchat.lib.model.SpigotUpdater;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.settings.SimpleLocalization;

final class FoundationListener
implements Listener {
    FoundationListener() {
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onQuit(PlayerQuitEvent event) {
        SimpleScoreboard.clearBoardsFor(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onServiceRegister(ServiceRegisterEvent event) {
        HookManager.updateVaultIntegration();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        String message = event.getMessage();
        if (!message.startsWith("/#flp")) {
            return;
        }
        String[] args = message.split(" ");
        if (args.length != 2) {
            Common.tell((CommandSender)player, SimpleLocalization.Pages.NO_PAGE_NUMBER);
            event.setCancelled(true);
            return;
        }
        String nbtPageTag = ChatPaginator.getPageNbtTag();
        if (!player.hasMetadata(nbtPageTag)) {
            event.setCancelled(true);
            return;
        }
        if (player.hasMetadata("FoPages") && !((MetadataValue)player.getMetadata("FoPages").get(0)).asString().equals(SimplePlugin.getNamed())) {
            return;
        }
        String numberRaw = args[1];
        int page = -1;
        try {
            page = Integer.parseInt(numberRaw) - 1;
        }
        catch (NumberFormatException ex) {
            Common.tell((CommandSender)player, SimpleLocalization.Pages.INVALID_PAGE.replace("{input}", numberRaw));
            event.setCancelled(true);
            return;
        }
        ChatPaginator chatPages = (ChatPaginator)((MetadataValue)player.getMetadata(nbtPageTag).get(0)).value();
        Map<Integer, List<SimpleComponent>> pages = chatPages.getPages();
        pages.entrySet().removeIf(entry -> ((List)entry.getValue()).isEmpty());
        if (!pages.containsKey(page)) {
            String playerMessage = SimpleLocalization.Pages.NO_PAGE;
            if (Messenger.ENABLED) {
                Messenger.error((CommandSender)player, playerMessage);
            } else {
                Common.tell((CommandSender)player, playerMessage);
            }
            event.setCancelled(true);
            return;
        }
        for (SimpleComponent component : chatPages.getHeader()) {
            component.send((CommandSender[])new Player[]{player});
        }
        List<SimpleComponent> messagesOnPage = pages.get(page);
        int count = 1;
        for (SimpleComponent comp : messagesOnPage) {
            comp.replace("{count}", page + count++).send((CommandSender[])new Player[]{player});
        }
        int whiteLines = chatPages.getLinesPerPage();
        if (whiteLines == 15 && pages.size() == 1) {
            whiteLines = messagesOnPage.size() < 17 ? 7 : (whiteLines += 2);
        }
        for (int i = messagesOnPage.size(); i < whiteLines; ++i) {
            SimpleComponent.of("&r").send((CommandSender[])new Player[]{player});
        }
        for (SimpleComponent component : chatPages.getFooter()) {
            component.send((CommandSender[])new Player[]{player});
        }
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_7) && pages.size() > 1) {
            Common.tellNoPrefix((CommandSender)player, " ");
            int pagesDigits = (int)(Math.log10(pages.size()) + 1.0);
            int multiply = 23 - (int)MathUtil.ceiling(pagesDigits);
            SimpleComponent pagination = SimpleComponent.of(chatPages.getThemeColor() + "&m" + Common.duplicate("-", multiply) + "&r");
            if (page == 0) {
                pagination.append(" &7\u00ab ");
            } else {
                pagination.append(" &6\u00ab ").onHover(SimpleLocalization.Pages.GO_TO_PAGE.replace("{page}", String.valueOf(page))).onClickRunCmd("/#flp " + page);
            }
            pagination.append("&f" + (page + 1)).onHover(SimpleLocalization.Pages.GO_TO_FIRST_PAGE).onClickRunCmd("/#flp 1");
            pagination.append("/");
            pagination.append(pages.size() + "").onHover(SimpleLocalization.Pages.TOOLTIP);
            if (page + 1 >= pages.size()) {
                pagination.append(" &7\u00bb ");
            } else {
                pagination.append(" &6\u00bb ").onHover(SimpleLocalization.Pages.GO_TO_PAGE.replace("{page}", String.valueOf(page + 2))).onClickRunCmd("/#flp " + (page + 2));
            }
            pagination.append(chatPages.getThemeColor() + "&m" + Common.duplicate("-", multiply));
            pagination.send((CommandSender[])new Player[]{player});
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        SpigotUpdater check = SimplePlugin.getInstance().getUpdateCheck();
        if (check != null && check.isNewVersionAvailable() && PlayerUtil.hasPerm((Permissible)player, check.getPermission().replace("{plugin_name}", SimplePlugin.getNamed().toLowerCase().replace(" ", "_")))) {
            Common.tellLater(80, (CommandSender)player, check.getNotifyMessage());
        }
        if (!player.hasMetadata("vanished")) {
            boolean essVanished = HookManager.isVanishedEssentials(player);
            boolean cmiVanished = HookManager.isVanishedCMI(player);
            boolean advVanished = HookManager.isVanishedAdvancedVanish(player);
            if (essVanished || cmiVanished || advVanished) {
                Plugin plugin = Bukkit.getPluginManager().getPlugin(essVanished ? "Essentials" : (cmiVanished ? "CMI" : "AdvancedVanish"));
                player.setMetadata("vanished", (MetadataValue)new FixedMetadataValue(plugin, (Object)true));
            }
        }
    }
}

