/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.plugin;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.annotation.AutoRegister;
import sk.adonikeoffice.epicchat.lib.bungee.BungeeListener;
import sk.adonikeoffice.epicchat.lib.command.SimpleCommand;
import sk.adonikeoffice.epicchat.lib.command.SimpleCommandGroup;
import sk.adonikeoffice.epicchat.lib.command.SimpleSubCommand;
import sk.adonikeoffice.epicchat.lib.event.SimpleListener;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.menu.tool.Tool;
import sk.adonikeoffice.epicchat.lib.model.DiscordListener;
import sk.adonikeoffice.epicchat.lib.model.FoundationEnchantmentListener;
import sk.adonikeoffice.epicchat.lib.model.HookManager;
import sk.adonikeoffice.epicchat.lib.model.PacketListener;
import sk.adonikeoffice.epicchat.lib.model.SimpleEnchantment;
import sk.adonikeoffice.epicchat.lib.model.SimpleExpansion;
import sk.adonikeoffice.epicchat.lib.model.Tuple;
import sk.adonikeoffice.epicchat.lib.model.Variables;
import sk.adonikeoffice.epicchat.lib.plugin.EnchantmentPacketListener;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.remain.Remain;
import sk.adonikeoffice.epicchat.lib.settings.SimpleLocalization;
import sk.adonikeoffice.epicchat.lib.settings.SimpleSettings;
import sk.adonikeoffice.epicchat.lib.settings.YamlConfig;
import sk.adonikeoffice.epicchat.lib.settings.YamlStaticConfig;

final class AutoRegisterScanner {
    private static boolean enchantListenersRegistered = false;
    private static boolean bungeeListenerRegistered = false;
    private static List<SimpleCommandGroup> registeredCommandGroups = new ArrayList<SimpleCommandGroup>();

    AutoRegisterScanner() {
    }

    public static void scanAndRegister() {
        enchantListenersRegistered = false;
        bungeeListenerRegistered = false;
        registeredCommandGroups.clear();
        List<Class<?>> classes = AutoRegisterScanner.findValidClasses();
        AutoRegisterScanner.registerSettings(classes);
        for (Class<?> clazz : classes) {
            try {
                AutoRegister autoRegister;
                try {
                    for (Method method : clazz.getMethods()) {
                        if (!method.isAnnotationPresent(EventHandler.class)) continue;
                        Valid.checkBoolean(Listener.class.isAssignableFrom(clazz), "Detected @EventHandler in " + clazz + ", make this class 'implements Listener' before using events there", new Object[0]);
                    }
                }
                catch (Error error) {
                    // empty catch block
                }
                if (YamlStaticConfig.class.isAssignableFrom(clazz) || (autoRegister = clazz.getAnnotation(AutoRegister.class)) == null && !Tool.class.isAssignableFrom(clazz) && !SimpleEnchantment.class.isAssignableFrom(clazz) && !BungeeListener.class.isAssignableFrom(clazz) && !SimpleExpansion.class.isAssignableFrom(clazz) && !PacketListener.class.isAssignableFrom(clazz) && !DiscordListener.class.isAssignableFrom(clazz)) continue;
                Valid.checkBoolean(!SimpleSubCommand.class.isAssignableFrom(clazz), "@AutoRegister cannot be used on sub command class: " + clazz + "! Rather write registerSubcommand(Class) in registerSubcommands() method where Class is your own middle-men abstract class extending SimpleSubCommand that all of your subcommands extend.", new Object[0]);
                Valid.checkBoolean(Modifier.isFinal(clazz.getModifiers()), "Please make " + clazz + " final for it to be registered automatically (or via @AutoRegister)", new Object[0]);
                try {
                    AutoRegisterScanner.autoRegister(clazz, autoRegister == null || !autoRegister.hideIncompatibilityWarnings());
                }
                catch (NoClassDefFoundError | NoSuchFieldError ex) {
                    Bukkit.getLogger().warning("Failed to auto register " + clazz + " due to it requesting missing fields/classes: " + ex.getMessage());
                }
                catch (Throwable t) {
                    String error = Common.getOrEmpty(t.getMessage());
                    if (t instanceof NoClassDefFoundError && error.contains("org/bukkit/entity")) {
                        Bukkit.getLogger().warning("**** WARNING ****");
                        if (error.contains("DragonFireball")) {
                            Bukkit.getLogger().warning("Your Minecraft version does not have DragonFireball class, we suggest replacing it with a Fireball instead in: " + clazz);
                            continue;
                        }
                        Bukkit.getLogger().warning("Your Minecraft version does not have " + error + " class you call in: " + clazz);
                        continue;
                    }
                    Common.error(t, "Failed to auto register class " + clazz);
                }
            }
            catch (Throwable t) {
                if (t instanceof VerifyError) continue;
                Common.error(t, "Failed to scan class '" + clazz + "' using Foundation!");
            }
        }
        AutoRegisterScanner.registerCommandGroups();
    }

    private static void registerSettings(List<Class<?>> classes) {
        ArrayList staticSettingsFound = new ArrayList();
        ArrayList staticLocalizations = new ArrayList();
        ArrayList staticCustom = new ArrayList();
        for (Class<?> clazz : classes) {
            boolean load = false;
            if (clazz == SimpleLocalization.class || clazz == SimpleSettings.class || clazz == YamlStaticConfig.class) continue;
            if (SimpleSettings.class.isAssignableFrom(clazz)) {
                staticSettingsFound.add(clazz);
                load = true;
            }
            if (SimpleLocalization.class.isAssignableFrom(clazz)) {
                staticLocalizations.add(clazz);
                load = true;
            }
            if (!load && (load || !YamlStaticConfig.class.isAssignableFrom(clazz))) continue;
            staticCustom.add(clazz);
        }
        boolean staticSettingsFileExist = false;
        boolean staticLocalizationFileExist = false;
        try (JarFile jarFile22 = new JarFile(SimplePlugin.getSource());){
            Enumeration<JarEntry> it = jarFile22.entries();
            while (it.hasMoreElements()) {
                JarEntry jarEntry = it.nextElement();
                String name = jarEntry.getName();
                if (name.matches("settings\\.yml")) {
                    staticSettingsFileExist = true;
                    continue;
                }
                if (!name.matches("localization\\/messages\\_(.*)\\.yml")) continue;
                staticLocalizationFileExist = true;
            }
        }
        catch (IOException jarFile22) {
            // empty catch block
        }
        Valid.checkBoolean(staticSettingsFound.size() < 2, "Cannot have more than one class extend SimpleSettings: " + staticSettingsFound, new Object[0]);
        Valid.checkBoolean(staticLocalizations.size() < 2, "Cannot have more than one class extend SimpleLocalization: " + staticLocalizations, new Object[0]);
        if (staticSettingsFound.isEmpty() && staticSettingsFileExist) {
            YamlStaticConfig.load(SimpleSettings.class);
        }
        if (staticLocalizations.isEmpty() && staticLocalizationFileExist) {
            YamlStaticConfig.load(SimpleLocalization.class);
        }
        ArrayList<Class> delayedLoading = new ArrayList<Class>();
        for (Class clazz : staticCustom) {
            if (SimpleSettings.class.isAssignableFrom(clazz)) {
                YamlStaticConfig.load(clazz);
                continue;
            }
            delayedLoading.add(clazz);
        }
        for (Class clazz : delayedLoading) {
            YamlStaticConfig.load(clazz);
        }
    }

    private static void registerCommandGroups() {
        boolean mainCommandGroupFound = false;
        for (SimpleCommandGroup group : registeredCommandGroups) {
            if (group.getLabel().equals(SimpleSettings.MAIN_COMMAND_ALIASES.first()) || registeredCommandGroups.size() == 1) {
                Valid.checkBoolean(!mainCommandGroupFound, "Found 2 or more command groups that do not specify label in their constructor. (We can only automatically use one of such groups as the main one using Command_Aliases as command label(s) from settings.yml but not more.", new Object[0]);
                SimplePlugin.getInstance().setMainCommand(group);
                mainCommandGroupFound = true;
            }
            SimplePlugin.getInstance().registerCommands(group);
        }
    }

    private static void autoRegister(Class<?> clazz, boolean printWarnings) {
        if (SimpleEnchantment.class.isAssignableFrom(clazz) && MinecraftVersion.olderThan(MinecraftVersion.V.v1_13)) {
            if (printWarnings) {
                Bukkit.getLogger().warning("**** WARNING ****");
                Bukkit.getLogger().warning("SimpleEnchantment requires Minecraft 1.13.2 or greater. The following class will not be registered: " + clazz.getName() + ". To hide this message, put @AutoRegister(hideIncompatibilityWarnings=true) over the class.");
            }
            return;
        }
        if (DiscordListener.class.isAssignableFrom(clazz) && !HookManager.isDiscordSRVLoaded()) {
            if (printWarnings) {
                Bukkit.getLogger().warning("**** WARNING ****");
                Bukkit.getLogger().warning("The following class requires DiscordSRV and won't be registered: " + clazz.getName() + ". To hide this message, put @AutoRegister(hideIncompatibilityWarnings=true) over the class.");
            }
            return;
        }
        if (PacketListener.class.isAssignableFrom(clazz) && !HookManager.isProtocolLibLoaded()) {
            if (printWarnings && !clazz.equals(EnchantmentPacketListener.class)) {
                Bukkit.getLogger().warning("**** WARNING ****");
                Bukkit.getLogger().warning("The following class requires ProtocolLib and won't be registered: " + clazz.getName() + ". To hide this message, put @AutoRegister(hideIncompatibilityWarnings=true) over the class.");
            }
            return;
        }
        SimplePlugin plugin = SimplePlugin.getInstance();
        Tuple<FindInstance, Object> tuple = AutoRegisterScanner.findInstance(clazz);
        FindInstance mode = tuple.getKey();
        Object instance = tuple.getValue();
        boolean eventsRegistered = false;
        if (SimpleListener.class.isAssignableFrom(clazz)) {
            AutoRegisterScanner.enforceModeFor(clazz, mode, FindInstance.SINGLETON);
            plugin.registerEvents((SimpleListener)instance);
            eventsRegistered = true;
        } else if (BungeeListener.class.isAssignableFrom(clazz)) {
            AutoRegisterScanner.enforceModeFor(clazz, mode, FindInstance.SINGLETON);
            if (!bungeeListenerRegistered) {
                bungeeListenerRegistered = true;
                plugin.setBungeeCord((BungeeListener)instance);
            }
            plugin.registerBungeeCord((BungeeListener)instance);
            eventsRegistered = true;
        } else if (SimpleCommand.class.isAssignableFrom(clazz)) {
            plugin.registerCommand((SimpleCommand)((Object)instance));
        } else if (SimpleCommandGroup.class.isAssignableFrom(clazz)) {
            SimpleCommandGroup group = (SimpleCommandGroup)instance;
            registeredCommandGroups.add(group);
        } else if (SimpleExpansion.class.isAssignableFrom(clazz)) {
            AutoRegisterScanner.enforceModeFor(clazz, mode, FindInstance.SINGLETON);
            Variables.addExpansion((SimpleExpansion)instance);
        } else if (YamlConfig.class.isAssignableFrom(clazz)) {
            AutoRegisterScanner.enforceModeFor(clazz, mode, FindInstance.SINGLETON);
            if (SimplePlugin.isReloading()) {
                ((YamlConfig)instance).save();
                ((YamlConfig)instance).reload();
            }
        } else if (PacketListener.class.isAssignableFrom(clazz)) {
            AutoRegisterScanner.enforceModeFor(clazz, mode, FindInstance.SINGLETON);
            ((PacketListener)instance).onRegister();
        } else if (DiscordListener.class.isAssignableFrom(clazz)) {
            AutoRegisterScanner.enforceModeFor(clazz, mode, FindInstance.SINGLETON);
        } else if (SimpleEnchantment.class.isAssignableFrom(clazz)) {
            AutoRegisterScanner.enforceModeFor(clazz, mode, FindInstance.SINGLETON);
            if (!enchantListenersRegistered) {
                plugin.registerEvents(FoundationEnchantmentListener.getInstance());
                EnchantmentPacketListener.getInstance().onRegister();
            }
            enchantListenersRegistered = true;
        } else if (Tool.class.isAssignableFrom(clazz)) {
            AutoRegisterScanner.enforceModeFor(clazz, mode, FindInstance.SINGLETON);
        } else if (!(instance instanceof Listener)) {
            throw new FoException("@AutoRegister cannot be used on " + clazz);
        }
        if (!eventsRegistered && instance instanceof Listener) {
            plugin.registerEvents((Listener)instance);
        }
    }

    private static List<Class<?>> findValidClasses() {
        ArrayList classes = new ArrayList();
        Pattern anonymousClassPattern = Pattern.compile("\\w+\\$[0-9]$");
        try (JarFile file = new JarFile(SimplePlugin.getSource());){
            Enumeration<JarEntry> entry = file.entries();
            while (entry.hasMoreElements()) {
                JarEntry jar = entry.nextElement();
                String name = jar.getName().replace("/", ".");
                if (!name.endsWith(".class")) continue;
                String className = name.substring(0, name.length() - 6);
                Class<?> clazz = null;
                try {
                    clazz = SimplePlugin.class.getClassLoader().loadClass(className);
                }
                catch (ClassFormatError | ClassNotFoundException | IncompatibleClassChangeError | NoClassDefFoundError | VerifyError error) {
                    continue;
                }
                if (Modifier.isAbstract(clazz.getModifiers()) || anonymousClassPattern.matcher(className).find()) continue;
                classes.add(clazz);
            }
        }
        catch (Throwable t) {
            Remain.sneaky(t);
        }
        return classes;
    }

    private static Tuple<FindInstance, Object> findInstance(Class<?> clazz) {
        Constructor<?> constructor;
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        Object instance = null;
        FindInstance mode = null;
        if (constructors.length == 1 && (constructor = constructors[0]).getParameterCount() == 0) {
            int modifiers = constructor.getModifiers();
            if (Modifier.isPublic(modifiers)) {
                instance = ReflectionUtil.instantiate(constructor, new Object[0]);
                mode = FindInstance.NEW_FROM_CONSTRUCTOR;
            } else if (Modifier.isPrivate(modifiers)) {
                Field instanceField = null;
                for (Field field : clazz.getDeclaredFields()) {
                    int fieldMods = field.getModifiers();
                    if (!Modifier.isPrivate(fieldMods) || !Modifier.isStatic(fieldMods) || !Modifier.isFinal(fieldMods) && !Modifier.isVolatile(fieldMods)) continue;
                    instanceField = field;
                }
                if (instanceField != null) {
                    instance = ReflectionUtil.getFieldContent(instanceField, null);
                    mode = FindInstance.SINGLETON;
                }
            }
        }
        Valid.checkNotNull(instance, "Your class " + clazz + " using @AutoRegister must EITHER have 1) one public no arguments constructor, OR 2) one private no arguments constructor plus a 'private static final " + clazz.getSimpleName() + " instance' instance field.");
        return new Tuple<FindInstance, Object>(mode, instance);
    }

    private static void enforceModeFor(Class<?> clazz, FindInstance actual, FindInstance required) {
        Valid.checkBoolean(required == actual, clazz + " using @AutoRegister must have " + (required == FindInstance.NEW_FROM_CONSTRUCTOR ? "a single public no args constructor" : "one private no args constructor plus a 'private static final " + clazz.getSimpleName() + " instance' field to be a singleton'"), new Object[0]);
    }

    static enum FindInstance {
        NEW_FROM_CONSTRUCTOR,
        SINGLETON;

    }
}

