/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.model.WorldEditHook;
import sk.adonikeoffice.epicchat.lib.region.Region;

class WorldGuardHook {
    private final boolean legacy;

    public WorldGuardHook(WorldEditHook we) {
        Plugin wg = Bukkit.getPluginManager().getPlugin("WorldGuard");
        this.legacy = !wg.getDescription().getVersion().startsWith("7") || we != null && we.legacy;
    }

    public List<String> getRegionsAt(Location location) {
        ArrayList<String> list = new ArrayList<String>();
        this.getApplicableRegions(location).forEach(region -> {
            String name = Common.stripColors(region.getId());
            if (!name.startsWith("__")) {
                list.add(name);
            }
        });
        return list;
    }

    public Region getRegion(String name) {
        for (World w : Bukkit.getWorlds()) {
            Object rm = this.getRegionManager(w);
            if (this.legacy) {
                try {
                    Map regionMap = (Map)rm.getClass().getMethod("getRegions", new Class[0]).invoke(rm, new Object[0]);
                    for (Object regObj : regionMap.values()) {
                        if (regObj == null || !Common.stripColors(((ProtectedRegion)regObj).getId()).equals(name)) continue;
                        Class<?> clazz = regObj.getClass();
                        Method getMax = clazz.getMethod("getMaximumPoint", new Class[0]);
                        Method getMin = clazz.getMethod("getMinimumPoint", new Class[0]);
                        Object regMax = getMax.invoke(regObj, new Object[0]);
                        Object regMin = getMin.invoke(regObj, new Object[0]);
                        Class<?> vectorClass = Class.forName("com.sk89q.worldedit.BlockVector");
                        Method getX = vectorClass.getMethod("getX", new Class[0]);
                        Method getY = vectorClass.getMethod("getY", new Class[0]);
                        Method getZ = vectorClass.getMethod("getZ", new Class[0]);
                        Location locMax = new Location(w, ((Double)getX.invoke(regMax, new Object[0])).doubleValue(), ((Double)getY.invoke(regMax, new Object[0])).doubleValue(), ((Double)getZ.invoke(regMax, new Object[0])).doubleValue());
                        Location locMin = new Location(w, ((Double)getX.invoke(regMin, new Object[0])).doubleValue(), ((Double)getY.invoke(regMin, new Object[0])).doubleValue(), ((Double)getZ.invoke(regMin, new Object[0])).doubleValue());
                        return new Region(name, locMin, locMax);
                    }
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    throw new FoException("Failed WorldEdit 6 legacy hook, see above & report");
                }
            }
            for (ProtectedRegion reg : ((RegionManager)rm).getRegions().values()) {
                if (reg == null || reg.getId() == null || !Common.stripColors(reg.getId()).equals(name)) continue;
                BlockVector3 regMax = reg.getMaximumPoint();
                BlockVector3 regMin = reg.getMinimumPoint();
                Location locMax = new Location(w, (double)regMax.getX(), (double)regMax.getY(), (double)regMax.getZ());
                Location locMin = new Location(w, (double)regMin.getX(), (double)regMin.getY(), (double)regMin.getZ());
                return new Region(name, locMin, locMax);
            }
        }
        return null;
    }

    public List<String> getAllRegions() {
        ArrayList<String> list = new ArrayList<String>();
        for (World w : Bukkit.getWorlds()) {
            Object rm = this.getRegionManager(w);
            if (this.legacy) {
                try {
                    Map regionMap = (Map)rm.getClass().getMethod("getRegions", new Class[0]).invoke(rm, new Object[0]);
                    Method getId = null;
                    for (Object regObj : regionMap.values()) {
                        String name;
                        if (regObj == null) continue;
                        if (getId == null) {
                            getId = regObj.getClass().getMethod("getId", new Class[0]);
                        }
                        if ((name = Common.stripColors(getId.invoke(regObj, new Object[0]).toString())).startsWith("__")) continue;
                        list.add(name);
                    }
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    throw new FoException("Failed WorldEdit 6 legacy hook, see above & report");
                }
            }
            ((RegionManager)rm).getRegions().values().forEach(reg -> {
                if (reg == null || reg.getId() == null) {
                    return;
                }
                String name = Common.stripColors(reg.getId());
                if (!name.startsWith("__")) {
                    list.add(name);
                }
            });
        }
        return list;
    }

    private Iterable<ProtectedRegion> getApplicableRegions(Location loc) {
        Object rm = this.getRegionManager(loc.getWorld());
        if (this.legacy) {
            try {
                return (Iterable)rm.getClass().getMethod("getApplicableRegions", Location.class).invoke(rm, loc);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new FoException("Failed WorldEdit 6 legacy hook, see above & report");
            }
        }
        return ((RegionManager)rm).getApplicableRegions(BlockVector3.at((double)loc.getX(), (double)loc.getY(), (double)loc.getZ()));
    }

    private Object getRegionManager(World w) {
        if (this.legacy) {
            try {
                return Class.forName("com.sk89q.worldguard.bukkit.WGBukkit").getMethod("getRegionManager", World.class).invoke(null, w);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new FoException("Failed WorldGuard 6 legacy hook, see above & report");
            }
        }
        try {
            Class<?> bwClass = Class.forName("com.sk89q.worldedit.bukkit.BukkitWorld");
            Constructor<?> bwClassNew = bwClass.getConstructor(World.class);
            Object t = Class.forName("com.sk89q.worldguard.WorldGuard").getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            t = t.getClass().getMethod("getPlatform", new Class[0]).invoke(t, new Object[0]);
            t = t.getClass().getMethod("getRegionContainer", new Class[0]).invoke(t, new Object[0]);
            return t.getClass().getMethod("get", Class.forName("com.sk89q.worldedit.world.World")).invoke(t, bwClassNew.newInstance(w));
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new FoException("Failed WorldGuard hook, see above & report");
        }
    }
}

