/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import sk.adonikeoffice.epicchat.lib.Valid;

public final class Whiteblacklist {
    private final Set<String> items;
    private final boolean whitelist;
    private final boolean entireList;

    public Whiteblacklist(@NonNull List<String> items) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        if (!items.isEmpty()) {
            String firstLine = items.get(0);
            String secondLine = items.size() > 1 ? items.get(1) : "";
            boolean entireList = false;
            boolean whitelist = true;
            if ("*".equals(firstLine) || "*".equals(secondLine)) {
                entireList = true;
            }
            if ("@blacklist".equals(firstLine) || "@blacklist".equals(secondLine)) {
                whitelist = false;
            }
            ArrayList<String> copyList = new ArrayList<String>();
            for (String oldItem : items) {
                if ("*".equals(oldItem) || "@blacklist".equals(oldItem)) continue;
                copyList.add(oldItem);
            }
            this.items = new HashSet<String>(copyList);
            this.whitelist = whitelist;
            this.entireList = entireList;
        } else {
            this.items = new HashSet<String>();
            this.whitelist = true;
            this.entireList = false;
        }
    }

    public boolean isInList(Collection<String> items) {
        if (this.entireList) {
            if (this.whitelist && !items.isEmpty()) {
                return true;
            }
            if (!this.whitelist && items.isEmpty()) {
                return true;
            }
        }
        for (String item : items) {
            if (!this.isInList(item)) continue;
            return true;
        }
        return false;
    }

    public boolean isInList(String item) {
        if (this.entireList) {
            return this.whitelist;
        }
        boolean match = Valid.isInList(item, this.items);
        return this.whitelist ? match : !match;
    }

    public boolean isInListRegex(String item) {
        if (this.entireList) {
            return this.whitelist;
        }
        boolean match = Valid.isInListRegex(item, this.items);
        return this.whitelist ? match : !match;
    }

    public boolean isInListStartsWith(String item) {
        if (this.entireList) {
            return this.whitelist;
        }
        boolean match = Valid.isInListStartsWith(item, this.items);
        return this.whitelist ? match : !match;
    }

    public String toString() {
        return "{" + (this.entireList ? "entire list" : (this.whitelist ? "whitelist" : "blacklist")) + " " + this.items + "}";
    }

    public Set<String> getItems() {
        return this.items;
    }

    public boolean isWhitelist() {
        return this.whitelist;
    }

    public boolean isEntireList() {
        return this.entireList;
    }
}

