/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import java.util.ArrayList;
import lombok.NonNull;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;
import sk.adonikeoffice.epicchat.lib.Common;

class VaultHook {
    private Chat chat;
    private Economy economy;
    private Permission permissions;

    VaultHook() {
        this.setIntegration();
    }

    void setIntegration() {
        RegisteredServiceProvider economyProvider = Bukkit.getServicesManager().getRegistration(Economy.class);
        RegisteredServiceProvider chatProvider = Bukkit.getServicesManager().getRegistration(Chat.class);
        RegisteredServiceProvider permProvider = Bukkit.getServicesManager().getRegistration(Permission.class);
        if (economyProvider != null) {
            this.economy = (Economy)economyProvider.getProvider();
        }
        if (chatProvider != null) {
            this.chat = (Chat)chatProvider.getProvider();
        }
        if (permProvider != null) {
            this.permissions = (Permission)permProvider.getProvider();
        }
    }

    boolean isChatIntegrated() {
        return this.chat != null;
    }

    boolean isEconomyIntegrated() {
        return this.economy != null;
    }

    String getCurrencyNameSG() {
        return this.economy != null ? Common.getOrEmpty(this.economy.currencyNameSingular()) : "Money";
    }

    String getCurrencyNamePL() {
        return this.economy != null ? Common.getOrEmpty(this.economy.currencyNamePlural()) : "Money";
    }

    double getBalance(Player player) {
        return this.economy != null ? this.economy.getBalance((OfflinePlayer)player) : -1.0;
    }

    void withdraw(Player player, double amount) {
        if (this.economy != null) {
            this.economy.withdrawPlayer(player.getName(), amount);
        }
    }

    void deposit(Player player, double amount) {
        if (this.economy != null) {
            this.economy.depositPlayer(player.getName(), amount);
        }
    }

    Boolean hasPerm(@NonNull OfflinePlayer player, String perm) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        try {
            return this.permissions != null ? Boolean.valueOf(perm != null ? this.permissions.playerHas((String)null, player, perm) : true) : null;
        }
        catch (Throwable t) {
            Common.logTimed(900, "SEVERE: Unable to ask Vault plugin if " + player.getName() + " has " + perm + " permission, returning false. This error only shows every 15 minutes. Run /vault-info and check if your permissions plugin is running correctly.");
            return false;
        }
    }

    Boolean hasPerm(@NonNull String player, String perm) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        try {
            return this.permissions != null ? Boolean.valueOf(perm != null ? this.permissions.has((String)null, player, perm) : true) : null;
        }
        catch (UnsupportedOperationException t) {
            return false;
        }
    }

    Boolean hasPerm(@NonNull String world, @NonNull String player, String perm) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        try {
            return this.permissions != null ? Boolean.valueOf(perm != null ? this.permissions.has(world, player, perm) : true) : null;
        }
        catch (UnsupportedOperationException t) {
            return false;
        }
    }

    String getPrimaryGroup(Player player) {
        try {
            return this.permissions != null ? this.permissions.getPrimaryGroup(player) : "";
        }
        catch (UnsupportedOperationException t) {
            return "";
        }
    }

    String getPlayerPrefix(Player player) {
        try {
            return this.lookupVault(player, VaultPart.PREFIX);
        }
        catch (UnsupportedOperationException t) {
            return "";
        }
    }

    String getPlayerSuffix(Player player) {
        try {
            return this.lookupVault(player, VaultPart.SUFFIX);
        }
        catch (UnsupportedOperationException t) {
            return "";
        }
    }

    String getPlayerGroup(Player player) {
        try {
            return this.lookupVault(player, VaultPart.GROUP);
        }
        catch (UnsupportedOperationException t) {
            return "";
        }
    }

    private String lookupVault(Player player, VaultPart vaultPart) {
        String fallback;
        if (this.chat == null) {
            return "";
        }
        String[] groups = this.chat.getPlayerGroups(player);
        String string = vaultPart == VaultPart.PREFIX ? this.chat.getPlayerPrefix(player) : (vaultPart == VaultPart.SUFFIX ? this.chat.getPlayerSuffix(player) : (fallback = groups != null && groups.length > 0 ? groups[0] : ""));
        if (fallback == null) {
            fallback = "";
        }
        if (vaultPart == VaultPart.PREFIX || vaultPart == VaultPart.SUFFIX) {
            return fallback;
        }
        ArrayList<String> list = new ArrayList<String>();
        if (!fallback.isEmpty()) {
            list.add(fallback);
        }
        if (groups != null) {
            for (String group : groups) {
                String part;
                String string2 = vaultPart == VaultPart.PREFIX ? this.chat.getGroupPrefix(player.getWorld(), group) : (part = vaultPart == VaultPart.SUFFIX ? this.chat.getGroupSuffix(player.getWorld(), group) : group);
                if (part == null || part.isEmpty() || list.contains(part)) continue;
                list.add(part);
            }
        }
        return Common.join(list, vaultPart == VaultPart.GROUP ? ", " : "");
    }

    static enum VaultPart {
        PREFIX,
        SUFFIX,
        GROUP;

    }
}

