/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.GeoAPI;
import sk.adonikeoffice.epicchat.lib.Messenger;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.PlayerUtil;
import sk.adonikeoffice.epicchat.lib.TimeUtil;
import sk.adonikeoffice.epicchat.lib.collection.StrictList;
import sk.adonikeoffice.epicchat.lib.collection.StrictMap;
import sk.adonikeoffice.epicchat.lib.collection.expiringmap.ExpiringMap;
import sk.adonikeoffice.epicchat.lib.model.DiscordSender;
import sk.adonikeoffice.epicchat.lib.model.HookManager;
import sk.adonikeoffice.epicchat.lib.model.Replacer;
import sk.adonikeoffice.epicchat.lib.model.SimpleComponent;
import sk.adonikeoffice.epicchat.lib.model.SimpleExpansion;
import sk.adonikeoffice.epicchat.lib.model.Variable;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.remain.Remain;
import sk.adonikeoffice.epicchat.lib.settings.SimpleLocalization;
import sk.adonikeoffice.epicchat.lib.settings.SimpleSettings;

public final class Variables {
    public static final Pattern MESSAGE_VARIABLE_PATTERN = Pattern.compile("[\\[]([^\\[\\]]+)[\\]]");
    public static final Pattern VARIABLE_PATTERN = Pattern.compile("[%]([^%]+)[%]");
    public static final Pattern BRACKET_VARIABLE_PATTERN = Pattern.compile("[{]([^{}]+)[}]");
    public static final Pattern REL_VARIABLE_PATTERN = Pattern.compile("[%](rel_)([^%]+)[%]");
    public static final Pattern BRACKET_REL_VARIABLE_PATTERN = Pattern.compile("[({)](rel_)([^}]+)[(})]");
    private static final Map<String, Map<String, String>> cache = ExpiringMap.builder().expiration(500L, TimeUnit.MILLISECONDS).build();
    static volatile boolean REPLACE_JAVASCRIPT = true;
    private static final StrictMap<String, Function<CommandSender, String>> customVariables = new StrictMap();
    private static final StrictList<SimpleExpansion> customExpansions = new StrictList();

    public static Function<CommandSender, String> getVariable(String key) {
        return customVariables.get(key);
    }

    public static void addVariable(String variable, Function<CommandSender, String> replacer) {
        customVariables.override(variable, replacer);
    }

    public static void removeVariable(String variable) {
        customVariables.remove(variable);
    }

    public static boolean hasVariable(String variable) {
        return customVariables.containsKey(variable);
    }

    public static List<SimpleExpansion> getExpansions() {
        return Collections.unmodifiableList(customExpansions.getSource());
    }

    public static void addExpansion(SimpleExpansion expansion) {
        customExpansions.addIfNotExist(expansion);
    }

    public static void removeExpansion(SimpleExpansion expansion) {
        customExpansions.remove(expansion);
    }

    public static boolean hasExpansion(SimpleExpansion expansion) {
        return customExpansions.contains(expansion);
    }

    public static List<String> replace(Iterable<String> messages, CommandSender sender, Map<String, Object> replacements) {
        String deliminer = "%FLVJ%";
        return Arrays.asList(Variables.replace(String.join((CharSequence)"%FLVJ%", messages), sender, replacements).split("%FLVJ%"));
    }

    public static String replace(String message, CommandSender sender) {
        return Variables.replace(message, sender, null);
    }

    public static String replace(String message, CommandSender sender, Map<String, Object> replacements) {
        return Variables.replace(message, sender, replacements, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String replace(String message, CommandSender sender, Map<String, Object> replacements, boolean colorize) {
        Map<String, Map<String, String>> map = cache;
        synchronized (map) {
            if (message == null || message.isEmpty()) {
                return "";
            }
            String original = message;
            boolean senderIsPlayer = sender instanceof Player;
            if (replacements != null && !replacements.isEmpty()) {
                message = Replacer.replaceArray(message, replacements);
            }
            if (senderIsPlayer) {
                String cachedVar;
                Map<String, String> cached = cache.get(sender.getName());
                String string = cachedVar = cached != null ? cached.get(message) : null;
                if (cachedVar != null) {
                    return cachedVar;
                }
            }
            if (REPLACE_JAVASCRIPT) {
                REPLACE_JAVASCRIPT = false;
                try {
                    message = Variables.replaceJavascriptVariables0(message, sender, replacements);
                }
                finally {
                    REPLACE_JAVASCRIPT = true;
                }
            }
            if (senderIsPlayer) {
                message = HookManager.replacePlaceholders((OfflinePlayer)((Player)sender), message);
            } else if (sender instanceof DiscordSender) {
                message = HookManager.replacePlaceholders(((DiscordSender)sender).getOfflinePlayer(), message);
            }
            message = Variables.replaceHardVariables0(sender, message);
            if (!message.startsWith("[JSON]") && !original.equals(message = Common.colorize(message)) && (message.contains("{") && message.contains("}") || message.contains("%"))) {
                return Variables.replace(message, sender, replacements, colorize);
            }
            if (senderIsPlayer) {
                Map<String, String> map2 = cache.get(sender.getName());
                if (map2 != null) {
                    map2.put(original, message);
                } else {
                    cache.put(sender.getName(), Common.newHashMap(original, message));
                }
            }
            return message;
        }
    }

    private static String replaceJavascriptVariables0(String message, CommandSender sender, Map<String, Object> replacements) {
        message = Variables.replaceJavascriptVariables0(message, sender, replacements, VARIABLE_PATTERN.matcher(message));
        message = Variables.replaceJavascriptVariables0(message, sender, replacements, BRACKET_VARIABLE_PATTERN.matcher(message));
        return message;
    }

    private static String replaceJavascriptVariables0(String message, CommandSender sender, Map<String, Object> replacements, Matcher matcher) {
        while (matcher.find()) {
            String variableKey = matcher.group();
            Variable variable = Variable.findVariable(variableKey.substring(1, variableKey.length() - 1));
            if (variable == null || variable.getType() != Variable.Type.FORMAT) continue;
            SimpleComponent component = variable.build(sender, SimpleComponent.empty(), replacements);
            String plain = component.getPlainMessage();
            if (plain.startsWith("\u00a7f\u00a7f")) {
                plain = plain.substring(4);
            }
            message = message.replace(variableKey, plain);
        }
        return message;
    }

    private static String replaceHardVariables0(CommandSender sender, String message) {
        message = Variables.replaceHardVariables0(sender, message, VARIABLE_PATTERN.matcher(message));
        message = Variables.replaceHardVariables0(sender, message, BRACKET_VARIABLE_PATTERN.matcher(message));
        message = Messenger.replacePrefixes(message);
        return message;
    }

    private static String replaceHardVariables0(CommandSender sender, String message, Matcher matcher) {
        Player player;
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        while (matcher.find()) {
            String value;
            String variable = matcher.group(1);
            boolean frontSpace = false;
            boolean backSpace = false;
            if (variable.startsWith("+")) {
                variable = variable.substring(1);
                frontSpace = true;
            }
            if (variable.endsWith("+")) {
                variable = variable.substring(0, variable.length() - 1);
                backSpace = true;
            }
            if ((value = Variables.lookupVariable0(player, sender, variable)) == null) continue;
            boolean emptyColorless = Common.stripColors(value).isEmpty();
            value = value.isEmpty() ? "" : (frontSpace && !emptyColorless ? " " : "") + Common.colorize(value) + (backSpace && !emptyColorless ? " " : "");
            message = message.replace(matcher.group(), value);
        }
        return message;
    }

    private static String lookupVariable0(Player player, CommandSender console, String variable) {
        GeoAPI.GeoResponse geoResponse = null;
        if (player != null && Arrays.asList("country_code", "country_name", "region_name", "isp").contains(variable)) {
            geoResponse = GeoAPI.getCountry(player.getAddress());
        }
        if (console != null) {
            for (SimpleExpansion expansion : customExpansions) {
                String value = expansion.replacePlaceholders(console, variable);
                if (value == null) continue;
                return value;
            }
            Function<CommandSender, String> customReplacer = customVariables.get(variable);
            if (customReplacer != null) {
                return customReplacer.apply(console);
            }
        }
        switch (variable) {
            case "server_name": {
                return Remain.getServerName();
            }
            case "nms_version": {
                return MinecraftVersion.getServerVersion();
            }
            case "timestamp": {
                return SimpleSettings.TIMESTAMP_FORMAT.format(System.currentTimeMillis());
            }
            case "timestamp_short": {
                return TimeUtil.getFormattedDateShort();
            }
            case "chat_line": {
                return Common.chatLine();
            }
            case "chat_line_smooth": {
                return Common.chatLineSmooth();
            }
            case "town": {
                return player == null ? "" : HookManager.getTownName(player);
            }
            case "nation": {
                return player == null ? "" : HookManager.getNation(player);
            }
            case "faction": {
                return player == null ? "" : HookManager.getFaction(player);
            }
            case "world": {
                return player == null ? "" : HookManager.getWorldAlias(player.getWorld());
            }
            case "health": {
                return player == null ? "" : Variables.formatHealth0(player) + ChatColor.RESET;
            }
            case "location": {
                return player == null ? "" : Common.shortLocation(player.getLocation());
            }
            case "x": {
                return player == null ? "" : String.valueOf(player.getLocation().getBlockX());
            }
            case "y": {
                return player == null ? "" : String.valueOf(player.getLocation().getBlockY());
            }
            case "z": {
                return player == null ? "" : String.valueOf(player.getLocation().getBlockZ());
            }
            case "player": 
            case "player_name": {
                if (console == null) {
                    return null;
                }
                return player == null ? Common.resolveSenderName(console) : player.getName();
            }
            case "tab_name": {
                return player == null ? Common.resolveSenderName(console) : player.getPlayerListName();
            }
            case "display_name": {
                return player == null ? Common.resolveSenderName(console) : player.getDisplayName();
            }
            case "player_nick": 
            case "nick": {
                return player == null ? Common.resolveSenderName(console) : HookManager.getNickColored((CommandSender)player);
            }
            case "player_prefix": 
            case "pl_prefix": {
                return player == null ? "" : HookManager.getPlayerPrefix(player);
            }
            case "player_suffix": 
            case "pl_suffix": {
                return player == null ? "" : HookManager.getPlayerSuffix(player);
            }
            case "player_group": 
            case "pl_group": {
                return player == null ? "" : HookManager.getPlayerPermissionGroup(player);
            }
            case "player_primary_group": 
            case "pl_primary_group": {
                return player == null ? "" : HookManager.getPlayerPrimaryGroup(player);
            }
            case "ip_address": 
            case "pl_address": {
                return player == null ? "" : Variables.formatIp0(player);
            }
            case "player_vanished": {
                return player == null ? "false" : String.valueOf(PlayerUtil.isVanished(player));
            }
            case "country_code": {
                return player == null ? "" : geoResponse.getCountryCode();
            }
            case "country_name": {
                return player == null ? "" : geoResponse.getCountryName();
            }
            case "region_name": {
                return player == null ? "" : geoResponse.getRegionName();
            }
            case "isp": {
                return player == null ? "" : geoResponse.getIsp();
            }
            case "label": {
                return SimplePlugin.getInstance().getMainCommand() != null ? SimplePlugin.getInstance().getMainCommand().getLabel() : SimpleLocalization.NONE;
            }
            case "sender_is_player": {
                return player != null ? "true" : "false";
            }
            case "sender_is_discord": {
                return console instanceof DiscordSender ? "true" : "false";
            }
            case "sender_is_console": {
                return console instanceof ConsoleCommandSender ? "true" : "false";
            }
        }
        return null;
    }

    private static String formatHealth0(Player player) {
        int hp = Remain.getHealth((LivingEntity)player);
        return (hp > 10 ? ChatColor.DARK_GREEN : (hp > 5 ? ChatColor.GOLD : ChatColor.RED)) + "" + hp;
    }

    private static String formatIp0(Player player) {
        try {
            return player.getAddress().toString().split("\\:")[0];
        }
        catch (Throwable t) {
            return player.getAddress() != null ? player.getAddress().toString() : "";
        }
    }
}

