/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import lombok.NonNull;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.PlayerUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.constants.FoConstants;
import sk.adonikeoffice.epicchat.lib.model.JavaScriptExecutor;
import sk.adonikeoffice.epicchat.lib.model.SimpleComponent;
import sk.adonikeoffice.epicchat.lib.model.Variables;
import sk.adonikeoffice.epicchat.lib.settings.ConfigItems;
import sk.adonikeoffice.epicchat.lib.settings.YamlConfig;

public final class Variable
extends YamlConfig {
    public static Function<String, String> PROTOTYPE_PATH = t -> NO_DEFAULT;
    private static final ConfigItems<Variable> loadedVariables = ConfigItems.fromFolder("variables", Variable.class);
    private Type type;
    private String key;
    private String value;
    private String senderCondition;
    private String receiverCondition;
    private String senderPermission;
    private String receiverPermission;
    private List<String> hoverText;
    private String hoverItem;
    private String openUrl;
    private String suggestCommand;
    private String runCommand;

    private Variable(String file) {
        String prototypePath = PROTOTYPE_PATH.apply(file);
        this.setHeader(FoConstants.Header.VARIABLE_FILE);
        this.loadConfiguration(prototypePath, "variables/" + file + ".yml");
    }

    @Override
    protected void onLoad() {
        this.type = this.get("Type", Type.class, new Object[0]);
        this.key = this.getString("Key");
        this.value = this.getString("Value");
        this.senderCondition = this.getString("Sender_Condition");
        this.receiverCondition = this.getString("Receiver_Condition");
        this.senderPermission = this.getString("Sender_Permission");
        this.receiverPermission = this.getString("Receiver_Permission");
        if (this.type == null) {
            this.type = Type.FORMAT;
            this.save();
        }
        if (this.key == null || this.key.isEmpty()) {
            throw new NullPointerException("(DO NOT REPORT, PLEASE FIX YOURSELF) Please set 'Key' as variable name in " + this.getFileName());
        }
        if (this.value == null || this.value.isEmpty()) {
            throw new NullPointerException("(DO NOT REPORT, PLEASE FIX YOURSELF) Please set 'Value' key as what the variable shows in " + this.getFileName() + " (this can be a JavaScript code)");
        }
        if (this.key.startsWith("{") || this.key.startsWith("[")) {
            this.key = this.key.substring(1);
            this.save();
        }
        if (this.key.endsWith("}") || this.key.endsWith("]")) {
            this.key = this.key.substring(0, this.key.length() - 1);
            this.save();
        }
        if (this.type == Type.MESSAGE) {
            this.hoverText = this.getStringList("Hover");
            this.hoverItem = this.getString("Hover_Item");
            this.openUrl = this.getString("Open_Url");
            this.suggestCommand = this.getString("Suggest_Command");
            this.runCommand = this.getString("Run_Command");
        }
        if (!Common.regExMatch("^\\w+$", this.key)) {
            throw new IllegalArgumentException("(DO NOT REPORT, PLEASE FIX YOURSELF) The 'Key' variable in " + this.getFileName() + " must only contains letters, numbers or underscores. Do not write [] or {} there!");
        }
    }

    @Override
    public void onSave() {
        this.set("Type", (Object)this.type);
        this.set("Key", this.key);
        this.set("Value", this.value);
        this.set("Sender_Condition", this.senderCondition);
        this.set("Receiver_Condition", this.receiverCondition);
        this.set("Hover", this.hoverText);
        this.set("Hover_Item", this.hoverItem);
        this.set("Open_Url", this.openUrl);
        this.set("Suggest_Command", this.suggestCommand);
        this.set("Run_Command", this.runCommand);
        this.set("Sender_Permission", this.senderPermission);
        this.set("Receiver_Permission", this.receiverPermission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(CommandSender sender, Map<String, Object> replacements) {
        Variables.REPLACE_JAVASCRIPT = false;
        try {
            String result;
            String script = Variables.replace(this.value, sender, replacements);
            String string = result = String.valueOf(JavaScriptExecutor.run(script, sender));
            return string;
        }
        catch (RuntimeException ex) {
            if (sender instanceof Player) {
                throw ex;
            }
            String string = "";
            return string;
        }
        finally {
            Variables.REPLACE_JAVASCRIPT = true;
        }
    }

    public SimpleComponent build(CommandSender sender, SimpleComponent existingComponent, Map<String, Object> replacements) {
        String value;
        Object result;
        if (this.senderPermission != null && !this.senderPermission.isEmpty() && !PlayerUtil.hasPerm((Permissible)sender, this.senderPermission)) {
            return SimpleComponent.of("");
        }
        if (this.senderCondition != null && !this.senderCondition.isEmpty() && (result = JavaScriptExecutor.run(this.senderCondition, sender)) != null) {
            Valid.checkBoolean(result instanceof Boolean, "Variable '" + this.getFileName() + "' option Condition must return boolean not " + (result == null ? "null" : result.getClass()), new Object[0]);
            if (!((Boolean)result).booleanValue()) {
                return SimpleComponent.of("");
            }
        }
        if ((value = this.getValue(sender, replacements)) == null || value.isEmpty() || "null".equals(value)) {
            return SimpleComponent.of("");
        }
        SimpleComponent component = existingComponent.append(Variables.replace(value, sender, replacements)).viewPermission(this.receiverPermission).viewCondition(this.receiverCondition);
        if (!Valid.isNullOrEmpty(this.hoverText)) {
            component.onHover(Variables.replace(this.hoverText, sender, replacements));
        }
        if (this.hoverItem != null && !this.hoverItem.isEmpty()) {
            Object result2 = JavaScriptExecutor.run(Variables.replace(this.hoverItem, sender, replacements), sender);
            Valid.checkBoolean(result2 instanceof ItemStack, "Variable '" + this.getFileName() + "' option Hover_Item must return ItemStack not " + result2.getClass(), new Object[0]);
            component.onHover((ItemStack)result2);
        }
        if (this.openUrl != null && !this.openUrl.isEmpty()) {
            component.onClickOpenUrl(Variables.replace(this.openUrl, sender, replacements));
        }
        if (this.suggestCommand != null && !this.suggestCommand.isEmpty()) {
            component.onClickSuggestCmd(Variables.replace(this.suggestCommand, sender, replacements));
        }
        if (this.runCommand != null && !this.runCommand.isEmpty()) {
            component.onClickRunCmd(Variables.replace(this.runCommand, sender, replacements));
        }
        return component;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Variable && this.key.equals(((Variable)obj).getKey());
    }

    public static void createVariable(String name) {
        loadedVariables.loadOrCreateItem(name);
    }

    public static void loadVariables() {
        loadedVariables.loadItems();
    }

    public static void removeVariable(Variable variable) {
        loadedVariables.removeItem(variable);
    }

    public static boolean isVariableLoaded(String name) {
        return loadedVariables.isItemLoaded(name);
    }

    public static Variable findVariable(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        for (Variable item : Variable.getVariables()) {
            if (!item.getKey().equalsIgnoreCase(name)) continue;
            return item;
        }
        return null;
    }

    public static Collection<Variable> getVariables() {
        return loadedVariables.getItems();
    }

    public static Set<String> getVariableNames() {
        return loadedVariables.getItemNames();
    }

    public Type getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public String getSenderCondition() {
        return this.senderCondition;
    }

    public String getReceiverCondition() {
        return this.receiverCondition;
    }

    public String getSenderPermission() {
        return this.senderPermission;
    }

    public String getReceiverPermission() {
        return this.receiverPermission;
    }

    public List<String> getHoverText() {
        return this.hoverText;
    }

    public String getHoverItem() {
        return this.hoverItem;
    }

    public String getOpenUrl() {
        return this.openUrl;
    }

    public String getSuggestCommand() {
        return this.suggestCommand;
    }

    public String getRunCommand() {
        return this.runCommand;
    }

    public static enum Type {
        FORMAT("format"),
        MESSAGE("message");

        private final String key;

        public static Type fromKey(String key) {
            for (Type mode : Type.values()) {
                if (!mode.key.equalsIgnoreCase(key)) continue;
                return mode;
            }
            throw new IllegalArgumentException("No such item type: " + key + ". Available: " + Common.join(Type.values()));
        }

        public String toString() {
            return this.key;
        }

        private Type(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

