/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import sk.adonikeoffice.epicchat.lib.SerializeUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.collection.SerializedMap;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.model.ConfigSerializable;

public final class Tuple<K, V>
implements ConfigSerializable {
    private final K key;
    private final V value;

    @Override
    public SerializedMap serialize() {
        return SerializedMap.ofArray("Key", this.key, "Value", this.value);
    }

    public String toLine() {
        return this.key + " - " + this.value;
    }

    public String toString() {
        return this.toLine();
    }

    public static <K, V> Tuple<K, V> deserialize(SerializedMap map, Class<K> keyType, Class<V> valueType) {
        K key = map.containsKey("Key") ? (K)map.get("Key", keyType) : null;
        V value = map.containsKey("Value") ? (V)map.get("Value", valueType) : null;
        return new Tuple<Object, Object>(key, value);
    }

    public static <K, V> Tuple<K, V> deserialize(String line, Class<K> keyType, Class<V> valueType) {
        if (line == null) {
            return null;
        }
        String[] split = line.split(" - ");
        Valid.checkBoolean(split.length == 2, "Line must have the syntax <" + keyType.getSimpleName() + "> - <" + valueType.getSimpleName() + "> but got: " + line, new Object[0]);
        K key = SerializeUtil.deserialize(SerializeUtil.Mode.YAML, keyType, (Object)split[0]);
        V value = SerializeUtil.deserialize(SerializeUtil.Mode.YAML, valueType, (Object)split[1]);
        return new Tuple<K, V>(key, value);
    }

    @Deprecated
    public static <K, V> Tuple<K, V> deserialize(SerializedMap map) {
        throw new FoException("Tuple cannot be deserialized automatically, call Tuple#deserialize(map, keyType, valueType)");
    }

    public Tuple(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tuple)) {
            return false;
        }
        Tuple other = (Tuple)o;
        K this$key = this.getKey();
        K other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        V this$value = this.getValue();
        V other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        K $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        V $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

