/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.WorldCoord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.remain.Remain;

class TownyHook {
    TownyHook() {
    }

    Collection<? extends Player> getTownResidentsOnline(Player pl) {
        ArrayList<Player> recipients = new ArrayList<Player>();
        String playersTown = this.getTownName(pl);
        if (!playersTown.isEmpty()) {
            for (Player player : Remain.getOnlinePlayers()) {
                if (!playersTown.equals(this.getTownName(player))) continue;
                recipients.add(player);
            }
        }
        return recipients;
    }

    Collection<? extends Player> getNationPlayersOnline(Player pl) {
        ArrayList<Player> recipients = new ArrayList<Player>();
        String playerNation = this.getNationName(pl);
        if (!playerNation.isEmpty()) {
            for (Player player : Remain.getOnlinePlayers()) {
                if (!playerNation.equals(this.getNationName(player))) continue;
                recipients.add(player);
            }
        }
        return recipients;
    }

    Collection<? extends Player> getAllyPlayersOnline(Player pl) {
        ArrayList<Player> recipients = new ArrayList<Player>();
        Resident resident = this.getResident(pl);
        if (resident != null) {
            for (Player player : Remain.getOnlinePlayers()) {
                Resident otherResident = this.getResident(player);
                if (otherResident == null || !otherResident.isAlliedWith(resident)) continue;
                recipients.add(player);
            }
        }
        return recipients;
    }

    String getTownName(Player pl) {
        Town t = this.getTown(pl);
        return t != null ? t.getName() : "";
    }

    String getNationName(Player pl) {
        Nation n = this.getNation(pl);
        return n != null ? n.getName() : "";
    }

    List<String> getTowns() {
        try {
            return Common.convert(TownyUniverse.getInstance().getTowns(), TownyObject::getName);
        }
        catch (Throwable e) {
            return new ArrayList<String>();
        }
    }

    String getTownName(Location loc) {
        Town town = this.getTown(loc);
        return town != null ? town.getName() : null;
    }

    private Town getTown(Location loc) {
        try {
            WorldCoord worldCoord = WorldCoord.parseWorldCoord((Location)loc);
            TownBlock townBlock = TownyUniverse.getInstance().getTownBlock(worldCoord);
            return townBlock != null ? townBlock.getTown() : null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    String getTownOwner(Location loc) {
        try {
            Town town = this.getTown(loc);
            return town != null ? town.getMayor().getName() : null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private Nation getNation(Player pl) {
        Town town = this.getTown(pl);
        try {
            return town.getNation();
        }
        catch (Throwable ex) {
            return null;
        }
    }

    private Town getTown(Player pl) {
        Resident res = this.getResident(pl);
        try {
            return res.getTown();
        }
        catch (Throwable ex) {
            return null;
        }
    }

    private Resident getResident(Player player) {
        try {
            return TownyUniverse.getInstance().getResident(player.getName());
        }
        catch (Throwable e) {
            return null;
        }
    }
}

