/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import net.citizensnpcs.api.event.NPCClickEvent;
import net.citizensnpcs.api.event.NPCLeftClickEvent;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.ClickType;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.Messenger;
import sk.adonikeoffice.epicchat.lib.collection.SerializedMap;
import sk.adonikeoffice.epicchat.lib.exception.EventHandledException;

public abstract class SimpleTrait
extends Trait {
    private int tickAmount = 0;
    private int tickThreshold;

    protected SimpleTrait(String traitName) {
        super(traitName);
    }

    public final void load(DataKey key) {
        SerializedMap map = SerializedMap.fromJson(key.getString("Data"));
        this.load(map);
    }

    protected abstract void load(SerializedMap var1);

    public final void save(DataKey key) {
        SerializedMap map = new SerializedMap();
        this.save(map);
        key.setString("Data", map.toJson());
    }

    protected abstract void save(SerializedMap var1);

    @EventHandler
    public final void onRightClick(NPCRightClickEvent event) {
        this.handleClickEvent((NPCClickEvent)event, ClickType.RIGHT);
    }

    @EventHandler
    public final void onLeftClick(NPCLeftClickEvent event) {
        this.handleClickEvent((NPCClickEvent)event, ClickType.LEFT);
    }

    private void handleClickEvent(NPCClickEvent event, ClickType clickType) {
        block6: {
            if (!event.getNPC().equals((Object)this.getNPC())) {
                return;
            }
            Player player = event.getClicker();
            try {
                this.onClick(player, clickType);
            }
            catch (EventHandledException ex) {
                if (ex.getMessages() != null) {
                    if (Messenger.ENABLED) {
                        Messenger.error((CommandSender)player, ex.getMessages());
                    } else {
                        Common.tell((CommandSender)player, ex.getMessages());
                    }
                }
                if (!ex.isCancelled()) break block6;
                event.setCancelled(true);
            }
        }
    }

    public void onClick(Player player, ClickType clickType) throws EventHandledException {
    }

    protected final void cancel(String ... playerMessage) {
        throw new EventHandledException(true, playerMessage);
    }

    public final void run() {
        if (this.tickAmount++ % this.tickThreshold == 0) {
            this.tickAmount = 1;
            this.onTick();
        }
    }

    protected abstract void onTick();

    public void onSpawn() {
    }

    public void onDespawn() {
    }

    public void onRemove() {
    }

    protected int getTickThreshold() {
        return this.tickThreshold;
    }

    protected void setTickThreshold(int tickThreshold) {
        this.tickThreshold = tickThreshold;
    }
}

