/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import lombok.NonNull;
import sk.adonikeoffice.epicchat.lib.TimeUtil;

public final class SimpleTime {
    private final String raw;
    private final long timeTicks;

    protected SimpleTime(@NonNull String time) {
        if (time == null) {
            throw new NullPointerException("time is marked non-null but is null");
        }
        if ("0".equals(time) || "none".equalsIgnoreCase(time)) {
            this.raw = "0";
            this.timeTicks = 0L;
        } else {
            this.raw = time;
            this.timeTicks = TimeUtil.toTicks(time);
        }
    }

    public static SimpleTime fromSeconds(int seconds) {
        return SimpleTime.from(seconds + " seconds");
    }

    public static SimpleTime from(String time) {
        return new SimpleTime(time);
    }

    public long getTimeSeconds() {
        return this.timeTicks / 20L;
    }

    public int getTimeTicks() {
        return (int)this.timeTicks;
    }

    public long getTimeMilliseconds() {
        return this.timeTicks * 50L;
    }

    public String getRaw() {
        return this.timeTicks == 0L ? "0" : this.raw;
    }

    public boolean equals(Object obj) {
        return obj instanceof SimpleTime && ((SimpleTime)obj).timeTicks == this.timeTicks;
    }

    public String toString() {
        return this.getRaw();
    }
}

