/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import lombok.NonNull;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.remain.CompSound;

public final class SimpleSound {
    @NonNull
    private Sound sound;
    private float volume = 1.0f;
    private float pitch = 1.0f;
    private boolean randomPitch = false;
    private boolean enabled = true;

    public SimpleSound(Sound sound, float volume, float pitch) {
        this(sound, volume, pitch, false, true);
    }

    public SimpleSound(Sound sound, float volume) {
        this(sound, volume, 1.0f, true, true);
    }

    public SimpleSound(@NonNull String line) {
        if (line == null) {
            throw new NullPointerException("line is marked non-null but is null");
        }
        if ("none".equals(line)) {
            this.sound = CompSound.CLICK.getSound();
            this.volume = 0.0f;
            this.enabled = false;
            return;
        }
        String[] values = line.contains(", ") ? line.split(", ") : line.split(" ");
        CompSound compSound = CompSound.fromName(values[0]);
        Valid.checkNotNull((Object)compSound, "Sound '" + values[0] + "' does not exists (in your Minecraft version " + MinecraftVersion.getServerVersion() + ")! Pick one from mineacademy.org/sounds");
        this.sound = compSound.getSound();
        if (values.length == 1) {
            this.volume = 1.0f;
            this.pitch = 1.5f;
            return;
        }
        Valid.checkBoolean(values.length == 3, "Malformed sound type, use format: 'sound' OR 'sound volume pitch'. Got: " + line, new Object[0]);
        Valid.checkNotNull(this.sound, "Unable to parse sound from: " + line);
        String volumeRaw = values[1];
        String pitchRaw = values[2];
        this.volume = Float.parseFloat(volumeRaw);
        if ("random".equals(pitchRaw)) {
            this.pitch = 1.0f;
            this.randomPitch = true;
        } else {
            this.pitch = Float.parseFloat(pitchRaw);
        }
    }

    public void play(Iterable<Player> players) {
        if (this.enabled) {
            for (Player player : players) {
                this.play(player);
            }
        }
    }

    public void play(Player player) {
        if (this.enabled) {
            Valid.checkNotNull(this.sound);
            try {
                player.playSound(player.getLocation(), this.sound, this.volume, this.getPitch());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
    }

    public void play(Location location) {
        if (this.enabled) {
            Valid.checkNotNull(this.sound);
            try {
                location.getWorld().playSound(location, this.sound, this.volume, this.getPitch());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
    }

    public float getPitch() {
        return this.randomPitch ? (float)Math.random() : this.pitch;
    }

    public String toString() {
        return this.enabled ? this.sound + " " + this.volume + " " + (this.randomPitch ? "random" : Float.valueOf(this.pitch)) : "none";
    }

    @NonNull
    public Sound getSound() {
        return this.sound;
    }

    public float getVolume() {
        return this.volume;
    }

    public boolean isRandomPitch() {
        return this.randomPitch;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private SimpleSound(@NonNull Sound sound, float volume, float pitch, boolean randomPitch, boolean enabled) {
        if (sound == null) {
            throw new NullPointerException("sound is marked non-null but is null");
        }
        this.sound = sound;
        this.volume = volume;
        this.pitch = pitch;
        this.randomPitch = randomPitch;
        this.enabled = enabled;
    }
}

