/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.collection.StrictList;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;

public class SimpleScoreboard {
    private static final String COLOR_CHAR = "\u00a7";
    private static final List<SimpleScoreboard> registeredBoards = new ArrayList<SimpleScoreboard>();
    private static final String[] colors = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    private final List<ScoreboardLine> rows = new ArrayList<ScoreboardLine>();
    private final List<UUID> viewers = new ArrayList<UUID>();
    private final String[] theme = new String[2];
    private String title;
    private int updateDelayTicks = 20;
    private BukkitTask updateTask;

    public SimpleScoreboard() {
        registeredBoards.add(this);
    }

    public SimpleScoreboard(String title) {
        this(title, 20);
    }

    public SimpleScoreboard(String title, int updateDelayTicks) {
        Valid.checkBoolean(MinecraftVersion.atLeast(MinecraftVersion.V.v1_7), "Scoreboards (with objectives) are not supported below Minecraft version 1.7!", new Object[0]);
        this.setTitle(title);
        this.setUpdateDelayTicks(updateDelayTicks);
        registeredBoards.add(this);
    }

    public static void clearBoards() {
        registeredBoards.clear();
    }

    public static void clearBoardsFor(Player player) {
        for (SimpleScoreboard scoreboard : registeredBoards) {
            if (!scoreboard.isViewing(player)) continue;
            scoreboard.hide(player);
        }
    }

    protected String replaceVariables(@NonNull Player player, @NonNull String message) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return message;
    }

    protected void onUpdate() {
    }

    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(String title) {
        int maxTitleLength = MinecraftVersion.atLeast(MinecraftVersion.V.v1_13) ? 128 : 32;
        String colorizedTitle = Common.colorize(title);
        this.title = colorizedTitle.length() > maxTitleLength ? colorizedTitle.substring(0, maxTitleLength) : colorizedTitle;
        this.title = this.title.endsWith(COLOR_CHAR) ? this.title.substring(0, this.title.length() - 1) : this.title;
    }

    public List<String> getRows() {
        return Common.convert(this.rows, ScoreboardLine::getText);
    }

    public final boolean isRunning() {
        return this.updateTask != null;
    }

    public final void setUpdateDelayTicks(int updateDelayTicks) {
        this.updateDelayTicks = updateDelayTicks;
    }

    public final void show(Player player) {
        Valid.checkBoolean(this.title != null && !this.title.isEmpty(), "Before calling show(Player) you need to use setTitle() for " + this, new Object[0]);
        Valid.checkBoolean(!this.isViewing(player), "Player " + player.getName() + " is already viewing scoreboard: " + this, new Object[0]);
        if (this.updateTask == null) {
            this.start();
        }
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
        this.viewers.add(player.getUniqueId());
        player.setScoreboard(scoreboard);
    }

    public final void hide(Player player) {
        Valid.checkBoolean(this.isViewing(player), "Player " + player.getName() + " is not viewing scoreboard: " + this.getTitle(), new Object[0]);
        player.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
        this.viewers.remove(player.getUniqueId());
        if (this.viewers.isEmpty()) {
            this.cancelUpdateTask();
        }
    }

    public final boolean isViewing(Player player) {
        return this.viewers.contains(player.getUniqueId());
    }

    public final void setTheme(@NonNull ChatColor primary, ChatColor secondary) {
        if (primary == null) {
            throw new NullPointerException("primary is marked non-null but is null");
        }
        if (secondary != null) {
            this.theme[0] = "&" + primary.getChar();
            this.theme[1] = "&" + secondary.getChar();
        } else {
            this.theme[0] = "&" + primary.getChar();
        }
    }

    public final void addRows(Object ... entries) {
        this.addRows(Arrays.asList(entries));
    }

    public final void addRows(List<Object> entries) {
        Valid.checkBoolean(this.rows.size() + entries.size() < 17, "You are trying to add too many rows (the limit is 16)", new Object[0]);
        this.rows.addAll(Common.convert(Common.colorize(Common.convert(entries, Object::toString)), x$0 -> new ScoreboardLine((String)x$0)));
    }

    public final void changeRow(int index, Object value) {
        Valid.checkBoolean(index < this.rows.size(), "The row for index " + index + " is currently not existing. Please use addRows()!", new Object[0]);
        this.rows.get(index).setText(Common.colorize(value.toString()));
    }

    public final void clearRows() {
        this.rows.clear();
    }

    public final void removeRow(int index) {
        this.rows.remove(index);
    }

    public final void removeRow(String thatContains) {
        this.rows.removeIf(row -> row.getText().contains(thatContains));
    }

    private void start() {
        Valid.checkBoolean(this.updateTask == null, "Scoreboard " + this + " already running", new Object[0]);
        this.updateTask = Bukkit.getScheduler().runTaskTimer((Plugin)SimplePlugin.getInstance(), () -> {
            try {
                this.onUpdate();
                for (UUID viewerId : new StrictList<UUID>((Iterable<UUID>)this.viewers)) {
                    Player viewer = Bukkit.getPlayer((UUID)viewerId);
                    if (viewer == null || !viewer.isOnline()) {
                        this.viewers.remove(viewerId);
                        continue;
                    }
                    this.reloadEntries(viewer);
                }
            }
            catch (Throwable t) {
                String lines = String.join((CharSequence)" ", this.getRows());
                Common.error(t, "Error displaying " + this, "Entries: " + lines, "Title: " + this.title, "%error", "Stopping rendering for safety.");
                this.stop();
            }
        }, 0L, (long)this.updateDelayTicks);
    }

    public final void stop() {
        this.viewers.forEach(viewerId -> {
            Player viewer = Bukkit.getPlayer((UUID)viewerId);
            if (viewer != null && viewer.isOnline()) {
                viewer.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
            }
        });
        this.viewers.clear();
        if (this.updateTask != null) {
            this.cancelUpdateTask();
        }
    }

    public final String toString() {
        return "Scoreboard{title=" + this.getTitle() + "}";
    }

    private String replaceTheme(String row) {
        if (row.contains(":")) {
            String[] split;
            if (this.theme.length == 1) {
                return this.theme[0] + row;
            }
            if (this.theme[0] != null && (split = row.split("\\:")).length > 1) {
                return this.theme[0] + split[0] + ":" + this.theme[1] + split[1];
            }
        }
        return row;
    }

    private void cancelUpdateTask() {
        Valid.checkNotNull(this.updateTask, "Scoreboard " + this + " not running");
        this.updateTask.cancel();
        this.updateTask = null;
    }

    private void reloadEntries(Player player) throws IllegalArgumentException {
        int size = this.rows.size();
        Scoreboard scoreboard = player.getScoreboard();
        Objective mainboard = scoreboard.getObjective("mainboard");
        if (mainboard == null) {
            mainboard = scoreboard.registerNewObjective("mainboard", "dummy");
            mainboard.setDisplayName(this.title);
            mainboard.setDisplaySlot(DisplaySlot.SIDEBAR);
        }
        if (!mainboard.getDisplayName().equals(this.title)) {
            mainboard.setDisplayName(this.title);
        }
        for (int lineNumber = 0; lineNumber < 16; ++lineNumber) {
            int scoreboardLineNumber = size - lineNumber;
            Team line = scoreboard.getTeam("line" + scoreboardLineNumber);
            if (lineNumber < this.rows.size()) {
                if (line == null) {
                    line = scoreboard.registerNewTeam("line" + scoreboardLineNumber);
                }
                ScoreboardLine scoreboardLine = this.rows.get(lineNumber);
                Function<String, String> replaceFunction = lineText -> this.replaceTheme(this.replaceVariables(player, lineText.replace("{player}", player.getName())));
                String[] createdLine = scoreboardLine.createLine(COLOR_CHAR + colors[lineNumber] + COLOR_CHAR + "r", replaceFunction);
                String prefix = createdLine[0];
                String entry = createdLine[1];
                String suffix = createdLine[2];
                String oldEntry = null;
                if (!line.getPrefix().equals(prefix)) {
                    line.setPrefix(prefix);
                }
                if (line.getEntries().size() > 1) {
                    throw new IllegalArgumentException("There are more than allowed entries in the teams entry list!");
                }
                if (!line.getEntries().contains(entry)) {
                    if (!line.getEntries().isEmpty()) {
                        oldEntry = (String)new ArrayList(line.getEntries()).get(0);
                        line.removeEntry(oldEntry);
                    }
                    line.addEntry(entry);
                }
                if (!line.getSuffix().equals(suffix)) {
                    line.setSuffix(suffix);
                }
                if (oldEntry != null) {
                    scoreboard.resetScores(oldEntry);
                }
                mainboard.getScore(entry).setScore(scoreboardLineNumber);
                continue;
            }
            if (line == null) continue;
            for (String oldEntry : line.getEntries()) {
                scoreboard.resetScores(oldEntry);
            }
            line.unregister();
        }
    }

    public static List<SimpleScoreboard> getRegisteredBoards() {
        return registeredBoards;
    }

    public int getUpdateDelayTicks() {
        return this.updateDelayTicks;
    }

    private static class ScoreboardLine {
        private String text;

        private ScoreboardLine(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String[] createLine(String lineIdentifier, Function<String, String> textReplaceFunction) {
            int[] nArray;
            String[] line = new String[3];
            String text = textReplaceFunction.apply(this.text);
            boolean mc1_13 = MinecraftVersion.atLeast(MinecraftVersion.V.v1_13);
            boolean mc1_18 = MinecraftVersion.atLeast(MinecraftVersion.V.v1_18);
            if (mc1_13) {
                int[] nArray2 = new int[2];
                nArray2[0] = 64;
                nArray = nArray2;
                nArray2[1] = mc1_18 ? 32831 : 104;
            } else {
                int[] nArray3 = new int[2];
                nArray3[0] = 16;
                nArray = nArray3;
                nArray3[1] = 56;
            }
            int[] splitPoints = nArray;
            int length = mc1_18 ? 32895 : (mc1_13 ? 168 : 70);
            List<String> copy = this.copyColors(text, length, splitPoints);
            line[0] = Common.colorize(copy.isEmpty() ? "" : copy.get(0));
            line[1] = Common.colorize(copy.size() < 2 ? lineIdentifier : copy.get(1));
            line[2] = Common.colorize(copy.size() < 3 ? "" : copy.get(2));
            return line;
        }

        private List<String> copyColors(String text, int maxLength, int ... splitPoints) {
            if (maxLength < 1) {
                return new ArrayList<String>();
            }
            List<String> splitText = new ArrayList<String>();
            int lastSplitPoint = 0;
            for (int splitPoint : splitPoints) {
                if (splitPoint < 0) {
                    throw new IllegalArgumentException("SplitPoints cannot be negative!");
                }
                if (splitPoint <= lastSplitPoint) {
                    throw new IllegalArgumentException("Please put your splitPoints in order from small to large!");
                }
                if (splitPoint >= text.length() || splitPoint >= maxLength) break;
                splitText.add(text.substring(lastSplitPoint, splitPoint));
                lastSplitPoint = splitPoint;
            }
            if (text.length() > lastSplitPoint) {
                splitText.add(text.substring(lastSplitPoint, Math.min(text.length(), maxLength)));
            }
            for (int index = 1; index < splitText.size(); ++index) {
                int j;
                String currentText;
                int currentSplitPoint = splitPoints.length > index ? splitPoints[index] : maxLength;
                int previousSplitPoint = splitPoints.length > index - 1 ? splitPoints[index - 1] : 0;
                int maxSubStringLength = currentSplitPoint - previousSplitPoint;
                boolean lastLoop = index == splitText.size() - 1;
                String previousText = splitText.get(index - 1);
                String fixedText = currentText = splitText.get(index);
                String marge = null;
                if (previousText.endsWith(SimpleScoreboard.COLOR_CHAR)) {
                    previousText = previousText.substring(0, previousText.length() - 1);
                    fixedText = SimpleScoreboard.COLOR_CHAR + currentText;
                    if (!lastLoop) {
                        marge = fixedText.substring(fixedText.length() - 1);
                        fixedText = fixedText.substring(0, fixedText.length() - 1);
                    }
                } else if (!currentText.startsWith(SimpleScoreboard.COLOR_CHAR)) {
                    String lastColor = ChatColor.getLastColors((String)previousText);
                    fixedText = lastColor + currentText;
                    if (!lastLoop) {
                        marge = fixedText.substring(fixedText.length() - 2);
                        fixedText = fixedText.substring(0, fixedText.length() - 2);
                    }
                }
                if (fixedText.length() > maxSubStringLength) {
                    marge = fixedText.substring(maxSubStringLength);
                    fixedText = fixedText.substring(0, maxSubStringLength);
                }
                splitText.set(index - 1, previousText);
                splitText.set(index, fixedText);
                List<String> linesWithMarge = new ArrayList<String>();
                for (j = index + 1; j < splitText.size(); ++j) {
                    linesWithMarge.add(splitText.get(j));
                }
                linesWithMarge = this.passMergeThrough(marge, linesWithMarge, maxLength);
                for (j = 0; j < linesWithMarge.size(); ++j) {
                    splitText.set(index + 1 + j, linesWithMarge.get(j));
                }
            }
            int stringLength = 0;
            for (String line : splitText) {
                stringLength += line.length();
            }
            if (stringLength > maxLength) {
                splitText = this.passMergeThrough(null, splitText, maxLength);
            }
            return splitText;
        }

        private List<String> passMergeThrough(String marge, List<String> text, int maxLength) {
            StringBuilder textBuilder = new StringBuilder(marge == null ? "" : marge);
            ArrayList<Integer> stringLengths = new ArrayList<Integer>();
            ArrayList<String> newSplitText = new ArrayList<String>();
            for (String line : text) {
                stringLengths.add(line.length());
                textBuilder.append(line);
            }
            String textWithMarge = textBuilder.toString();
            textWithMarge = textWithMarge.substring(0, Math.min(maxLength, textWithMarge.length()));
            int previousLength = 0;
            for (int index = 0; index < stringLengths.size(); ++index) {
                String subString;
                int length = (Integer)stringLengths.get(index);
                if (index == stringLengths.size() - 1) {
                    length = Math.max(length, maxLength);
                }
                if (!(subString = textWithMarge.substring(previousLength, Math.min(textWithMarge.length(), previousLength + length))).isEmpty()) {
                    newSplitText.add(subString);
                }
                previousLength += length;
            }
            return newSplitText;
        }
    }
}

