/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.scheduler.BukkitTask;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.model.Tuple;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;
import sk.adonikeoffice.epicchat.lib.remain.CompParticle;
import sk.adonikeoffice.epicchat.lib.remain.Remain;

public abstract class SimpleHologram {
    private static double loreLineHeight = 0.26;
    private static Set<SimpleHologram> registeredItems = new HashSet<SimpleHologram>();
    private static volatile BukkitTask tickingTask = null;
    private final List<ArmorStand> loreEntities = new ArrayList<ArmorStand>();
    private final Location lastTeleportLocation;
    private final List<String> loreLines = new ArrayList<String>();
    private final List<Tuple<CompParticle, Object>> particles = new ArrayList<Tuple<CompParticle, Object>>();
    private Entity entity;
    private Location pendingTeleport = null;

    protected SimpleHologram(Location spawnLocation) {
        this.lastTeleportLocation = spawnLocation.clone();
        registeredItems.add(this);
        SimpleHologram.onReload();
    }

    @Deprecated
    public static void onReload() {
        if (tickingTask != null) {
            tickingTask.cancel();
        }
        tickingTask = SimpleHologram.scheduleTickingTask();
    }

    private static BukkitTask scheduleTickingTask() {
        return Common.runTimer(1, () -> {
            Iterator<SimpleHologram> it = registeredItems.iterator();
            while (it.hasNext()) {
                SimpleHologram model = it.next();
                if (!model.isSpawned()) continue;
                if (!model.getEntity().isValid() || model.getEntity().isDead()) {
                    model.removeLore();
                    model.getEntity().remove();
                    it.remove();
                    continue;
                }
                model.tick();
            }
        });
    }

    public SimpleHologram spawn() {
        Valid.checkBoolean(!this.isSpawned(), this + " is already spawned!", new Object[0]);
        Valid.checkNotEmpty(this.loreLines, "Call lore() first before calling spawn method for " + this);
        this.entity = this.createEntity();
        Valid.checkNotNull(this.entity, "Failed to spawn entity from " + this);
        this.drawLore(this.lastTeleportLocation);
        return this;
    }

    protected abstract Entity createEntity();

    private void drawLore(Location location) {
        if (this.entity instanceof ArmorStand && ((ArmorStand)this.entity).isSmall()) {
            location = location.add(0.0, -0.5, 0.0);
        }
        for (String loreLine : this.loreLines) {
            ArmorStand armorStand = (ArmorStand)location.getWorld().spawnEntity(location, EntityType.ARMOR_STAND);
            armorStand.setGravity(false);
            armorStand.setVisible(false);
            Remain.setCustomName((Entity)armorStand, loreLine);
            location = location.subtract(0.0, loreLineHeight, 0.0);
            this.loreEntities.add(armorStand);
        }
    }

    private void tick() {
        if (this.pendingTeleport != null) {
            this.entity.teleport(this.pendingTeleport);
            for (ArmorStand loreEntity : this.loreEntities) {
                loreEntity.teleport(this.pendingTeleport);
            }
            this.pendingTeleport = null;
            return;
        }
        this.onTick();
        for (Tuple<CompParticle, Object> tuple : this.particles) {
            CompParticle particle = tuple.getKey();
            Object extra = tuple.getValue();
            if (extra instanceof CompMaterial) {
                particle.spawn(this.getLocation(), (CompMaterial)((Object)extra));
                continue;
            }
            if (!(extra instanceof Double)) continue;
            particle.spawn(this.getLocation(), (Double)extra);
        }
    }

    protected void onTick() {
    }

    public final boolean isSpawned() {
        return this.entity != null;
    }

    public final void removeLore() {
        this.loreEntities.forEach(Entity::remove);
    }

    public final SimpleHologram setLore(String ... lore) {
        this.loreLines.clear();
        this.loreLines.addAll(Arrays.asList(lore));
        return this;
    }

    public final void addParticleEffect(CompParticle particle) {
        this.addParticleEffect(particle, null);
    }

    public final void addParticleEffect(CompParticle particle, CompMaterial data) {
        this.particles.add(new Tuple<CompParticle, CompMaterial>(particle, data));
    }

    public final Location getLocation() {
        this.checkSpawned("getLocation");
        return this.entity.getLocation();
    }

    public final Location getLastTeleportLocation() {
        return this.lastTeleportLocation.clone();
    }

    public final void teleport(Location location) {
        Valid.checkBoolean(this.pendingTeleport == null, this + " is already pending teleport to " + this.pendingTeleport, new Object[0]);
        this.checkSpawned("teleport");
        this.lastTeleportLocation.setX(location.getY());
        this.lastTeleportLocation.setY(location.getY());
        this.lastTeleportLocation.setZ(location.getZ());
        this.pendingTeleport = location;
    }

    public final void remove() {
        this.removeLore();
        if (this.entity != null) {
            this.entity.remove();
        }
        registeredItems.remove(this);
    }

    private void checkSpawned(String method) {
        Valid.checkBoolean(this.isSpawned(), this + " is not spawned, cannot call " + method + "!", new Object[0]);
    }

    public String toString() {
        return "ArmorStandItem{spawnLocation=" + Common.shortLocation(this.lastTeleportLocation) + ", spawned=" + this.isSpawned() + "}";
    }

    public static final void deleteAll() {
        Iterator<SimpleHologram> it = registeredItems.iterator();
        while (it.hasNext()) {
            SimpleHologram item = it.next();
            if (item.isSpawned()) {
                item.getEntity().remove();
            }
            item.removeLore();
            it.remove();
        }
    }

    public static double getLoreLineHeight() {
        return loreLineHeight;
    }

    public static void setLoreLineHeight(double loreLineHeight) {
        SimpleHologram.loreLineHeight = loreLineHeight;
    }

    public static Set<SimpleHologram> getRegisteredItems() {
        return registeredItems;
    }

    public List<ArmorStand> getLoreEntities() {
        return this.loreEntities;
    }

    public List<String> getLoreLines() {
        return this.loreLines;
    }

    public List<Tuple<CompParticle, Object>> getParticles() {
        return this.particles;
    }

    public Entity getEntity() {
        return this.entity;
    }
}

