/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.NonNull;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import sk.adonikeoffice.epicchat.lib.ChatUtil;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.MathUtil;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.model.SimpleEnchantmentTarget;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.remain.Remain;

public abstract class SimpleEnchantment
extends Enchantment {
    private static final Pattern VALID_NAMESPACE = Pattern.compile("[a-z0-9._-]+");
    private final String name;
    private final int maxLevel;

    protected SimpleEnchantment(String name, int maxLevel) {
        super(SimpleEnchantment.toKey(name));
        this.name = name;
        this.maxLevel = maxLevel;
        Remain.registerEnchantment(this);
    }

    private static NamespacedKey toKey(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (!MinecraftVersion.atLeast(MinecraftVersion.V.v1_13)) {
            throw new RuntimeException("SimpleEnchantment requires Minecraft 1.13.2 or greater. Cannot make " + name);
        }
        name = new String(name);
        name = name.toLowerCase().replace(" ", "_");
        Valid.checkBoolean((name = ChatUtil.replaceDiacritic(name)) != null && VALID_NAMESPACE.matcher(name).matches(), "Enchant name must only contain English alphabet names: " + name, new Object[0]);
        return new NamespacedKey((Plugin)SimplePlugin.getInstance(), name);
    }

    protected void onDamage(int level, LivingEntity damager, EntityDamageByEntityEvent event) {
    }

    protected void onInteract(int level, PlayerInteractEvent event) {
    }

    protected void onBreakBlock(int level, BlockBreakEvent event) {
    }

    protected void onShoot(int level, LivingEntity shooter, ProjectileLaunchEvent event) {
    }

    protected void onHit(int level, LivingEntity shooter, ProjectileHitEvent event) {
    }

    public ItemStack applyTo(ItemStack item, int level) {
        ItemMeta meta = item.getItemMeta();
        meta.addEnchant((Enchantment)this, level, true);
        item.setItemMeta(meta);
        return item;
    }

    public String getLore(int level) {
        return this.name + " " + MathUtil.toRoman(level);
    }

    public SimpleEnchantmentTarget getCustomItemTarget() {
        return SimpleEnchantmentTarget.BREAKABLE;
    }

    public Material enchantMaterial() {
        return null;
    }

    public Set<Material> enchantMaterials() {
        return new HashSet<Material>();
    }

    public EnchantmentTarget getItemTarget() {
        return EnchantmentTarget.BREAKABLE;
    }

    public boolean conflictsWith(Enchantment other) {
        return false;
    }

    public boolean canEnchantItem(ItemStack item) {
        return true;
    }

    public int getStartLevel() {
        return 1;
    }

    public boolean isTreasure() {
        return false;
    }

    public boolean isCursed() {
        return false;
    }

    public final int getMaxLevel() {
        return this.maxLevel;
    }

    public final String getName() {
        return this.name;
    }

    public static Map<SimpleEnchantment, Integer> findEnchantments(ItemStack item) {
        Map vanilla;
        HashMap<SimpleEnchantment, Integer> map = new HashMap<SimpleEnchantment, Integer>();
        if (item == null) {
            return map;
        }
        try {
            vanilla = item.hasItemMeta() ? item.getItemMeta().getEnchants() : new HashMap();
        }
        catch (NoSuchMethodError err) {
            if (Remain.hasItemMeta()) {
                err.printStackTrace();
            }
            return map;
        }
        catch (NullPointerException ex) {
            return map;
        }
        for (Map.Entry e : vanilla.entrySet()) {
            Enchantment enchantment = (Enchantment)e.getKey();
            int level = (Integer)e.getValue();
            if (!(enchantment instanceof SimpleEnchantment)) continue;
            map.put((SimpleEnchantment)enchantment, level);
        }
        return map;
    }

    @Deprecated
    public static ItemStack addEnchantmentLores(ItemStack item) {
        ArrayList<String> customEnchants = new ArrayList<String>();
        try {
            for (Map.Entry e : item.getEnchantments().entrySet()) {
                String lore;
                if (!(e.getKey() instanceof SimpleEnchantment) || (lore = ((SimpleEnchantment)((Object)e.getKey())).getLore((Integer)e.getValue())) == null || lore.isEmpty()) continue;
                customEnchants.add(Common.colorize("&r&7" + lore));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (!customEnchants.isEmpty()) {
            ItemMeta meta = item.hasItemMeta() ? item.getItemMeta() : Bukkit.getItemFactory().getItemMeta(item.getType());
            List originalLore = meta.hasLore() ? meta.getLore() : new ArrayList();
            ArrayList<String> finalLore = new ArrayList<String>();
            ArrayList<String> colorlessOriginals = new ArrayList<String>();
            for (String original : originalLore) {
                colorlessOriginals.add(ChatColor.stripColor((String)Common.colorize(original)));
            }
            for (String customEnchant : customEnchants) {
                String colorlessEnchant = ChatColor.stripColor((String)Common.colorize(customEnchant));
                if (colorlessOriginals.contains(colorlessEnchant)) continue;
                finalLore.add(customEnchant);
            }
            finalLore.addAll(originalLore);
            meta.setLore(finalLore);
            item.setItemMeta(meta);
            return item;
        }
        return null;
    }
}

