/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import lombok.NonNull;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import sk.adonikeoffice.epicchat.lib.ChatUtil;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.PlayerUtil;
import sk.adonikeoffice.epicchat.lib.SerializeUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.collection.SerializedMap;
import sk.adonikeoffice.epicchat.lib.model.ConfigSerializable;
import sk.adonikeoffice.epicchat.lib.model.HookManager;
import sk.adonikeoffice.epicchat.lib.model.JavaScriptExecutor;
import sk.adonikeoffice.epicchat.lib.model.Variables;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;
import sk.adonikeoffice.epicchat.lib.remain.Remain;

public final class SimpleComponent
implements ConfigSerializable {
    public static boolean STRIP_OVERSIZED_COMPONENTS = true;
    private static final Pattern URL_PATTERN = Pattern.compile("^(https?:\\/\\/|)(www\\.|)[\\w-:.\\d]{1,256}\\.[\\w()]{1,12}\\b([\\w-@:%.,+~#=?!&$/\\d]*)$");
    private final List<Part> pastComponents = new ArrayList<Part>();
    private Part currentComponent;

    private SimpleComponent(String text) {
        if (Common.stripColors(text).startsWith("<center>")) {
            text = ChatUtil.center(text.replace("<center>", "").trim());
        }
        this.currentComponent = new Part(text);
    }

    private SimpleComponent() {
    }

    public SimpleComponent onHover(Collection<String> texts) {
        return this.onHover(Common.toArray(texts));
    }

    public SimpleComponent onHover(String ... lines) {
        String joined = Common.colorize(String.join((CharSequence)"\n", lines));
        this.currentComponent.hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new BaseComponent[]{new TextComponent(TextComponent.fromLegacyText((String)joined))});
        return this;
    }

    public SimpleComponent onHover(ItemStack item) {
        if (CompMaterial.isAir(item.getType())) {
            return this.onHover("Air");
        }
        this.currentComponent.hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_ITEM, new BaseComponent[]{new TextComponent(Remain.toJson(item))});
        return this;
    }

    public SimpleComponent viewPermission(String viewPermission) {
        this.currentComponent.viewPermission = viewPermission;
        return this;
    }

    public SimpleComponent viewCondition(String viewCondition) {
        this.currentComponent.viewCondition = viewCondition;
        return this;
    }

    public SimpleComponent onClickRunCmd(String text) {
        return this.onClick(ClickEvent.Action.RUN_COMMAND, text);
    }

    public SimpleComponent onClickSuggestCmd(String text) {
        return this.onClick(ClickEvent.Action.SUGGEST_COMMAND, text);
    }

    public SimpleComponent onClickOpenUrl(String url) {
        return this.onClick(ClickEvent.Action.OPEN_URL, url);
    }

    public SimpleComponent onClick(ClickEvent.Action action, String text) {
        this.currentComponent.clickEvent = new ClickEvent(action, text);
        return this;
    }

    public SimpleComponent onClickInsert(String insertion) {
        this.currentComponent.insertion = insertion;
        return this;
    }

    public SimpleComponent appendFirst(SimpleComponent component) {
        this.pastComponents.add(0, component.currentComponent);
        this.pastComponents.addAll(0, component.pastComponents);
        return this;
    }

    public SimpleComponent append(String text) {
        return this.append(text, true);
    }

    public SimpleComponent append(String text, boolean colorize) {
        return this.append(text, null, colorize);
    }

    public SimpleComponent append(String text, BaseComponent inheritFormatting) {
        return this.append(text, inheritFormatting, true);
    }

    public SimpleComponent append(String text, BaseComponent inheritFormatting, boolean colorize) {
        BaseComponent inherit;
        Object object = inherit = inheritFormatting != null ? inheritFormatting : this.currentComponent.toTextComponent(false, null);
        if (inherit != null && inherit.getExtra() != null && !inherit.getExtra().isEmpty()) {
            inherit = (BaseComponent)inherit.getExtra().get(inherit.getExtra().size() - 1);
        }
        if (colorize) {
            List<String> formatContents = Arrays.asList(text.split("\n"));
            for (int i = 0; i < formatContents.size(); ++i) {
                String line = formatContents.get(i);
                if (!Common.stripColors(line).startsWith("<center>")) continue;
                formatContents.set(i, ChatUtil.center(line.replace("<center>", "")));
            }
            text = String.join((CharSequence)"\n", formatContents);
        }
        this.pastComponents.add(this.currentComponent);
        this.currentComponent = new Part(colorize ? Common.colorize(text) : text);
        this.currentComponent.inheritFormatting = inherit;
        return this;
    }

    public SimpleComponent append(SimpleComponent component) {
        this.pastComponents.add(this.currentComponent);
        this.pastComponents.addAll(component.pastComponents);
        BaseComponent inherit = (BaseComponent)Common.getOrDefault(component.currentComponent.inheritFormatting, this.currentComponent.toTextComponent(false, null));
        if (inherit != null && inherit.getExtra() != null && !inherit.getExtra().isEmpty()) {
            inherit = (BaseComponent)inherit.getExtra().get(inherit.getExtra().size() - 1);
        }
        this.currentComponent = component.currentComponent;
        this.currentComponent.inheritFormatting = inherit;
        return this;
    }

    public String getPlainMessage() {
        return this.build(null).toLegacyText();
    }

    public TextComponent getTextComponent() {
        return this.build(null);
    }

    public TextComponent build(CommandSender receiver) {
        TextComponent currentComponent;
        TextComponent preparedComponent = null;
        for (Part part : this.pastComponents) {
            TextComponent component = part.toTextComponent(true, receiver);
            if (component == null) continue;
            if (preparedComponent == null) {
                preparedComponent = component;
                continue;
            }
            this.addExtra((BaseComponent)preparedComponent, (BaseComponent)component);
        }
        TextComponent textComponent = currentComponent = this.currentComponent == null ? null : this.currentComponent.toTextComponent(true, receiver);
        if (currentComponent != null) {
            if (preparedComponent == null) {
                preparedComponent = currentComponent;
            } else {
                this.addExtra((BaseComponent)preparedComponent, (BaseComponent)currentComponent);
            }
        }
        return Common.getOrDefault(preparedComponent, new TextComponent(""));
    }

    private void addExtra(BaseComponent component, BaseComponent extra) {
        try {
            component.addExtra(extra);
        }
        catch (Throwable t) {
            ArrayList<BaseComponent> safeList = new ArrayList<BaseComponent>();
            if (component.getExtra() != null) {
                safeList.addAll(component.getExtra());
            }
            safeList.add(extra);
            component.setExtra(safeList);
        }
    }

    public SimpleComponent replace(String variable, Object value) {
        String serialized = SerializeUtil.serialize(SerializeUtil.Mode.YAML, value).toString();
        for (Part part : this.pastComponents) {
            Valid.checkNotNull(part.text);
            part.text = part.text.replace(variable, serialized);
        }
        Valid.checkNotNull(this.currentComponent.text);
        this.currentComponent.text = this.currentComponent.text.replace(variable, serialized);
        return this;
    }

    public <T extends CommandSender> void send(T ... receivers) {
        this.send((Iterable<T>)Arrays.asList(receivers));
    }

    public <T extends CommandSender> void send(Iterable<T> receivers) {
        this.sendAs(null, receivers);
    }

    public <T extends CommandSender> void sendAs(CommandSender sender, Iterable<T> receivers) {
        for (CommandSender receiver : receivers) {
            TextComponent component = this.build(receiver);
            if (receiver instanceof Player && sender instanceof Player) {
                this.setRelationPlaceholders(component, (Player)receiver, (Player)sender);
            }
            if (STRIP_OVERSIZED_COMPONENTS && Remain.toJson(new BaseComponent[]{component}).length() + 1 >= Short.MAX_VALUE) {
                String legacy = Common.colorize(component.toLegacyText());
                if (legacy.length() + 1 >= Short.MAX_VALUE) {
                    Common.warning("JSON Message to " + receiver.getName() + " was too large and could not be sent: '" + legacy + "'");
                    continue;
                }
                Common.warning("JSON Message to " + receiver.getName() + " was too large, removing interactive elements to avoid kick. Sending plain: '" + legacy + "'");
                receiver.sendMessage(legacy);
                continue;
            }
            Remain.sendComponent(receiver, component);
        }
    }

    private void setRelationPlaceholders(TextComponent component, Player receiver, Player sender) {
        component.setText(HookManager.replaceRelationPlaceholders(sender, receiver, component.getText()));
        if (component.getExtra() == null) {
            return;
        }
        for (BaseComponent extra : component.getExtra()) {
            if (!(extra instanceof TextComponent)) continue;
            TextComponent text = (TextComponent)extra;
            ClickEvent clickEvent = text.getClickEvent();
            HoverEvent hoverEvent = text.getHoverEvent();
            if (clickEvent != null) {
                text.setClickEvent(new ClickEvent(clickEvent.getAction(), HookManager.replaceRelationPlaceholders(sender, receiver, clickEvent.getValue())));
            }
            if (hoverEvent != null) {
                for (BaseComponent hoverBaseComponent : hoverEvent.getValue()) {
                    if (!(hoverBaseComponent instanceof TextComponent)) continue;
                    TextComponent hoverTextComponent = (TextComponent)hoverBaseComponent;
                    hoverTextComponent.setText(HookManager.replaceRelationPlaceholders(sender, receiver, hoverTextComponent.getText()));
                }
            }
            this.setRelationPlaceholders(text, receiver, sender);
        }
    }

    public String toString() {
        return this.serialize().toStringFormatted();
    }

    @Override
    public SerializedMap serialize() {
        SerializedMap map = new SerializedMap();
        map.putIf("Current_Component", this.currentComponent);
        map.put("Past_Components", this.pastComponents);
        return map;
    }

    public static SimpleComponent deserialize(SerializedMap map) {
        SimpleComponent component = new SimpleComponent();
        component.currentComponent = map.get("Current_Component", Part.class);
        component.pastComponents.addAll(map.getList("Past_Components", Part.class));
        return component;
    }

    private static TextComponent[] toComponent(@NonNull String message, BaseComponent inheritFormatting) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        ArrayList<TextComponent> components = new ArrayList<TextComponent>();
        if (inheritFormatting != null) {
            if (inheritFormatting.isBold()) {
                message = ChatColor.BOLD + message;
            }
            if (inheritFormatting.isItalic()) {
                message = ChatColor.ITALIC + message;
            }
            if (inheritFormatting.isObfuscated()) {
                message = ChatColor.MAGIC + message;
            }
            if (inheritFormatting.isStrikethrough()) {
                message = ChatColor.STRIKETHROUGH + message;
            }
            if (inheritFormatting.isUnderlined()) {
                message = ChatColor.UNDERLINE + message;
            }
            message = inheritFormatting.getColor() + message;
        }
        StringBuilder builder = new StringBuilder();
        TextComponent component = new TextComponent();
        for (int index = 0; index < message.length(); ++index) {
            TextComponent old;
            char letter = message.charAt(index);
            if (letter == '\u00a7') {
                ChatColor format;
                if (++index >= message.length()) break;
                letter = message.charAt(index);
                if (letter >= 'A' && letter <= 'Z') {
                    letter = (char)(letter + 32);
                }
                if (letter == 'x' && index + 12 < message.length()) {
                    StringBuilder hex = new StringBuilder("#");
                    for (int j = 0; j < 6; ++j) {
                        hex.append(message.charAt(index + 2 + j * 2));
                    }
                    try {
                        format = ChatColor.of((String)hex.toString());
                    }
                    catch (IllegalArgumentException | NoSuchMethodError ex) {
                        format = null;
                    }
                    index += 12;
                } else {
                    format = ChatColor.getByChar((char)letter);
                }
                if (format == null) continue;
                if (builder.length() > 0) {
                    old = component;
                    component = new TextComponent(old);
                    old.setText(builder.toString());
                    builder = new StringBuilder();
                    components.add(old);
                }
                if (format == ChatColor.BOLD) {
                    component.setBold(Boolean.valueOf(true));
                    continue;
                }
                if (format == ChatColor.ITALIC) {
                    component.setItalic(Boolean.valueOf(true));
                    continue;
                }
                if (format == ChatColor.UNDERLINE) {
                    component.setUnderlined(Boolean.valueOf(true));
                    continue;
                }
                if (format == ChatColor.STRIKETHROUGH) {
                    component.setStrikethrough(Boolean.valueOf(true));
                    continue;
                }
                if (format == ChatColor.MAGIC) {
                    component.setObfuscated(Boolean.valueOf(true));
                    continue;
                }
                if (format == ChatColor.RESET) {
                    format = ChatColor.WHITE;
                    component = new TextComponent();
                    component.setColor(format);
                    continue;
                }
                component = new TextComponent();
                component.setColor(format);
                continue;
            }
            int pos = message.indexOf(32, index);
            if (pos == -1) {
                pos = message.length();
            }
            if (URL_PATTERN.matcher(message).region(index, pos).find()) {
                if (builder.length() > 0) {
                    old = component;
                    component = new TextComponent(old);
                    old.setText(builder.toString());
                    builder = new StringBuilder();
                    components.add(old);
                }
                old = component;
                component = new TextComponent(old);
                String urlString = message.substring(index, pos);
                component.setText(urlString);
                if (urlString.endsWith(",") || urlString.endsWith(".") || urlString.endsWith(":") || urlString.endsWith("?") || urlString.endsWith("!")) {
                    urlString = urlString.substring(0, urlString.length() - 1);
                }
                component.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, urlString.startsWith("http") ? urlString : "http://" + urlString));
                components.add(component);
                index += pos - index - 1;
                component = old;
                continue;
            }
            builder.append(letter);
        }
        component.setText(builder.toString());
        components.add(component);
        return new TextComponent[]{new TextComponent((BaseComponent[])components.toArray(new TextComponent[components.size()]))};
    }

    public static SimpleComponent empty() {
        return SimpleComponent.of(true, "");
    }

    public static SimpleComponent of(String text) {
        return SimpleComponent.of(true, text);
    }

    public static SimpleComponent of(boolean colorize, String text) {
        return new SimpleComponent(colorize ? Common.colorize(text) : text);
    }

    static final class Part
    implements ConfigSerializable {
        private String text;
        private String viewPermission;
        private String viewCondition;
        private HoverEvent hoverEvent;
        private ClickEvent clickEvent;
        private String insertion;
        private BaseComponent inheritFormatting;

        private Part(String text) {
            Valid.checkNotNull(text, "Part text cannot be null");
            this.text = text;
        }

        @Override
        public SerializedMap serialize() {
            SerializedMap map = new SerializedMap();
            map.put("Text", this.text);
            map.putIf("View_Permission", this.viewPermission);
            map.putIf("View_Condition", this.viewCondition);
            map.putIf("Hover_Event", this.hoverEvent);
            map.putIf("Click_Event", this.clickEvent);
            map.putIf("Insertion", this.insertion);
            map.putIf("Inherit_Formatting", this.inheritFormatting);
            return map;
        }

        public static Part deserialize(SerializedMap map) {
            Part part = new Part(map.getString("Text"));
            part.viewPermission = map.getString("View_Permission");
            part.viewCondition = map.getString("View_Condition");
            part.hoverEvent = map.get("Hover_Event", HoverEvent.class);
            part.clickEvent = map.get("Click_Event", ClickEvent.class);
            part.insertion = map.getString("Insertion");
            part.inheritFormatting = map.get("Inherit_Formatting", BaseComponent.class);
            return part;
        }

        private TextComponent toTextComponent(boolean checkForReceiver, CommandSender receiver) {
            if (checkForReceiver && !this.canSendTo(receiver) || this.isEmpty()) {
                return null;
            }
            List base = SimpleComponent.toComponent(this.text, this.inheritFormatting)[0].getExtra();
            for (BaseComponent part : base) {
                if (this.hoverEvent != null) {
                    part.setHoverEvent(this.hoverEvent);
                }
                if (this.clickEvent != null) {
                    part.setClickEvent(this.clickEvent);
                }
                if (this.insertion == null) continue;
                try {
                    part.setInsertion(this.insertion);
                }
                catch (Throwable throwable) {}
            }
            return new TextComponent(base.toArray(new BaseComponent[base.size()]));
        }

        private boolean isEmpty() {
            return this.text.isEmpty() && this.hoverEvent == null && this.clickEvent == null && this.insertion == null;
        }

        private boolean canSendTo(CommandSender receiver) {
            if (!(this.viewPermission == null || this.viewPermission.isEmpty() || receiver != null && PlayerUtil.hasPerm((Permissible)receiver, this.viewPermission))) {
                return false;
            }
            if (this.viewCondition != null && !this.viewCondition.isEmpty()) {
                if (receiver == null) {
                    return false;
                }
                Object result = JavaScriptExecutor.run(Variables.replace(this.viewCondition, receiver), receiver);
                if (result != null) {
                    Valid.checkBoolean(result instanceof Boolean, "View condition must return Boolean not " + (result == null ? "null" : result.getClass()) + " for component: " + this, new Object[0]);
                    if (!((Boolean)result).booleanValue()) {
                        return false;
                    }
                }
            }
            return true;
        }

        public String toString() {
            return this.serialize().toStringFormatted();
        }
    }
}

