/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.collection.SerializedMap;
import sk.adonikeoffice.epicchat.lib.model.Variables;

public final class Replacer {
    public static List<String> replaceArray(List<String> list, Object ... replacements) {
        String joined = String.join((CharSequence)"%FLPV%", list);
        joined = Replacer.replaceArray(joined, replacements);
        return Arrays.asList(joined.split("%FLPV%"));
    }

    public static String replaceArray(String message, Object ... replacements) {
        SerializedMap map = SerializedMap.ofArray(replacements);
        return Replacer.replaceVariables(message, map);
    }

    public static List<String> replaceVariables(List<String> list, SerializedMap replacements) {
        String joined = String.join((CharSequence)"%FLPV%", list);
        joined = Replacer.replaceVariables(joined, replacements);
        return Arrays.asList(joined.split("%FLPV%"));
    }

    public static String replaceVariables(String message, SerializedMap variables) {
        if (message == null) {
            return null;
        }
        if ("".equals(message)) {
            return "";
        }
        message = Replacer.replaceVariables(message, variables, Variables.VARIABLE_PATTERN.matcher(message));
        message = Replacer.replaceVariables(message, variables, Variables.BRACKET_VARIABLE_PATTERN.matcher(message));
        return message;
    }

    private static String replaceVariables(String message, SerializedMap variables, Matcher matcher) {
        while (matcher.find()) {
            String variable = matcher.group(1);
            boolean frontSpace = false;
            boolean backSpace = false;
            if (variable.startsWith("+")) {
                variable = variable.substring(1);
                frontSpace = true;
            }
            if (variable.endsWith("+")) {
                variable = variable.substring(0, variable.length() - 1);
                backSpace = true;
            }
            String value = null;
            for (Map.Entry<String, Object> entry : variables.entrySet()) {
                String variableKey = entry.getKey();
                variableKey = variableKey.startsWith("{") ? variableKey.substring(1) : variableKey;
                if (!(variableKey = variableKey.endsWith("}") ? variableKey.substring(0, variableKey.length() - 1) : variableKey).equals(variable)) continue;
                value = entry.getValue() == null ? "null" : entry.getValue().toString();
            }
            if (value == null) continue;
            boolean emptyColorless = Common.stripColors(value).isEmpty();
            value = value.isEmpty() ? "" : (frontSpace && !emptyColorless ? " " : "") + Common.colorize(value) + (backSpace && !emptyColorless ? " " : "");
            message = message.replace(matcher.group(), value);
        }
        return message;
    }
}

