/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.file.Path;
import org.bukkit.Bukkit;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.remain.Remain;

class RegionAccessor {
    private static Constructor<?> regionFileConstructor;
    private static Method isChunkSaved;
    private static final boolean atleast1_13;
    private static final boolean atleast1_14;
    private static final boolean atleast1_15;
    private static final boolean atleast1_16;
    private static final boolean atleast1_18;
    private static final String saveMethodName;

    RegionAccessor() {
    }

    static Object getRegionFile(String worldName, File file) {
        try {
            File container = new File(Bukkit.getWorldContainer(), worldName);
            return atleast1_18 ? regionFileConstructor.newInstance(file.toPath(), container.toPath(), false) : (atleast1_16 ? regionFileConstructor.newInstance(file, container, false) : (atleast1_15 ? regionFileConstructor.newInstance(file, container) : regionFileConstructor.newInstance(file)));
        }
        catch (Throwable ex) {
            throw new RuntimeException("Could not create region file from " + file, ex);
        }
    }

    static boolean isChunkSaved(Object region, int x, int z) {
        try {
            if (MinecraftVersion.newerThan(MinecraftVersion.V.v1_13)) {
                Object chunkCoordinates = ReflectionUtil.getNMSClass("ChunkCoordIntPair", "net.minecraft.world.level.ChunkCoordIntPair").getConstructor(Integer.TYPE, Integer.TYPE).newInstance(x, z);
                return (Boolean)isChunkSaved.invoke(region, chunkCoordinates);
            }
            return (Boolean)isChunkSaved.invoke(region, x, z);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionUtil.ReflectionException(ex, "Could not find if region file " + region + " has chunk at " + x + " " + z);
        }
    }

    static void save(Object region) {
        try {
            region.getClass().getDeclaredMethod(saveMethodName, new Class[0]).invoke(region, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionUtil.ReflectionException(ex, "Error saving region " + region);
        }
    }

    static {
        atleast1_13 = MinecraftVersion.atLeast(MinecraftVersion.V.v1_13);
        atleast1_14 = MinecraftVersion.atLeast(MinecraftVersion.V.v1_14);
        atleast1_15 = MinecraftVersion.atLeast(MinecraftVersion.V.v1_15);
        atleast1_16 = MinecraftVersion.atLeast(MinecraftVersion.V.v1_16);
        atleast1_18 = MinecraftVersion.atLeast(MinecraftVersion.V.v1_18);
        saveMethodName = atleast1_13 ? "close" : "c";
        try {
            Class<?> regionFileClass = ReflectionUtil.getNMSClass("RegionFile", "net.minecraft.world.level.chunk.storage.RegionFile");
            Constructor<?> constructor = atleast1_18 ? regionFileClass.getConstructor(Path.class, Path.class, Boolean.TYPE) : (atleast1_16 ? regionFileClass.getConstructor(File.class, File.class, Boolean.TYPE) : (regionFileConstructor = atleast1_15 ? regionFileClass.getConstructor(File.class, File.class) : regionFileClass.getConstructor(File.class)));
            isChunkSaved = atleast1_14 ? regionFileClass.getMethod("b", ReflectionUtil.getNMSClass("ChunkCoordIntPair", "net.minecraft.world.level.ChunkCoordIntPair")) : regionFileClass.getMethod(atleast1_13 ? "b" : "c", Integer.TYPE, Integer.TYPE);
        }
        catch (ReflectiveOperationException ex) {
            Remain.sneaky(ex);
        }
    }
}

