/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import sk.adonikeoffice.epicchat.lib.RandomUtil;
import sk.adonikeoffice.epicchat.lib.Valid;

public final class RangedValue {
    private final Number min;
    private final Number max;

    public RangedValue(Number value) {
        this(value, value);
    }

    public RangedValue(Number min, Number max) {
        Valid.checkBoolean(min.longValue() <= max.longValue(), "Minimum must be lower or equal maximum", new Object[0]);
        this.min = min;
        this.max = max;
    }

    public double getMinDouble() {
        return this.min.doubleValue();
    }

    public double getMaxDouble() {
        return this.max.doubleValue();
    }

    public long getMinLong() {
        return this.min.longValue();
    }

    public long getMaxLong() {
        return this.max.longValue();
    }

    public boolean isInRangeLong(long value) {
        return value >= this.min.longValue() && value <= this.max.longValue();
    }

    public boolean isInRangeDouble(double value) {
        return value >= this.min.doubleValue() && value <= this.max.doubleValue();
    }

    public int getRandomInt() {
        return RandomUtil.nextBetween((int)this.getMinLong(), (int)this.getMaxLong());
    }

    public boolean isStatic() {
        return this.min.longValue() == this.max.longValue();
    }

    public String toLine() {
        return this.min.longValue() + " - " + this.max.longValue();
    }

    public static RangedValue parse(String line) {
        String[] split;
        boolean secondNegative;
        line = line.replace(" ", "").trim();
        boolean firstNegative = false;
        if (line.startsWith("-")) {
            firstNegative = true;
            line = line.substring(1);
        }
        boolean bl = secondNegative = (split = line.split("\\-")).length == 3;
        String[] parts = split.length == 1 ? new String[]{(firstNegative ? "-" : "") + line} : new String[]{(firstNegative ? "-" : "") + split[0], secondNegative ? "-" + split[2] : split[1]};
        Valid.checkBoolean(parts.length == 1 || parts.length == 2, "Malformed value " + line, new Object[0]);
        String first = parts[0].trim();
        String second = parts.length == 2 ? parts[1].trim() : first;
        Valid.checkBoolean(Valid.isNumber(first), "Invalid ranged value 1. input: '" + first + "' from line: '" + line + "'. RangedValue no longer accepts human natural format, for this, use RangedSimpleTime instead.", new Object[0]);
        Valid.checkBoolean(Valid.isNumber(second), "Invalid ranged value 2. input: '" + second + "' from line: '" + line + "'. RangedValue no longer accepts human natural format, for this, use RangedSimpleTime instead.", new Object[0]);
        Double firstNumber = first.contains(".") ? Double.parseDouble(first) : (double)Long.parseLong(first);
        Double secondNumber = second.contains(".") ? Double.parseDouble(second) : (double)Long.parseLong(second);
        if (first.contains(".")) {
            Valid.checkBoolean(((Number)firstNumber).longValue() <= ((Number)secondNumber).longValue(), "First number cannot be greater than second: " + ((Number)firstNumber).longValue() + " vs " + ((Number)secondNumber).longValue() + " in " + line, new Object[0]);
        } else {
            Valid.checkBoolean(firstNumber <= secondNumber, "First number cannot be greater than second: " + firstNumber + " vs " + secondNumber + " in " + line, new Object[0]);
        }
        return new RangedValue(firstNumber, secondNumber);
    }

    public String toString() {
        return this.isStatic() ? this.min.longValue() + "" : this.min.longValue() + " - " + this.max.longValue();
    }

    public Number getMin() {
        return this.min;
    }

    public Number getMax() {
        return this.max;
    }
}

