/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import sk.adonikeoffice.epicchat.lib.RandomUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.model.SimpleTime;

public final class RangedSimpleTime {
    private final SimpleTime min;
    private final SimpleTime max;

    public RangedSimpleTime(SimpleTime time) {
        this(time, time);
    }

    public RangedSimpleTime(SimpleTime min, SimpleTime max) {
        Valid.checkBoolean(min.getTimeTicks() >= 0 && max.getTimeTicks() >= 0, "Values may not be negative", new Object[0]);
        Valid.checkBoolean(min.getTimeTicks() <= max.getTimeTicks(), "Minimum must be lower or equal maximum", new Object[0]);
        this.min = min;
        this.max = max;
    }

    public int getRandomTicks() {
        return RandomUtil.nextBetween(this.min.getTimeTicks(), this.max.getTimeTicks());
    }

    public int getRandomSeconds() {
        return RandomUtil.nextBetween((int)this.min.getTimeSeconds(), (int)this.max.getTimeSeconds());
    }

    public boolean isInRangeTicks(int ticks) {
        return ticks >= this.min.getTimeTicks() && ticks <= this.min.getTimeTicks();
    }

    public boolean isInRangeSeconds(int seconds) {
        return (long)seconds >= this.min.getTimeSeconds() && (long)seconds <= this.min.getTimeSeconds();
    }

    public String toLine() {
        return (this.min.getRaw() + (this.min.equals(this.max) ? "" : " - " + this.max.getRaw())).replace("  ", " ");
    }

    public String toString() {
        return "RangedSimpleTime{min=" + this.min + ", max=" + this.max + "}";
    }

    public static RangedSimpleTime parse(String line) {
        String[] parts = line.split("\\-");
        Valid.checkBoolean(parts.length == 1 || parts.length == 2, "Malformed RangedSimpleTime " + line, new Object[0]);
        String min = parts[0].trim();
        String max = (parts.length == 2 ? parts[1] : min).trim();
        return new RangedSimpleTime(SimpleTime.from(min), SimpleTime.from(max));
    }

    public SimpleTime getMin() {
        return this.min;
    }

    public SimpleTime getMax() {
        return this.max;
    }
}

