/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketListener;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.collection.StrictSet;
import sk.adonikeoffice.epicchat.lib.remain.Remain;

class ProtocolLibHook {
    private final ProtocolManager manager;
    private final StrictSet<Object> registeredListeners = new StrictSet();

    ProtocolLibHook() {
        this.manager = ProtocolLibrary.getProtocolManager();
    }

    final void addPacketListener(Object listener) {
        Valid.checkBoolean(listener instanceof PacketListener, "Listener must extend or implements PacketListener or PacketAdapter", new Object[0]);
        try {
            this.manager.addPacketListener((PacketListener)listener);
        }
        catch (Throwable t) {
            Common.error(t, "Failed to register ProtocolLib packet listener! Ensure you have the latest ProtocolLib. If you reloaded, try a fresh startup (some ProtocolLib esp. for 1.8.8 fails on reload).");
            return;
        }
        this.registeredListeners.add(listener);
    }

    final void removePacketListeners(Plugin plugin) {
        this.manager.removePacketListeners(plugin);
        this.registeredListeners.clear();
    }

    final void sendPacket(PacketContainer packet) {
        for (Player player : Remain.getOnlinePlayers()) {
            this.sendPacket(player, packet);
        }
    }

    final void sendPacket(Player player, Object packet) {
        Valid.checkNotNull(player);
        Valid.checkBoolean(packet instanceof PacketContainer, "Packet must be instance of PacketContainer from ProtocolLib", new Object[0]);
        try {
            this.manager.sendServerPacket(player, (PacketContainer)packet);
        }
        catch (Exception e) {
            Common.error(e, "Failed to send " + ((PacketContainer)packet).getType() + " packet to " + player.getName());
        }
    }

    final boolean isTemporaryPlayer(Player player) {
        try {
            return player != null && player.getClass().getSimpleName().contains("TemporaryPlayer");
        }
        catch (NoClassDefFoundError err) {
            return false;
        }
    }
}

