/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.exception.FoException;

class PlotSquaredHook {
    private final boolean legacy;

    PlotSquaredHook() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("PlotSquared");
        Valid.checkNotNull(plugin, "PlotSquared not hooked yet!");
        this.legacy = plugin.getDescription().getVersion().startsWith("3");
    }

    List<Player> getPlotPlayers(Player player) {
        Method wrap;
        ArrayList<Player> players = new ArrayList<Player>();
        Class plotPlayerClass = ReflectionUtil.lookupClass((this.legacy ? "com.intellectualcrafters.plot.object" : "com.plotsquared.core.player") + ".PlotPlayer");
        try {
            wrap = plotPlayerClass.getMethod("wrap", Player.class);
        }
        catch (ReflectiveOperationException ex) {
            try {
                wrap = plotPlayerClass.getMethod("wrap", Object.class);
            }
            catch (ReflectiveOperationException ex2) {
                try {
                    wrap = plotPlayerClass.getMethod("from", Object.class);
                }
                catch (ReflectiveOperationException ex3) {
                    throw new FoException(ex3, "PlotSquared could not convert " + player.getName() + " into PlotPlayer! Is the integration outdated?");
                }
            }
        }
        Object plotPlayer = ReflectionUtil.invokeStatic(wrap, player);
        Valid.checkNotNull(plotPlayer, "Failed to convert player " + player.getName() + " to PlotPlayer!");
        Object currentPlot = ReflectionUtil.invoke("getCurrentPlot", plotPlayer, new Object[0]);
        if (currentPlot != null) {
            for (Object playerInPlot : (Iterable)ReflectionUtil.invoke("getPlayersInPlot", currentPlot, new Object[0])) {
                UUID id = (UUID)ReflectionUtil.invoke("getUUID", playerInPlot, new Object[0]);
                Player online = Bukkit.getPlayer((UUID)id);
                if (online == null || !online.isOnline()) continue;
                players.add(online);
            }
        }
        return players;
    }
}

