/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.PlaceholderHook;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.expansion.Relational;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitTask;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.model.SimpleExpansion;
import sk.adonikeoffice.epicchat.lib.model.Variables;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;

class PlaceholderAPIHook {
    private static volatile VariablesInjector injector;

    PlaceholderAPIHook() {
        try {
            injector = new VariablesInjector();
            injector.register();
        }
        catch (Throwable throwable) {
            Common.error(throwable, "Failed to inject our variables into PlaceholderAPI!");
        }
    }

    final void unregister() {
        if (injector != null) {
            try {
                injector.unregister();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    final String replacePlaceholders(OfflinePlayer player, String msg) {
        try {
            return this.setPlaceholders(player, msg);
        }
        catch (Throwable t) {
            Common.error(t, "PlaceholderAPI failed to replace variables!", "Player: " + (player == null ? "none" : player.getName()), "Message: " + msg, "Error: %error");
            return msg;
        }
    }

    private String setPlaceholders(OfflinePlayer player, String text) {
        String oldText = text;
        HashMap<String, PlaceholderExpansion> hooks = new HashMap<String, PlaceholderExpansion>();
        for (PlaceholderExpansion expansion : PlaceholderAPIPlugin.getInstance().getLocalExpansionManager().getExpansions()) {
            hooks.put(expansion.getIdentifier().toLowerCase(), expansion);
        }
        if (hooks.isEmpty()) {
            return text;
        }
        text = this.setPlaceholders(player, oldText, text, hooks, Variables.VARIABLE_PATTERN.matcher(text));
        text = this.setPlaceholders(player, oldText, text, hooks, Variables.BRACKET_VARIABLE_PATTERN.matcher(text));
        return text;
    }

    private String setPlaceholders(OfflinePlayer player, String oldText, String text, Map<String, PlaceholderExpansion> hooks, Matcher matcher) {
        while (matcher.find()) {
            int index;
            String format = matcher.group(1);
            boolean frontSpace = false;
            boolean backSpace = false;
            if (format.startsWith("+")) {
                frontSpace = true;
                format = format.substring(1);
            }
            if (format.endsWith("+")) {
                backSpace = true;
                format = format.substring(0, format.length() - 1);
            }
            if ((index = format.indexOf("_")) <= 0 || index >= format.length()) continue;
            String identifier = format.substring(0, index).toLowerCase();
            String params = format.substring(index + 1);
            String finalFormat = format;
            if (!hooks.containsKey(identifier)) continue;
            Thread currentThread = Thread.currentThread();
            boolean main = Bukkit.isPrimaryThread();
            BukkitTask watchDog = Common.runLater(main ? 30 : 80, () -> {
                Common.logFramed("IMPORTANT: PREVENTED SERVER CRASH FROM PLACEHOLDERAPI", "", "Replacing PlaceholderAPI variable took over " + (main ? "1.5" : "4") + " sec", "and was interrupted to prevent hanging the server.", "", "This is typically caused when a variable sends", "blocking HTTP request, such as checking stuff on", "the Internet or resolving offline player names.", "This is NOT error in " + SimplePlugin.getNamed() + ", you need", "to contact placeholder expansion author instead.", "", "Variable: " + finalFormat, "Text: " + oldText, "Player: " + (player == null ? "none" : player.getName()));
                currentThread.stop();
            });
            String value = hooks.get(identifier).onRequest(player, params);
            watchDog.cancel();
            if (value == null) continue;
            value = Matcher.quoteReplacement(Common.colorize(value));
            text = text.replaceAll(Pattern.quote(matcher.group()), value.isEmpty() ? "" : (frontSpace ? " " : "") + value + (backSpace ? " " : ""));
        }
        return text;
    }

    final String replaceRelationPlaceholders(Player one, Player two, String message) {
        try {
            return this.setRelationalPlaceholders(one, two, message);
        }
        catch (Throwable t) {
            Common.error(t, "PlaceholderAPI failed to replace relation variables!", "Player one: " + one, "Player two: " + two, "Message: " + message, "Error: %error");
            return message;
        }
    }

    private String setRelationalPlaceholders(Player one, Player two, String text) {
        Map hooks = PlaceholderAPI.getPlaceholders();
        if (hooks.isEmpty()) {
            return text;
        }
        text = this.setRelationalPlaceholders(one, two, text, hooks, Variables.REL_VARIABLE_PATTERN.matcher(text));
        text = this.setRelationalPlaceholders(one, two, text, hooks, Variables.BRACKET_REL_VARIABLE_PATTERN.matcher(text));
        return text;
    }

    private String setRelationalPlaceholders(Player one, Player two, String text, Map<String, PlaceholderHook> hooks, Matcher matcher) {
        while (matcher.find()) {
            String format = matcher.group(2);
            int index = format.indexOf("_");
            if (index <= 0 || index >= format.length()) continue;
            String identifier = format.substring(0, index);
            String params = format.substring(index + 1);
            if (!hooks.containsKey(identifier) || !(hooks.get(identifier) instanceof Relational)) continue;
            Relational rel = (Relational)hooks.get(identifier);
            String value = one != null && two != null ? rel.onPlaceholderRequest(one, two, params) : "";
            if (value == null) continue;
            text = text.replaceAll(Pattern.quote(matcher.group()), Matcher.quoteReplacement(Common.colorize(value)));
        }
        return text;
    }

    private class VariablesInjector
    extends PlaceholderExpansion {
        private VariablesInjector() {
        }

        public boolean persist() {
            return true;
        }

        public boolean canRegister() {
            return true;
        }

        public String getAuthor() {
            return SimplePlugin.getInstance().getDescription().getAuthors().toString();
        }

        public String getIdentifier() {
            return SimplePlugin.getNamed().toLowerCase().replace("%", "").replace(" ", "").replace("_", "");
        }

        public String getVersion() {
            return SimplePlugin.getInstance().getDescription().getVersion();
        }

        public String onRequest(OfflinePlayer offlinePlayer, @NonNull String identifier) {
            Player player;
            if (identifier == null) {
                throw new NullPointerException("identifier is marked non-null but is null");
            }
            Player player2 = player = offlinePlayer != null ? offlinePlayer.getPlayer() : null;
            if (player == null || !player.isOnline()) {
                return null;
            }
            boolean frontSpace = identifier.startsWith("+");
            boolean backSpace = identifier.endsWith("+");
            identifier = frontSpace ? identifier.substring(1) : identifier;
            identifier = backSpace ? identifier.substring(0, identifier.length() - 1) : identifier;
            Function<CommandSender, String> variable = Variables.getVariable(identifier);
            try {
                Object value;
                if (variable != null && (value = variable.apply((CommandSender)player)) != null) {
                    return value;
                }
                for (SimpleExpansion expansion : Variables.getExpansions()) {
                    String value2 = expansion.replacePlaceholders((CommandSender)player, identifier);
                    if (value2 == null) continue;
                    boolean emptyColorless = Common.stripColors(value2).isEmpty();
                    return (!value2.isEmpty() && frontSpace && !emptyColorless ? " " : "") + value2 + (!value2.isEmpty() && backSpace && !emptyColorless ? " " : "");
                }
            }
            catch (Exception ex) {
                Common.error(ex, "Error replacing PlaceholderAPI variables", "Identifier: " + identifier, "Player: " + player.getName());
            }
            return null;
        }
    }
}

