/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.collection.SerializedMap;
import sk.adonikeoffice.epicchat.lib.exception.EventHandledException;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.exception.RegexTimeoutException;
import sk.adonikeoffice.epicchat.lib.model.HookManager;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.remain.Remain;

public abstract class PacketListener {
    public abstract void onRegister();

    protected void addPacketListener(SimpleAdapter adapter) {
        HookManager.addPacketListener((Object)adapter);
    }

    protected void addReceivingListener(PacketType type, Consumer<PacketEvent> consumer) {
        this.addReceivingListener(ListenerPriority.NORMAL, type, consumer);
    }

    protected void addReceivingListener(ListenerPriority priority, PacketType type, final Consumer<PacketEvent> consumer) {
        this.addPacketListener(new SimpleAdapter(priority, type){

            @Override
            public void onPacketReceiving(PacketEvent event) {
                if (event.getPlayer() != null) {
                    consumer.accept(event);
                }
            }
        });
    }

    protected void addSendingListener(PacketType type, Consumer<PacketEvent> consumer) {
        this.addSendingListener(ListenerPriority.NORMAL, type, consumer);
    }

    protected void addSendingListener(ListenerPriority priority, PacketType type, final Consumer<PacketEvent> consumer) {
        this.addPacketListener(new SimpleAdapter(priority, type){

            @Override
            public void onPacketSending(PacketEvent event) {
                if (event.getPlayer() != null) {
                    consumer.accept(event);
                }
            }
        });
    }

    protected List<WrappedGameProfile> compileHoverText(String ... hoverTexts) {
        ArrayList<WrappedGameProfile> profiles = new ArrayList<WrappedGameProfile>();
        int count = 0;
        for (String hoverText : hoverTexts) {
            WrappedGameProfile profile;
            try {
                profile = new WrappedGameProfile(UUID.randomUUID(), Common.colorize(hoverText));
            }
            catch (Throwable t) {
                profile = new WrappedGameProfile(String.valueOf(count++), Common.colorize(hoverText));
            }
            profiles.add(profile);
        }
        return profiles;
    }

    protected PacketListener() {
    }

    protected class SimpleAdapter
    extends PacketAdapter {
        private final PacketType type;

        public SimpleAdapter(PacketType type) {
            this(ListenerPriority.NORMAL, type);
        }

        public SimpleAdapter(ListenerPriority priority, PacketType type) {
            super((Plugin)SimplePlugin.getInstance(), priority, new PacketType[]{type});
            this.type = type;
        }

        public void onPacketReceiving(PacketEvent event) {
            throw new FoException("Override onPacketReceiving to handle receiving client>server packet type " + this.type);
        }

        public void onPacketSending(PacketEvent event) {
            throw new FoException("Override onPacketReceiving to handle sending server>client packet type " + this.type);
        }

        public PacketType getType() {
            return this.type;
        }
    }

    protected abstract class SimpleChatAdapter
    extends SimpleAdapter {
        private final Set<String> processedPlayers;
        private PacketEvent event;
        private Player player;
        private String jsonMessage;
        private boolean isBaseComponent;
        private boolean adventure;
        private final boolean systemChat;

        public SimpleChatAdapter() {
            super(ListenerPriority.HIGHEST, MinecraftVersion.atLeast(MinecraftVersion.V.v1_19) ? PacketType.Play.Server.SYSTEM_CHAT : PacketType.Play.Server.CHAT);
            this.processedPlayers = new HashSet<String>();
            this.isBaseComponent = false;
            this.adventure = false;
            this.systemChat = MinecraftVersion.atLeast(MinecraftVersion.V.v1_19);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void onPacketSending(PacketEvent event) {
            block15: {
                if (event.getPlayer() == null) {
                    return;
                }
                this.event = event;
                this.player = event.getPlayer();
                String playerName = event.getPlayer().getName();
                try {
                    this.player.getUniqueId();
                }
                catch (UnsupportedOperationException ex) {
                    return;
                }
                if (!this.player.isOnline() || SimplePlugin.isReloading()) {
                    return;
                }
                if (this.processedPlayers.contains(playerName)) {
                    return;
                }
                try {
                    String legacyText;
                    this.processedPlayers.add(playerName);
                    String parsedText = legacyText = this.compileChatMessage(event);
                    try {
                        parsedText = this.onMessage(parsedText);
                    }
                    catch (RegexTimeoutException ex) {
                        Common.logTimed(1800, "&cWarning: &fPacket message '" + Common.limit(this.jsonMessage, 500) + "' (possibly longer) took too long time to edit received message and was ignored. This message only shows once per 30 minutes when that happens. For most cases, this can be ignored.");
                        this.processedPlayers.remove(this.player.getName());
                        return;
                    }
                    catch (EventHandledException ex) {
                        event.setCancelled(true);
                        this.processedPlayers.remove(this.player.getName());
                        return;
                    }
                    if (this.jsonMessage != null && !this.jsonMessage.isEmpty()) {
                        this.onJsonMessage(this.jsonMessage);
                    }
                    if (!Common.stripColors(legacyText).equals(Common.stripColors(parsedText))) {
                        this.writeEditedMessage(parsedText, event);
                    }
                    break block15;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.processedPlayers.remove(this.player.getName());
                }
            }
        }

        private String compileChatMessage(PacketEvent event) {
            this.jsonMessage = null;
            if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_7)) {
                if (this.systemChat) {
                    this.jsonMessage = (String)event.getPacket().getStrings().read(0);
                } else {
                    StructureModifier packet = event.getPacket().getModifier();
                    StructureModifier chat = event.getPacket().getChatComponents();
                    WrappedChatComponent component = (WrappedChatComponent)chat.read(0);
                    try {
                        EnumWrappers.ChatType chatType = (EnumWrappers.ChatType)event.getPacket().getChatTypes().readSafely(0);
                        if (chatType == EnumWrappers.ChatType.GAME_INFO) {
                            return "";
                        }
                    }
                    catch (NoSuchMethodError chatType) {
                        // empty catch block
                    }
                    if (component != null) {
                        this.jsonMessage = component.getJson();
                    } else if (packet.size() > 1) {
                        Object secondField = packet.readSafely(1);
                        if (secondField == null && (secondField = packet.readSafely(2)) != null) {
                            this.adventure = true;
                        }
                        if (secondField instanceof BaseComponent[]) {
                            this.jsonMessage = Remain.toJson((BaseComponent[])secondField);
                            this.isBaseComponent = true;
                        }
                    }
                }
            } else {
                this.jsonMessage = (String)event.getPacket().getStrings().read(0);
            }
            if (this.jsonMessage != null && !this.jsonMessage.isEmpty() && this.jsonMessage.length() < 50000) {
                String legacyText;
                try {
                    legacyText = Remain.toLegacyText(this.jsonMessage, false);
                }
                catch (Throwable t) {
                    return "";
                }
                return legacyText;
            }
            return "";
        }

        private void writeEditedMessage(String message, PacketEvent event) {
            StructureModifier packet = event.getPacket().getModifier();
            this.jsonMessage = Remain.toJson(message);
            if (this.systemChat) {
                event.getPacket().getStrings().writeSafely(0, (Object)this.jsonMessage);
            } else if (this.isBaseComponent) {
                packet.writeSafely(this.adventure ? 2 : 1, (Object)Remain.toComponent(this.jsonMessage));
            } else if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_7)) {
                event.getPacket().getChatComponents().writeSafely(0, (Object)WrappedChatComponent.fromJson((String)this.jsonMessage));
            } else {
                event.getPacket().getStrings().writeSafely(0, (Object)SerializedMap.of("text", this.jsonMessage.substring(1, this.jsonMessage.length() - 1)).toJson());
            }
        }

        protected abstract String onMessage(String var1);

        protected void onJsonMessage(String jsonMessage) {
        }

        public PacketEvent getEvent() {
            return this.event;
        }

        public Player getPlayer() {
            return this.player;
        }
    }
}

