/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.event.RegionScanCompleteEvent;
import sk.adonikeoffice.epicchat.lib.model.LimitedQueue;
import sk.adonikeoffice.epicchat.lib.model.RegionAccessor;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.remain.Remain;

public abstract class OfflineRegionScanner {
    private static final String[] FOLDERS = new String[]{"region", "DIM-1/region", "DIM1/region"};
    private static final Pattern FILE_PATTERN = Pattern.compile("r\\.(.+)\\.(.+)\\.mca");
    private static int WAIT_TIME_BETWEEN_SCAN_SECONDS = 1;
    private int processedFilesCount = 0;
    private int totalFilesCount = 0;
    private World world;
    private Thread watchdog;
    private long lastTick = System.currentTimeMillis();
    private boolean fastMode = false;

    public final void scan(World world) {
        boolean hadAutoSave = world.isAutoSave();
        try {
            world.setAutoSave(false);
            this.scan0(world);
        }
        finally {
            world.setAutoSave(hadAutoSave);
        }
    }

    private void scan0(World world) {
        Common.log(Common.consoleLine(), "Scanning regions in " + world.getName(), Common.consoleLine());
        this.disableWatchdog();
        File[] files = OfflineRegionScanner.getRegionFiles(world);
        if (files == null || files.length == 0) {
            Common.warning("Unable to locate the region files for: " + world.getName());
            return;
        }
        LimitedQueue<File> queue = new LimitedQueue<File>(files.length + 1);
        queue.addAll(Arrays.asList(files));
        this.totalFilesCount = files.length;
        this.world = world;
        this.schedule0((Queue<File>)((Object)queue));
    }

    private void disableWatchdog() {
        Thread watchdog = null;
        try {
            Field instanceField = Class.forName("org.spigotmc.WatchdogThread").getDeclaredField("instance");
            try {
                instanceField.setAccessible(true);
                watchdog = (Thread)instanceField.get(null);
                watchdog.suspend();
                this.watchdog = watchdog;
            }
            catch (Throwable t) {
                Common.log("ERROR: FAILED TO DISABLE WATCHDOG, ABORTING! See below and report to us. NO DATA WERE MANIPULATED.");
                Common.callEvent(new RegionScanCompleteEvent(this.world));
                t.printStackTrace();
                this.finishScan();
                return;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }

    private void schedule0(final Queue<File> queue) {
        new BukkitRunnable(){

            public void run() {
                File file = (File)queue.poll();
                if (file == null) {
                    Common.log(Common.consoleLine(), "Region scanner finished. World saved.", Common.consoleLine());
                    Common.callEvent(new RegionScanCompleteEvent(OfflineRegionScanner.this.world));
                    OfflineRegionScanner.this.finishScan();
                    this.cancel();
                    return;
                }
                OfflineRegionScanner.this.scanFile(file, queue);
            }
        }.runTask((Plugin)SimplePlugin.getInstance());
    }

    private void scanFile(File file, Queue<File> queue) {
        Matcher matcher = FILE_PATTERN.matcher(file.getName());
        if (!matcher.matches()) {
            return;
        }
        int regionX = Integer.parseInt(matcher.group(1));
        int regionZ = Integer.parseInt(matcher.group(2));
        System.out.print("[" + Math.round((double)this.processedFilesCount++ / (double)this.totalFilesCount * 100.0) + "%] Processing " + file);
        if (System.currentTimeMillis() - this.lastTick > 4000L) {
            long free = Runtime.getRuntime().freeMemory() / 1000000L;
            if (free < 200L) {
                System.out.print(" [Low memory (" + free + "Mb)! Running GC and increasing delay between operations ..]");
                WAIT_TIME_BETWEEN_SCAN_SECONDS = 2;
                System.gc();
                Common.sleep(5000);
            } else {
                System.out.print(" [free memory = " + free + " mb]");
            }
            this.lastTick = System.currentTimeMillis();
        }
        System.out.println();
        Object region = RegionAccessor.getRegionFile(this.world.getName(), file);
        block4: for (int x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                int chunkX = x + (regionX << 5);
                int chunkZ = z + (regionZ << 5);
                if (!RegionAccessor.isChunkSaved(region, x, z)) continue;
                if (this.fastMode) {
                    this.onChunkScanFast(chunkX, chunkZ);
                    continue;
                }
                Chunk chunk = this.world.getChunkAt(chunkX, chunkZ);
                try {
                    this.onChunkScan(chunk);
                    continue;
                }
                catch (Throwable t) {
                    Common.error(t, "Failed to scan chunk " + chunk + ", aborting for safety");
                    break block4;
                }
            }
        }
        try {
            RegionAccessor.save(region);
        }
        catch (Throwable t) {
            Common.log("Failed to save region " + file + ", operation stopped.");
            Remain.sneaky(t);
        }
        if (this.fastMode) {
            this.schedule0(queue);
        } else {
            Common.runLater(WAIT_TIME_BETWEEN_SCAN_SECONDS, () -> this.schedule0(queue));
        }
    }

    protected abstract void onChunkScan(Chunk var1);

    protected void onChunkScanFast(int chunkX, int chunkZ) {
    }

    private void finishScan() {
        if (this.watchdog != null) {
            this.watchdog.resume();
        }
        this.onScanFinished();
    }

    protected void onScanFinished() {
    }

    public static File[] getRegionFiles(World world) {
        File regionDir = OfflineRegionScanner.getRegionDirectory(world);
        return regionDir == null ? null : regionDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".mca"));
    }

    private static final File getRegionDirectory(World world) {
        for (String folder : FOLDERS) {
            File file = new File(world.getWorldFolder(), folder);
            if (!file.isDirectory()) continue;
            return file;
        }
        return null;
    }

    public static int getEstimatedWaitTimeSec(World world) {
        File[] files = OfflineRegionScanner.getRegionFiles(world);
        return (int)(Math.round((double)WAIT_TIME_BETWEEN_SCAN_SECONDS * 1.5) * (long)files.length);
    }

    public World getWorld() {
        return this.world;
    }

    public void setFastMode(boolean fastMode) {
        this.fastMode = fastMode;
    }
}

