/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;

class MythicMobsHook {
    private Boolean legacyVersion = null;

    MythicMobsHook() {
        Plugin mythicMobs = Bukkit.getPluginManager().getPlugin("MythicMobs");
        String version = mythicMobs.getDescription().getVersion();
        if (version.startsWith("4.")) {
            this.legacyVersion = true;
        } else if (version.startsWith("5.")) {
            this.legacyVersion = false;
        } else {
            Common.warning("Skipping hooking into unsupported MythicMob version " + version + "! Only 4.X.X and 5.X.X are supported.");
        }
    }

    String getBossName(Entity entity) {
        if (this.legacyVersion == null) {
            return null;
        }
        if (this.legacyVersion.booleanValue()) {
            return this.getBossNameV4(entity);
        }
        return this.getBossNameV5(entity);
    }

    private String getBossNameV4(Entity entity) {
        try {
            Object mythicEntity;
            Object mob;
            Class mythicMobs = ReflectionUtil.lookupClass("io.lumine.xikage.mythicmobs.MythicMobs");
            Object instance = ReflectionUtil.invokeStatic(mythicMobs, "inst", new Object[0]);
            Object mobManager = ReflectionUtil.invoke("getMobManager", instance, new Object[0]);
            Optional activeMob = (Optional)ReflectionUtil.invoke(ReflectionUtil.getMethod(mobManager.getClass(), "getActiveMob", UUID.class), mobManager, entity.getUniqueId());
            Object v0 = mob = activeMob != null && activeMob.isPresent() ? activeMob.get() : null;
            if (mob != null && (mythicEntity = ReflectionUtil.invoke("getEntity", mob, new Object[0])) != null) {
                return (String)ReflectionUtil.invoke("getName", mythicEntity, new Object[0]);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return null;
    }

    private String getBossNameV5(Entity entity) {
        Object mythicPlugin = ReflectionUtil.invokeStatic(ReflectionUtil.lookupClass("io.lumine.mythic.api.MythicProvider"), "get", new Object[0]);
        Object mobManager = ReflectionUtil.invoke("getMobManager", mythicPlugin, new Object[0]);
        Collection activeMobs = (Collection)ReflectionUtil.invoke("getActiveMobs", mobManager, new Object[0]);
        for (Object mob : activeMobs) {
            UUID uniqueId = (UUID)ReflectionUtil.invoke("getUniqueId", mob, new Object[0]);
            if (!uniqueId.equals(entity.getUniqueId())) continue;
            return (String)ReflectionUtil.invoke("getName", mob, new Object[0]);
        }
        return null;
    }
}

