/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import com.gmail.nossr50.datatypes.chat.ChatChannel;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.util.player.UserManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import sk.adonikeoffice.epicchat.lib.Common;

class McMMOHook {
    private boolean errorLogged = false;

    McMMOHook() {
    }

    String getActivePartyChat(Player player) {
        block3: {
            try {
                McMMOPlayer mcplayer = UserManager.getPlayer((Player)player);
                if (mcplayer != null) {
                    Party party = mcplayer.getParty();
                    ChatChannel channelType = mcplayer.getChatChannel();
                    return channelType == ChatChannel.PARTY || channelType == ChatChannel.PARTY_OFFICER && party != null ? party.getName() : null;
                }
            }
            catch (Throwable throwable) {
                if (this.errorLogged) break block3;
                Common.warning("Failed getting mcMMO party chat for " + player.getName() + " due to error. Returning null. Ensure you have the latest mcMMO version, if so, contact plugin authors to update the integration. Error was: " + throwable);
                this.errorLogged = true;
            }
        }
        return null;
    }

    List<Player> getPartyRecipients(Player bukkitPlayer) {
        block3: {
            try {
                Party party;
                McMMOPlayer mcplayer = UserManager.getPlayer((Player)bukkitPlayer);
                if (mcplayer != null && (party = mcplayer.getParty()) != null) {
                    return party.getOnlineMembers();
                }
            }
            catch (Throwable throwable) {
                if (this.errorLogged) break block3;
                Common.warning("Failed getting mcMMO party recipients for " + bukkitPlayer.getName() + " due to error. Returning null. Ensure you have the latest mcMMO version, if so, contact plugin authors to update the integration. Error was: " + throwable);
                this.errorLogged = true;
            }
        }
        return new ArrayList<Player>();
    }
}

