/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import lombok.NonNull;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.collection.expiringmap.ExpiringMap;
import sk.adonikeoffice.epicchat.lib.exception.EventHandledException;
import sk.adonikeoffice.epicchat.lib.model.DiscordSender;
import sk.adonikeoffice.epicchat.lib.model.Variables;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.remain.Remain;

public final class JavaScriptExecutor {
    private static final ScriptEngine engine;
    private static final Map<UUID, Map<String, Object>> resultCache;

    public static Object run(String javascript) {
        return JavaScriptExecutor.run(javascript, null, null);
    }

    public static Object run(String javascript, CommandSender sender) {
        return JavaScriptExecutor.run(javascript, sender, null);
    }

    public static Object run(@NonNull String javascript, CommandSender sender, Event event) {
        Object result;
        Map<String, Object> cached;
        if (javascript == null) {
            throw new NullPointerException("javascript is marked non-null but is null");
        }
        String oldCode = new String(javascript);
        Map<String, Object> map = cached = sender instanceof Player ? resultCache.get(((Player)sender).getUniqueId()) : null;
        if (cached != null && (result = cached.get(javascript)) != null) {
            return result;
        }
        if (engine == null) {
            Common.warning("Not running script" + (sender == null ? "" : " for " + sender.getName()) + " because JavaScript library is missing (install Oracle Java 8, 11 or 16 and download mineacademy.org/nashorn): " + javascript);
            return null;
        }
        try {
            engine.getBindings(100).clear();
            if (sender != null) {
                engine.put("player", sender);
            }
            if (event != null) {
                engine.put("event", event);
            }
            if (sender instanceof DiscordSender) {
                javascript = JavaScriptExecutor.replaceVariables(javascript, Variables.VARIABLE_PATTERN.matcher(javascript));
                javascript = JavaScriptExecutor.replaceVariables(javascript, Variables.BRACKET_VARIABLE_PATTERN.matcher(javascript));
            }
            if ((result = engine.eval(javascript)) instanceof String) {
                String resultString = Common.stripColors((String)result).toLowerCase();
                if (resultString.equals("true") || resultString.equals("yes")) {
                    result = true;
                } else if (resultString.equals("false") || resultString.equals("no")) {
                    result = false;
                }
            }
            if (sender instanceof Player) {
                if (cached == null) {
                    cached = new HashMap<String, Object>();
                }
                cached.put(javascript, result);
                resultCache.put(((Player)sender).getUniqueId(), cached);
            }
            return result;
        }
        catch (Throwable ex) {
            String message = ex.toString();
            String error = "Script execution failed for";
            if (message.contains("ReferenceError:") && message.contains("is not defined")) {
                error = "Found invalid or unparsed variable in";
            }
            String cause = ex.getCause().toString();
            if (ex.getCause() != null && cause.contains("event handled")) {
                String[] errorMessageSplit;
                String[] stringArray = errorMessageSplit = cause.contains("event handled: ") ? cause.split("event handled\\: ") : new String[]{};
                if (errorMessageSplit.length == 2) {
                    Common.tellNoPrefix(sender, errorMessageSplit[1]);
                }
                throw new EventHandledException(true, new String[0]);
            }
            throw new RuntimeException(error + " '" + oldCode + "'", ex);
        }
    }

    private static String replaceVariables(String javascript, Matcher matcher) {
        while (matcher.find()) {
            javascript = javascript.replace(matcher.group(), "false");
        }
        return javascript;
    }

    public static Object run(String javascript, Map<String, Object> replacements) {
        if (engine == null) {
            Common.warning("Not running script because JavaScript library is missing (install Oracle Java 8, 11 or 16 and download mineacademy.org/nashorn): " + javascript);
            return javascript;
        }
        try {
            engine.getBindings(100).clear();
            if (replacements != null) {
                for (Map.Entry<String, Object> replacement : replacements.entrySet()) {
                    engine.put(replacement.getKey(), replacement.getValue());
                }
            }
            return engine.eval(javascript);
        }
        catch (ScriptException ex) {
            throw new RuntimeException("Script execution failed for '" + javascript + "'", ex);
        }
    }

    static {
        resultCache = ExpiringMap.builder().expiration(1L, TimeUnit.SECONDS).build();
        Thread.currentThread().setContextClassLoader(SimplePlugin.class.getClassLoader());
        ScriptEngineManager engineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = engineManager.getEngineByName("Nashorn");
        if (scriptEngine == null) {
            engineManager = new ScriptEngineManager(null);
            scriptEngine = engineManager.getEngineByName("Nashorn");
        }
        if (scriptEngine == null) {
            String nashorn = "org.openjdk.nashorn.api.scripting.NashornScriptEngineFactory";
            if (ReflectionUtil.isClassAvailable("org.openjdk.nashorn.api.scripting.NashornScriptEngineFactory")) {
                ScriptEngineFactory engineFactory = (ScriptEngineFactory)ReflectionUtil.instantiate(ReflectionUtil.lookupClass("org.openjdk.nashorn.api.scripting.NashornScriptEngineFactory"));
                engineManager.registerEngineName("Nashorn", engineFactory);
                scriptEngine = engineManager.getEngineByName("Nashorn");
            }
        }
        if ((engine = scriptEngine) == null) {
            List<String> warningMessage = Common.newList("ERROR: JavaScript placeholders will not function!", "", "Your Java version/distribution lacks the", "Nashorn library for JavaScript placeholders.");
            if (Remain.getJavaVersion() >= 15) {
                warningMessage.addAll(Arrays.asList("", "To fix this, install the NashornPlus", "plugin from mineacademy.org/nashorn"));
            } else {
                warningMessage.addAll(Arrays.asList("", "To fix this, install Java 11 from Oracle", "or other vendor that supports Nashorn."));
            }
            Common.logFramed(false, Common.toArray(warningMessage));
        }
    }
}

