/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.PlayerUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.debug.Debugger;
import sk.adonikeoffice.epicchat.lib.model.AdvancedVanishHook;
import sk.adonikeoffice.epicchat.lib.model.AuthMeHook;
import sk.adonikeoffice.epicchat.lib.model.BanManagerHook;
import sk.adonikeoffice.epicchat.lib.model.BentoBoxHook;
import sk.adonikeoffice.epicchat.lib.model.BossHook;
import sk.adonikeoffice.epicchat.lib.model.CMIHook;
import sk.adonikeoffice.epicchat.lib.model.CitizensHook;
import sk.adonikeoffice.epicchat.lib.model.DiscordSRVHook;
import sk.adonikeoffice.epicchat.lib.model.EssentialsHook;
import sk.adonikeoffice.epicchat.lib.model.FactionsHook;
import sk.adonikeoffice.epicchat.lib.model.FactionsMassive;
import sk.adonikeoffice.epicchat.lib.model.FactionsUUID;
import sk.adonikeoffice.epicchat.lib.model.ItemsAdderHook;
import sk.adonikeoffice.epicchat.lib.model.LWCHook;
import sk.adonikeoffice.epicchat.lib.model.LandsHook;
import sk.adonikeoffice.epicchat.lib.model.LiteBansHook;
import sk.adonikeoffice.epicchat.lib.model.LocketteProHook;
import sk.adonikeoffice.epicchat.lib.model.MVdWPlaceholderHook;
import sk.adonikeoffice.epicchat.lib.model.McMMOHook;
import sk.adonikeoffice.epicchat.lib.model.MultiverseHook;
import sk.adonikeoffice.epicchat.lib.model.MythicMobsHook;
import sk.adonikeoffice.epicchat.lib.model.NickyHook;
import sk.adonikeoffice.epicchat.lib.model.PlaceholderAPIHook;
import sk.adonikeoffice.epicchat.lib.model.PlotSquaredHook;
import sk.adonikeoffice.epicchat.lib.model.ProtocolLibHook;
import sk.adonikeoffice.epicchat.lib.model.ResidenceHook;
import sk.adonikeoffice.epicchat.lib.model.SimpleExpansion;
import sk.adonikeoffice.epicchat.lib.model.TownyHook;
import sk.adonikeoffice.epicchat.lib.model.Variables;
import sk.adonikeoffice.epicchat.lib.model.VaultHook;
import sk.adonikeoffice.epicchat.lib.model.WorldEditHook;
import sk.adonikeoffice.epicchat.lib.model.WorldGuardHook;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.region.Region;

public final class HookManager {
    private static AdvancedVanishHook advancedVanishHook;
    private static AuthMeHook authMeHook;
    private static BanManagerHook banManagerHook;
    private static BentoBoxHook bentoBoxHook;
    private static BossHook bossHook;
    private static CitizensHook citizensHook;
    private static CMIHook CMIHook;
    private static DiscordSRVHook discordSRVHook;
    private static EssentialsHook essentialsHook;
    private static FactionsHook factionsHook;
    private static ItemsAdderHook itemsAdderHook;
    private static LandsHook landsHook;
    private static LiteBansHook liteBansHook;
    private static LocketteProHook locketteProHook;
    private static LWCHook lwcHook;
    private static McMMOHook mcmmoHook;
    private static MultiverseHook multiverseHook;
    private static MVdWPlaceholderHook MVdWPlaceholderHook;
    private static MythicMobsHook mythicMobsHook;
    private static NickyHook nickyHook;
    private static PlaceholderAPIHook placeholderAPIHook;
    private static PlotSquaredHook plotSquaredHook;
    private static ProtocolLibHook protocolLibHook;
    private static ResidenceHook residenceHook;
    private static TownyHook townyHook;
    private static VaultHook vaultHook;
    private static WorldEditHook worldeditHook;
    private static WorldGuardHook worldguardHook;
    private static boolean nbtAPIDummyHook;
    private static boolean nuVotifierDummyHook;
    private static boolean townyChatDummyHook;

    public static void loadDependencies() {
        String ver;
        if (Common.doesPluginExist("AdvancedVanish")) {
            advancedVanishHook = new AdvancedVanishHook();
        }
        if (Common.doesPluginExist("AuthMe")) {
            authMeHook = new AuthMeHook();
        }
        if (Common.doesPluginExist("BanManager")) {
            banManagerHook = new BanManagerHook();
        }
        if (Common.doesPluginExist("BentoBox")) {
            bentoBoxHook = new BentoBoxHook();
        }
        if (Common.doesPluginExist("Boss")) {
            bossHook = new BossHook();
        }
        if (Common.doesPluginExist("Citizens")) {
            citizensHook = new CitizensHook();
        }
        if (Common.doesPluginExist("CMI")) {
            CMIHook = new CMIHook();
        }
        if (Common.doesPluginExist("DiscordSRV")) {
            try {
                Class.forName("github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel");
                discordSRVHook = new DiscordSRVHook();
            }
            catch (ClassNotFoundException ex) {
                Common.error(ex, "&c" + SimplePlugin.getNamed() + " failed to hook DiscordSRV because the plugin is outdated (1.18.x is supported)!");
            }
        }
        if (Common.doesPluginExist("Essentials")) {
            essentialsHook = new EssentialsHook();
        }
        Plugin factions = Bukkit.getPluginManager().getPlugin("Factions");
        if (Common.doesPluginExist("FactionsX") && factions == null) {
            Common.log("Note: If you want FactionX integration, install FactionsUUIDAPIProxy.");
        } else if (factions != null) {
            ver = factions.getDescription().getVersion();
            String main = factions.getDescription().getMain();
            if (ver.startsWith("1.6") || main.contains("FactionsUUIDAPIProxy")) {
                factionsHook = new FactionsUUID();
            } else if (ver.startsWith("2.")) {
                Class<?> mplayer = null;
                try {
                    mplayer = Class.forName("com.massivecraft.factions.entity.MPlayer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (mplayer != null) {
                    factionsHook = new FactionsMassive();
                } else {
                    Common.warning("Recognized MCore Factions, but not hooked! Check if you have the latest version!");
                }
            }
        }
        if (Common.doesPluginExist("ItemsAdder")) {
            itemsAdderHook = new ItemsAdderHook();
        }
        if (Common.doesPluginExist("Lands")) {
            landsHook = new LandsHook();
        }
        if (Common.doesPluginExist("LiteBans")) {
            liteBansHook = new LiteBansHook();
        }
        if (Common.doesPluginExist("Lockette")) {
            locketteProHook = new LocketteProHook();
        }
        if (Common.doesPluginExist("LWC")) {
            lwcHook = new LWCHook();
        }
        if (Common.doesPluginExist("mcMMO")) {
            ver = Bukkit.getPluginManager().getPlugin("mcMMO").getDescription().getVersion();
            if (ver.startsWith("2.")) {
                mcmmoHook = new McMMOHook();
            } else {
                Common.warning("Could not hook into mcMMO, version 2.x required, you have " + ver);
            }
        }
        if (Common.doesPluginExist("Multiverse-Core")) {
            multiverseHook = new MultiverseHook();
        }
        if (Common.doesPluginExist("MVdWPlaceholderAPI")) {
            MVdWPlaceholderHook = new MVdWPlaceholderHook();
        }
        if (Common.doesPluginExist("MythicMobs")) {
            mythicMobsHook = new MythicMobsHook();
        }
        if (Common.doesPluginExist("Nicky")) {
            nickyHook = new NickyHook();
        }
        if (Common.doesPluginExist("PlaceholderAPI")) {
            placeholderAPIHook = new PlaceholderAPIHook();
        }
        if (Common.doesPluginExist("PlotSquared")) {
            ver = Bukkit.getPluginManager().getPlugin("PlotSquared").getDescription().getVersion();
            if (ver.startsWith("6.") || ver.startsWith("5.") || ver.startsWith("3.")) {
                plotSquaredHook = new PlotSquaredHook();
            } else {
                Common.warning("Could not hook into PlotSquared, version 3.x, 5.x or 6.x required, you have " + ver);
            }
        }
        if (Common.doesPluginExist("ProtocolLib")) {
            protocolLibHook = new ProtocolLibHook();
            try {
                if (MinecraftVersion.newerThan(MinecraftVersion.V.v1_6)) {
                    Class.forName("com.comphenix.protocol.wrappers.WrappedChatComponent");
                }
            }
            catch (Throwable t) {
                protocolLibHook = null;
                Common.throwError(t, "You are running an old and unsupported version of ProtocolLib, please update it.");
            }
        }
        if (Common.doesPluginExist("Residence")) {
            residenceHook = new ResidenceHook();
        }
        if (Common.doesPluginExist("Towny")) {
            townyHook = new TownyHook();
        }
        if (Common.doesPluginExist("Vault")) {
            vaultHook = new VaultHook();
        }
        if (Common.doesPluginExist("WorldEdit") || Common.doesPluginExist("FastAsyncWorldEdit")) {
            worldeditHook = new WorldEditHook();
        }
        if (Common.doesPluginExist("WorldGuard")) {
            worldguardHook = new WorldGuardHook(worldeditHook);
        }
        if (Common.doesPluginExist("NBTAPI")) {
            nbtAPIDummyHook = true;
        }
        if (Common.doesPluginExist("Votifier")) {
            nuVotifierDummyHook = true;
        }
        if (Common.doesPluginExist("TownyChat")) {
            townyChatDummyHook = true;
        }
    }

    @Deprecated
    public static void unloadDependencies(Plugin plugin) {
        if (HookManager.isProtocolLibLoaded()) {
            protocolLibHook.removePacketListeners(plugin);
        }
        if (HookManager.isPlaceholderAPILoaded()) {
            placeholderAPIHook.unregister();
        }
    }

    public static boolean isAdvancedVanishLoaded() {
        return advancedVanishHook != null;
    }

    public static boolean isAuthMeLoaded() {
        return authMeHook != null;
    }

    public static boolean isBanManagerLoaded() {
        return banManagerHook != null;
    }

    public static boolean isBentoBoxLoaded() {
        return bentoBoxHook != null;
    }

    public static boolean isBossLoaded() {
        return bossHook != null;
    }

    public static boolean isCMILoaded() {
        return CMIHook != null;
    }

    public static boolean isCitizensLoaded() {
        return citizensHook != null;
    }

    public static boolean isDiscordSRVLoaded() {
        return discordSRVHook != null;
    }

    public static boolean isEssentialsLoaded() {
        return essentialsHook != null;
    }

    public static boolean isFactionsLoaded() {
        return factionsHook != null;
    }

    public static boolean isFAWELoaded() {
        Plugin fawe = Bukkit.getPluginManager().getPlugin("FastAsyncWorldEdit");
        if (fawe != null && fawe.isEnabled()) {
            return true;
        }
        Plugin worldEdit = Bukkit.getPluginManager().getPlugin("WorldEdit");
        return worldEdit != null && worldEdit.isEnabled() && "Fast Async WorldEdit plugin".equals(worldEdit.getDescription().getDescription());
    }

    public static boolean isItemsAdderLoaded() {
        return itemsAdderHook != null;
    }

    public static boolean isLandsLoaded() {
        return landsHook != null;
    }

    public static boolean isLiteBansLoaded() {
        return liteBansHook != null;
    }

    public static boolean isLocketteProLoaded() {
        return locketteProHook != null;
    }

    public static boolean isLWCLoaded() {
        return lwcHook != null;
    }

    public static boolean isMcMMOLoaded() {
        return mcmmoHook != null;
    }

    public static boolean isMultiverseCoreLoaded() {
        return multiverseHook != null;
    }

    public static boolean isMVdWPlaceholderAPILoaded() {
        return MVdWPlaceholderHook != null;
    }

    public static boolean isMythicMobsLoaded() {
        return mythicMobsHook != null;
    }

    public static boolean isNbtAPILoaded() {
        return nbtAPIDummyHook;
    }

    public static boolean isNickyLoaded() {
        return nickyHook != null;
    }

    public static boolean isNuVotifierLoaded() {
        return nuVotifierDummyHook;
    }

    public static boolean isPlaceholderAPILoaded() {
        return placeholderAPIHook != null;
    }

    public static boolean isPlotSquaredLoaded() {
        return plotSquaredHook != null;
    }

    public static boolean isProtocolLibLoaded() {
        return protocolLibHook != null;
    }

    public static boolean isResidenceLoaded() {
        return residenceHook != null;
    }

    public static boolean isTownyLoaded() {
        return townyHook != null;
    }

    public static boolean isTownyChatLoaded() {
        return townyHook != null && townyChatDummyHook;
    }

    public static boolean isVaultLoaded() {
        return vaultHook != null;
    }

    public static boolean isWorldEditLoaded() {
        return worldeditHook != null || HookManager.isFAWELoaded();
    }

    public static boolean isWorldGuardLoaded() {
        return worldguardHook != null;
    }

    public static boolean isLogged(Player player) {
        return !HookManager.isAuthMeLoaded() || authMeHook.isLogged(player);
    }

    public static String getBossName(Entity entity) {
        return HookManager.isBossLoaded() ? bossHook.getBossName(entity) : null;
    }

    public static String getMythicMobName(Entity entity) {
        return HookManager.isMythicMobsLoaded() ? mythicMobsHook.getBossName(entity) : null;
    }

    public static Set<UUID> getBentoBoxVisitors(Location islandLocation) {
        return HookManager.isBentoBoxLoaded() ? bentoBoxHook.getIslandVisitors(islandLocation) : new HashSet();
    }

    public static Set<UUID> getBentoBoxCoops(Location islandLocation) {
        return HookManager.isBentoBoxLoaded() ? bentoBoxHook.getIslandCoops(islandLocation) : new HashSet();
    }

    public static Set<UUID> getBentoBoxTrustees(Location islandLocation) {
        return HookManager.isBentoBoxLoaded() ? bentoBoxHook.getIslandTrustees(islandLocation) : new HashSet();
    }

    public static Set<UUID> getBentoBoxMembers(Location islandLocation) {
        return HookManager.isBentoBoxLoaded() ? bentoBoxHook.getIslandMembers(islandLocation) : new HashSet();
    }

    public static Set<UUID> getBentoBoxSubOwners(Location islandLocation) {
        return HookManager.isBentoBoxLoaded() ? bentoBoxHook.getIslandSubOwners(islandLocation) : new HashSet();
    }

    public static Set<UUID> getBentoBoxOwners(Location islandLocation) {
        return HookManager.isBentoBoxLoaded() ? bentoBoxHook.getIslandOwners(islandLocation) : new HashSet();
    }

    public static Set<UUID> getBentoBoxMods(Location islandLocation) {
        return HookManager.isBentoBoxLoaded() ? bentoBoxHook.getIslandMods(islandLocation) : new HashSet();
    }

    public static Set<UUID> getBentoBoxAdmins(Location islandLocation, int rank) {
        return HookManager.isBentoBoxLoaded() ? bentoBoxHook.getIslandAdmins(islandLocation) : new HashSet();
    }

    public static Collection<Player> getLandPlayers(Player player) {
        return HookManager.isLandsLoaded() ? landsHook.getLandPlayers(player) : new ArrayList();
    }

    public static boolean isAfk(Player player) {
        boolean essAFK = HookManager.isEssentialsLoaded() && essentialsHook.isAfk(player.getName());
        boolean cmiAFK = HookManager.isCMILoaded() && CMIHook.isAfk(player);
        return essAFK || cmiAFK;
    }

    @Deprecated
    public static boolean isVanishedEssentials(Player player) {
        return HookManager.isEssentialsLoaded() && essentialsHook.isVanished(player.getName());
    }

    @Deprecated
    public static boolean isVanishedCMI(Player player) {
        return HookManager.isCMILoaded() && CMIHook.isVanished(player);
    }

    @Deprecated
    public static boolean isVanishedAdvancedVanish(Player player) {
        return HookManager.isAdvancedVanishLoaded() && advancedVanishHook.isVanished(player);
    }

    @Deprecated
    public static void setVanished(@NonNull Player player, boolean vanished) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (HookManager.isEssentialsLoaded()) {
            essentialsHook.setVanished(player.getName(), vanished);
        }
        if (HookManager.isCMILoaded()) {
            CMIHook.setVanished(player, vanished);
        }
        if (HookManager.isAdvancedVanishLoaded()) {
            advancedVanishHook.setVanished(player, vanished);
        }
    }

    public static boolean isMuted(Player player) {
        if (HookManager.isEssentialsLoaded() && essentialsHook.isMuted(player.getName())) {
            return true;
        }
        if (HookManager.isCMILoaded() && CMIHook.isMuted(player)) {
            return true;
        }
        if (HookManager.isBanManagerLoaded() && banManagerHook.isMuted(player)) {
            return true;
        }
        return HookManager.isLiteBansLoaded() && liteBansHook.isMuted(player);
    }

    public static void setLiteBansMute(String targetPlayerName, String durationTokenized, String reason) {
        if (HookManager.isLiteBansLoaded()) {
            Common.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), "lmute " + targetPlayerName + " " + durationTokenized + (reason == null || reason.isEmpty() ? "" : " " + reason));
        }
    }

    public static void setLiteBansUnmute(String targetPlayerName) {
        if (HookManager.isLiteBansLoaded()) {
            Common.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), "lunmute " + targetPlayerName);
        }
    }

    public static boolean hasGodMode(Player player) {
        boolean essGodMode = HookManager.isEssentialsLoaded() && essentialsHook.hasGodMode(player);
        boolean cmiGodMode = HookManager.isCMILoaded() && CMIHook.hasGodMode(player);
        return essGodMode || cmiGodMode;
    }

    public static void setGodMode(Player player, boolean godMode) {
        if (HookManager.isEssentialsLoaded()) {
            essentialsHook.setGodMode(player, godMode);
        }
        if (HookManager.isCMILoaded()) {
            CMIHook.setGodMode(player, godMode);
        }
    }

    public static void setBackLocation(Player player, Location location) {
        if (HookManager.isEssentialsLoaded()) {
            essentialsHook.setBackLocation(player.getName(), location);
        }
        if (HookManager.isCMILoaded()) {
            CMIHook.setLastTeleportLocation(player, location);
        }
    }

    public static void setIgnore(UUID player, UUID who, boolean ignore) {
        if (HookManager.isEssentialsLoaded()) {
            essentialsHook.setIgnore(player, who, ignore);
        }
        if (HookManager.isCMILoaded()) {
            CMIHook.setIgnore(player, who, ignore);
        }
    }

    public static boolean isIgnoring(UUID player, UUID who) {
        Valid.checkBoolean(player != null, "Player to check ignore from cannot be null/empty", new Object[0]);
        Valid.checkBoolean(who != null, "Player to check ignore to cannot be null/empty", new Object[0]);
        return HookManager.isEssentialsLoaded() ? essentialsHook.isIgnoring(player, who) : (HookManager.isCMILoaded() ? CMIHook.isIgnoring(player, who) : false);
    }

    public static String getNickColored(CommandSender sender) {
        return HookManager.getNick(sender, false);
    }

    public static String getNickColorless(CommandSender sender) {
        return HookManager.getNick(sender, true);
    }

    private static String getNick(CommandSender sender, boolean stripColors) {
        String cmiNick;
        Player player;
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (player != null && HookManager.isNPC((Entity)player)) {
            Common.log("&eWarn: Called getNick for NPC " + player.getName() + "! Notify the developers to add an ignore check at " + Debugger.traceRoute(true));
            return player.getName();
        }
        if (player == null) {
            return sender.getName();
        }
        String nickyNick = HookManager.isNickyLoaded() ? nickyHook.getNick(player) : null;
        String essNick = HookManager.isEssentialsLoaded() ? essentialsHook.getNick(player.getName()) : null;
        String string = cmiNick = HookManager.isCMILoaded() ? CMIHook.getNick(player) : null;
        String nick = nickyNick != null ? nickyNick : (cmiNick != null ? cmiNick : (essNick != null ? essNick : sender.getName()));
        return stripColors ? Common.stripColors(Common.revertColorizing(nick).replace("\u00a7x", "")) : nick;
    }

    public static String getNickFromName(String playerName) {
        String cmiNick;
        String essNick = HookManager.isEssentialsLoaded() ? essentialsHook.getNick(playerName) : null;
        String string = cmiNick = HookManager.isCMILoaded() ? CMIHook.getNick(playerName) : null;
        return cmiNick != null ? cmiNick : (essNick != null ? essNick : playerName);
    }

    public static void setNick(@NonNull UUID playerId, @Nullable String nick) {
        if (playerId == null) {
            throw new NullPointerException("playerId is marked non-null but is null");
        }
        if (HookManager.isEssentialsLoaded()) {
            essentialsHook.setNick(playerId, nick);
        }
        if (HookManager.isCMILoaded()) {
            CMIHook.setNick(playerId, nick);
        }
    }

    public static String getNameFromNick(@NonNull String nick) {
        String cmiNick;
        if (nick == null) {
            throw new NullPointerException("nick is marked non-null but is null");
        }
        String essNick = HookManager.isEssentialsLoaded() ? essentialsHook.getNameFromNick(nick) : nick;
        String string = cmiNick = HookManager.isCMILoaded() ? CMIHook.getNameFromNick(nick) : nick;
        return !essNick.equals(nick) && !"".equals(essNick) ? essNick : (!cmiNick.equals(nick) && !"".equals(cmiNick) ? cmiNick : nick);
    }

    public static Player getReplyTo(Player player) {
        return HookManager.isEssentialsLoaded() ? essentialsHook.getReplyTo(player.getName()) : null;
    }

    public static String replaceFontImages(String message) {
        return HookManager.replaceFontImages(null, message);
    }

    public static String replaceFontImages(@Nullable Player player, String message) {
        return HookManager.isItemsAdderLoaded() ? itemsAdderHook.replaceFontImages(player, message) : message;
    }

    public static String getWorldAlias(World world) {
        return HookManager.isMultiverseCoreLoaded() ? multiverseHook.getWorldAlias(world.getName()) : world.getName();
    }

    public static String getNation(Player player) {
        return HookManager.isTownyLoaded() ? townyHook.getNationName(player) : null;
    }

    public static String getTownName(Player player) {
        return HookManager.isTownyLoaded() ? townyHook.getTownName(player) : null;
    }

    public static Collection<? extends Player> getTownResidentsOnline(Player player) {
        return HookManager.isTownyLoaded() ? townyHook.getTownResidentsOnline(player) : new ArrayList();
    }

    public static Collection<? extends Player> getNationPlayersOnline(Player player) {
        return HookManager.isTownyLoaded() ? townyHook.getNationPlayersOnline(player) : new ArrayList();
    }

    public static Collection<? extends Player> getAllyPlayersOnline(Player player) {
        return HookManager.isTownyLoaded() ? townyHook.getAllyPlayersOnline(player) : new ArrayList();
    }

    public static String getTownOwner(Location location) {
        return HookManager.isTownyLoaded() ? townyHook.getTownOwner(location) : null;
    }

    public static String getTown(Location location) {
        return HookManager.isTownyLoaded() ? townyHook.getTownName(location) : null;
    }

    public static List<String> getTowns() {
        return HookManager.isTownyLoaded() ? townyHook.getTowns() : new ArrayList<String>();
    }

    public static String getPlayerPrefix(Player player) {
        return HookManager.isVaultLoaded() ? vaultHook.getPlayerPrefix(player) : "";
    }

    public static String getPlayerSuffix(Player player) {
        return HookManager.isVaultLoaded() ? vaultHook.getPlayerSuffix(player) : "";
    }

    public static String getPlayerPermissionGroup(Player player) {
        return HookManager.isVaultLoaded() ? vaultHook.getPlayerGroup(player) : "";
    }

    public static double getBalance(Player player) {
        return HookManager.isVaultLoaded() ? vaultHook.getBalance(player) : 0.0;
    }

    public static String getCurrencySingular() {
        return HookManager.isVaultLoaded() ? vaultHook.getCurrencyNameSG() : null;
    }

    public static String getCurrencyPlural() {
        return HookManager.isVaultLoaded() ? vaultHook.getCurrencyNamePL() : null;
    }

    public static void withdraw(Player player, double amount) {
        if (HookManager.isVaultLoaded()) {
            vaultHook.withdraw(player, amount);
        }
    }

    public static void deposit(Player player, double amount) {
        if (HookManager.isVaultLoaded()) {
            vaultHook.deposit(player, amount);
        }
    }

    public static boolean hasProtocolLibPermission(Player player, String perm) {
        if (HookManager.isProtocolLibLoaded() && protocolLibHook.isTemporaryPlayer(player)) {
            return HookManager.hasVaultPermission((OfflinePlayer)player, perm);
        }
        return PlayerUtil.hasPerm((Permissible)player, perm);
    }

    public static boolean hasVaultPermission(OfflinePlayer offlinePlayer, String perm) {
        Valid.checkBoolean(HookManager.isVaultLoaded(), "hasVaultPermission called - Please install Vault to enable this functionality!", new Object[0]);
        return vaultHook.hasPerm(offlinePlayer, perm);
    }

    public static String getPlayerPrimaryGroup(Player player) {
        return HookManager.isVaultLoaded() ? vaultHook.getPrimaryGroup(player) : "";
    }

    public static boolean isChatIntegrated() {
        return HookManager.isVaultLoaded() ? vaultHook.isChatIntegrated() : false;
    }

    public static boolean isEconomyIntegrated() {
        return HookManager.isVaultLoaded() ? vaultHook.isEconomyIntegrated() : false;
    }

    @Deprecated
    public static void updateVaultIntegration() {
        if (HookManager.isVaultLoaded()) {
            vaultHook.setIntegration();
        }
    }

    public static String replacePlaceholders(@Nullable OfflinePlayer player, String message) {
        if (message == null || "".equals(message.trim())) {
            return message;
        }
        message = HookManager.isPlaceholderAPILoaded() ? placeholderAPIHook.replacePlaceholders(player, message) : message;
        message = HookManager.isMVdWPlaceholderAPILoaded() ? MVdWPlaceholderHook.replacePlaceholders(player, message) : message;
        return message;
    }

    public static String replaceRelationPlaceholders(Player one, Player two, String message) {
        if (message == null || "".equals(message.trim())) {
            return message;
        }
        return HookManager.isPlaceholderAPILoaded() ? placeholderAPIHook.replaceRelationPlaceholders(one, two, message) : message;
    }

    public static void addPlaceholder(final String variable, final Function<Player, String> value) {
        Variables.addExpansion(new SimpleExpansion(){

            @Override
            protected String onReplace(@NonNull CommandSender sender, String identifier) {
                if (sender == null) {
                    throw new NullPointerException("sender is marked non-null but is null");
                }
                return variable.equalsIgnoreCase(identifier) && sender instanceof Player ? (String)value.apply((Player)sender) : null;
            }
        });
    }

    public static Collection<String> getFactions() {
        return HookManager.isFactionsLoaded() ? factionsHook.getFactions() : null;
    }

    public static String getFaction(Player player) {
        return HookManager.isFactionsLoaded() ? factionsHook.getFaction(player) : null;
    }

    public static Collection<? extends Player> getOnlineFactionPlayers(Player player) {
        return HookManager.isFactionsLoaded() ? factionsHook.getSameFactionPlayers(player) : new ArrayList();
    }

    public static String getFaction(Location location) {
        return HookManager.isFactionsLoaded() ? factionsHook.getFaction(location) : null;
    }

    public static String getFactionOwner(Location location) {
        return HookManager.isFactionsLoaded() ? factionsHook.getFactionOwner(location) : null;
    }

    public static void addPacketListener(Object adapter) {
        Valid.checkBoolean(HookManager.isProtocolLibLoaded(), "Cannot add packet listeners if ProtocolLib isn't installed", new Object[0]);
        protocolLibHook.addPacketListener(adapter);
    }

    public static void sendPacket(Player player, Object packetContainer) {
        Valid.checkBoolean(HookManager.isProtocolLibLoaded(), "Sending packets requires ProtocolLib installed and loaded", new Object[0]);
        protocolLibHook.sendPacket(player, packetContainer);
    }

    public static String getLWCOwner(Block block) {
        return HookManager.isLWCLoaded() ? lwcHook.getOwner(block) : null;
    }

    public static boolean isLocketteOwner(Block block, Player player) {
        return HookManager.isLocketteProLoaded() ? locketteProHook.isOwner(block, player) : false;
    }

    public static Collection<String> getResidences() {
        return HookManager.isResidenceLoaded() ? residenceHook.getResidences() : new ArrayList<String>();
    }

    public static String getResidence(Location location) {
        return HookManager.isResidenceLoaded() ? residenceHook.getResidence(location) : null;
    }

    public static String getResidenceOwner(Location location) {
        return HookManager.isResidenceLoaded() ? residenceHook.getResidenceOwner(location) : null;
    }

    public static List<String> getRegions(Location loc) {
        return HookManager.isWorldGuardLoaded() ? worldguardHook.getRegionsAt(loc) : new ArrayList();
    }

    public static List<String> getRegions() {
        return HookManager.isWorldGuardLoaded() ? worldguardHook.getAllRegions() : new ArrayList<String>();
    }

    public static Region getRegion(String name) {
        return HookManager.isWorldGuardLoaded() ? worldguardHook.getRegion(name) : null;
    }

    public static Collection<? extends Player> getPlotPlayers(Player players) {
        return HookManager.isPlotSquaredLoaded() ? plotSquaredHook.getPlotPlayers(players) : new ArrayList();
    }

    public static String getActivePartyChat(Player player) {
        return HookManager.isMcMMOLoaded() ? mcmmoHook.getActivePartyChat(player) : null;
    }

    public static List<Player> getMcMMOPartyRecipients(Player player) {
        return HookManager.isMcMMOLoaded() ? mcmmoHook.getPartyRecipients(player) : new ArrayList();
    }

    public static boolean isNPC(Entity entity) {
        return HookManager.isCitizensLoaded() ? citizensHook.isNPC(entity) : false;
    }

    public static Entity getNPCTarget(Entity entity) {
        return HookManager.isCitizensLoaded() ? citizensHook.getNPCTarget(entity) : null;
    }

    public static Set<String> getDiscordChannels() {
        return HookManager.isDiscordSRVLoaded() ? discordSRVHook.getChannels() : new HashSet<String>();
    }

    public static void sendDiscordMessage(CommandSender sender, String channel, @NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (HookManager.isDiscordSRVLoaded() && !Common.stripColors(message).isEmpty()) {
            discordSRVHook.sendMessage(sender, channel, message);
        }
    }

    public static void sendDiscordMessage(String channel, @NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (HookManager.isDiscordSRVLoaded() && !Common.stripColors(message).isEmpty()) {
            discordSRVHook.sendMessage(channel, message);
        }
    }

    private HookManager() {
    }

    static {
        nbtAPIDummyHook = false;
        nuVotifierDummyHook = false;
        townyChatDummyHook = false;
    }
}

