/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.scheduler.BukkitTask;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.debug.Debugger;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;

public abstract class FolderWatcher
extends Thread {
    private static volatile Set<FolderWatcher> activeThreads = new HashSet<FolderWatcher>();
    private final Map<String, BukkitTask> scheduledUpdates = new HashMap<String, BukkitTask>();
    private final Path folder;
    private boolean watching = true;

    public static void stopThreads() {
        for (FolderWatcher thread : activeThreads) {
            thread.stopWatching();
        }
        activeThreads.clear();
    }

    public FolderWatcher(File folder) {
        Valid.checkBoolean(folder.exists(), folder + " does not exists!", new Object[0]);
        Valid.checkBoolean(folder.isDirectory(), folder + " must be a directory!", new Object[0]);
        this.folder = folder.toPath();
        this.start();
        for (FolderWatcher other : activeThreads) {
            if (!other.folder.toString().equals(this.folder.toString())) continue;
            Common.warning("A duplicate file watcher for '" + folder.getPath() + "' was added. This is untested and may causes fatal issues!");
        }
        activeThreads.add(this);
        Debugger.debug("upload", "Started folder watcher for " + folder + " in " + folder.getAbsolutePath() + " (path: " + this.folder + ")");
    }

    @Override
    public final void run() {
        FileSystem fileSystem = this.folder.getFileSystem();
        try (WatchService service = fileSystem.newWatchService();){
            WatchKey registration = this.folder.register(service, StandardWatchEventKinds.ENTRY_MODIFY);
            while (this.watching) {
                try {
                    WatchKey watchKey = service.take();
                    for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
                        WatchEvent.Kind<?> kind = watchEvent.kind();
                        if (kind != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                        Path watchEventPath = (Path)watchEvent.context();
                        File fileModified = new File(SimplePlugin.getData(), watchEventPath.toFile().getName());
                        String path = fileModified.getAbsolutePath();
                        BukkitTask pendingTask = this.scheduledUpdates.remove(path);
                        if (pendingTask != null) {
                            pendingTask.cancel();
                        }
                        this.scheduledUpdates.put(path, Common.runLater(10, () -> {
                            if (!this.watching) {
                                return;
                            }
                            try {
                                this.onModified(fileModified);
                                this.scheduledUpdates.remove(path);
                            }
                            catch (Throwable t) {
                                Common.error(t, "Error in calling onModified when watching changed file " + fileModified);
                            }
                        }));
                        break;
                    }
                    if (watchKey.reset()) continue;
                    Common.error(new FoException("Failed to reset watch key! Restarting sync engine.."), new String[0]);
                }
                catch (Throwable t) {
                    Common.error(t, "Error in handling watching thread loop for folder " + this.getFolder());
                }
            }
            registration.cancel();
        }
        catch (Throwable t) {
            Common.error(t, "Error in initializing watching thread loop for folder " + this.getFolder());
        }
    }

    protected abstract void onModified(File var1);

    public void stopWatching() {
        Valid.checkBoolean(this.watching, "The folder watcher for folder " + this.folder + " is no longer watching!", new Object[0]);
        this.watching = false;
        for (BukkitTask task : this.scheduledUpdates.values()) {
            try {
                task.cancel();
            }
            catch (Exception exception) {}
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof FolderWatcher && ((FolderWatcher)obj).folder.toString().equals(this.folder.toString());
    }

    protected Map<String, BukkitTask> getScheduledUpdates() {
        return this.scheduledUpdates;
    }

    protected Path getFolder() {
        return this.folder;
    }

    public boolean isWatching() {
        return this.watching;
    }
}

