/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.IUser;
import com.earth2me.essentials.User;
import com.earth2me.essentials.UserMap;
import java.lang.reflect.Method;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.Valid;

class EssentialsHook {
    private final Essentials ess = (Essentials)Bukkit.getPluginManager().getPlugin("Essentials");

    EssentialsHook() {
    }

    boolean hasGodMode(Player player) {
        User user = this.getUser(player.getName());
        return user != null ? user.isGodModeEnabled() : false;
    }

    void setGodMode(Player player, boolean godMode) {
        User user = this.getUser(player.getName());
        if (user != null) {
            user.setGodModeEnabled(godMode);
        }
    }

    void setIgnore(UUID player, UUID toIgnore, boolean ignore) {
        try {
            User user = this.ess.getUser(player);
            User toIgnoreUser = this.ess.getUser(toIgnore);
            if (toIgnoreUser != null) {
                user.setIgnoredPlayer((IUser)toIgnoreUser, ignore);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    boolean isIgnoring(UUID player, UUID ignoringPlayer) {
        try {
            User user = this.ess.getUser(player);
            User ignored = this.ess.getUser(ignoringPlayer);
            return user != null && ignored != null && user.isIgnoredPlayer((IUser)ignored);
        }
        catch (Throwable t) {
            return false;
        }
    }

    boolean isAfk(String pl) {
        User user = this.getUser(pl);
        return user != null ? user.isAfk() : false;
    }

    boolean isVanished(String pl) {
        User user = this.getUser(pl);
        return user != null ? user.isVanished() : false;
    }

    void setVanished(String playerName, boolean vanished) {
        User user = this.getUser(playerName);
        if (user != null && user.isVanished() != vanished) {
            user.setVanished(false);
        }
    }

    boolean isMuted(String pl) {
        User user = this.getUser(pl);
        return user != null ? user.isMuted() : false;
    }

    Player getReplyTo(String recipient) {
        Player bukkitPlayer;
        User user = this.getUser(recipient);
        if (user == null) {
            return null;
        }
        String replyPlayer = null;
        try {
            replyPlayer = user.getReplyRecipient().getName();
        }
        catch (Throwable ex) {
            try {
                Method getReplyTo = ReflectionUtil.getMethod(user.getClass(), "getReplyTo");
                if (getReplyTo != null) {
                    CommandSource commandSource = (CommandSource)ReflectionUtil.invoke(getReplyTo, (Object)user, new Object[0]);
                    replyPlayer = commandSource == null ? null : commandSource.getPlayer().getName();
                }
            }
            catch (Throwable t) {
                replyPlayer = null;
            }
        }
        Player player = bukkitPlayer = replyPlayer == null ? null : Bukkit.getPlayer((String)replyPlayer);
        if (bukkitPlayer != null && bukkitPlayer.isOnline()) {
            return bukkitPlayer;
        }
        return null;
    }

    String getNick(String player) {
        User user = this.getUser(player);
        if (user == null) {
            return player;
        }
        String essNick = Common.getOrEmpty(user.getNickname());
        return "".equals(essNick) ? null : essNick;
    }

    void setNick(UUID uniqueId, String nick) {
        User user = this.getUser(uniqueId);
        if (user != null) {
            boolean isEmpty = nick == null || Common.stripColors(nick).replace(" ", "").isEmpty();
            user.setNickname(isEmpty ? null : Common.colorize(nick));
        }
    }

    String getNameFromNick(String maybeNick) {
        UserMap users = this.ess.getUserMap();
        if (users != null) {
            for (UUID userId : users.getAllUniqueUsers()) {
                User user = users.getUser(userId);
                if (user == null || user.getNickname() == null || !Valid.colorlessEquals(user.getNickname(), maybeNick)) continue;
                return Common.getOrDefault(user.getName(), maybeNick);
            }
        }
        return maybeNick;
    }

    void setBackLocation(String player, Location loc) {
        User user = this.getUser(player);
        if (user != null) {
            try {
                user.setLastLocation(loc);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private User getUser(String name) {
        if (this.ess.getUserMap() == null) {
            return null;
        }
        User user = null;
        try {
            user = this.ess.getUserMap().getUser(name);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (user == null) {
            try {
                user = this.ess.getUserMap().getUserFromBukkit(name);
            }
            catch (Throwable ex) {
                user = this.ess.getUser(name);
            }
        }
        return user;
    }

    private User getUser(UUID uniqueId) {
        if (this.ess.getUserMap() == null) {
            return null;
        }
        User user = null;
        try {
            user = this.ess.getUserMap().getUser(uniqueId);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (user == null) {
            try {
                user = this.ess.getUser(uniqueId);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return user;
    }
}

