/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.util.DiscordUtil;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.debug.Debugger;

class DiscordSRVHook {
    DiscordSRVHook() {
    }

    Set<String> getChannels() {
        return DiscordSRV.getPlugin().getChannels().keySet();
    }

    boolean sendMessage(String channel, String message) {
        return this.sendMessage(null, channel, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sendMessage(@Nullable CommandSender sender, String channel, String message) {
        TextChannel textChannel = DiscordSRV.getPlugin().getDestinationTextChannelForGameChannelName(channel);
        if (textChannel == null) {
            Debugger.debug("discord", "[MC->Discord] Could not find Discord channel '" + channel + "'. Available: " + String.join((CharSequence)", ", this.getChannels()) + ". Not sending: " + message);
            return false;
        }
        if (sender instanceof Player) {
            Debugger.debug("discord", "[MC->Discord] " + sender.getName() + " send message to '" + channel + "' channel. Message: '" + message + "'");
            DiscordSRV instance = (DiscordSRV)JavaPlugin.getPlugin(DiscordSRV.class);
            String key = "DiscordChatChannelMinecraftToDiscord";
            Map runtimeValues = (Map)ReflectionUtil.getFieldContent(DiscordSRV.config(), "runtimeValues");
            Object oldValue = runtimeValues.get("DiscordChatChannelMinecraftToDiscord");
            runtimeValues.put("DiscordChatChannelMinecraftToDiscord", true);
            try {
                instance.processChatMessage((Player)sender, message, channel, false);
            }
            finally {
                if (oldValue == null) {
                    runtimeValues.remove("DiscordChatChannelMinecraftToDiscord");
                } else {
                    runtimeValues.put("DiscordChatChannelMinecraftToDiscord", oldValue);
                }
            }
        } else {
            Debugger.debug("discord", "[MC->Discord] " + (sender == null ? "No sender " : sender.getName() + " (generic)") + "sent message to '" + channel + "' channel. Message: '" + message + "'");
            DiscordUtil.sendMessage((TextChannel)textChannel, (String)message);
        }
        return true;
    }
}

