/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.ListenerPriority;
import github.scarsz.discordsrv.api.Subscribe;
import github.scarsz.discordsrv.api.events.DiscordGuildMessagePostProcessEvent;
import github.scarsz.discordsrv.api.events.DiscordGuildMessagePreProcessEvent;
import github.scarsz.discordsrv.api.events.GameChatMessagePreProcessEvent;
import github.scarsz.discordsrv.dependencies.jda.api.JDA;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Message;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Role;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import github.scarsz.discordsrv.dependencies.jda.api.exceptions.ErrorResponseException;
import github.scarsz.discordsrv.dependencies.jda.api.exceptions.HierarchyException;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.WebhookUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.collection.StrictSet;
import sk.adonikeoffice.epicchat.lib.debug.Debugger;
import sk.adonikeoffice.epicchat.lib.model.DiscordSender;
import sk.adonikeoffice.epicchat.lib.model.HookManager;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.remain.Remain;

public abstract class DiscordListener
implements Listener {
    private static final StrictSet<DiscordListener> registeredListeners = new StrictSet();
    private Message message;
    private final Map<Long, Long> editedMessages = new HashMap<Long, Long>();

    public static final void clearRegisteredListeners() {
        registeredListeners.clear();
    }

    protected DiscordListener() {
        registeredListeners.add(this);
    }

    public void register() {
        if (!registeredListeners.contains(this)) {
            registeredListeners.add(this);
        }
    }

    private final void handleMessageReceived(DiscordGuildMessagePreProcessEvent event) {
        this.message = event.getMessage();
        this.onMessageReceived(event);
    }

    private final void handleMessageReceivedLate(DiscordGuildMessagePostProcessEvent event) {
        this.message = event.getMessage();
        this.onMessageReceivedLate(event);
    }

    protected abstract void onMessageReceived(DiscordGuildMessagePreProcessEvent var1);

    protected void onMessageReceivedLate(DiscordGuildMessagePostProcessEvent event) {
    }

    protected void onMessageSent(GameChatMessagePreProcessEvent event) {
    }

    protected final Player findPlayer(String playerName, String offlineMessage) {
        Player player = Bukkit.getPlayer((String)playerName);
        this.checkBoolean(player != null, offlineMessage);
        return player;
    }

    protected final TextChannel findChannel(long channelId) {
        JDA jda = DiscordUtil.getJda();
        if (jda != null) {
            return jda.getTextChannelById(channelId);
        }
        return null;
    }

    protected final List<TextChannel> findChannels(String channelName) {
        JDA jda = DiscordUtil.getJda();
        if (jda != null) {
            ArrayList<TextChannel> channels = new ArrayList<TextChannel>();
            for (TextChannel channel : jda.getTextChannels()) {
                if (!channel.getName().equalsIgnoreCase(channelName)) continue;
                channels.add(channel);
            }
            return channels;
        }
        return new ArrayList<TextChannel>();
    }

    protected final Set<String> getChannelsNames() {
        return HookManager.getDiscordChannels();
    }

    protected final void checkBoolean(boolean value, String warningMessage) throws RemovedMessageException {
        if (!value) {
            this.removeAndWarn(warningMessage);
        }
    }

    protected final void removeAndWarn(String warningMessage) {
        this.removeAndWarn(this.message, warningMessage);
    }

    protected final void removeAndWarn(Message message, String warningMessage) {
        this.removeAndWarn(message, warningMessage, 2);
    }

    protected final void removeAndWarn(Message message, String warningMessage, int warningDurationSeconds) {
        message.delete().complete();
        MessageChannel channel = message.getChannel();
        Message channelWarningMessage = (Message)channel.sendMessage((CharSequence)warningMessage).complete();
        channel.deleteMessageById(channelWarningMessage.getIdLong()).completeAfter((long)warningDurationSeconds, TimeUnit.SECONDS);
        throw new RemovedMessageException();
    }

    protected final void returnHandled(String message) {
        Message notifyMessage = (Message)this.message.getChannel().sendMessage((CharSequence)message).complete();
        notifyMessage.delete().completeAfter(2L, TimeUnit.SECONDS);
        throw new RemovedMessageException();
    }

    protected final boolean hasRole(Member member, String roleName) {
        for (Role role : member.getRoles()) {
            if (!role.getName().equalsIgnoreCase(roleName)) continue;
            return true;
        }
        return false;
    }

    protected final void sendMessage(Player sender, String channelName, String message) {
        HookManager.sendDiscordMessage((CommandSender)sender, channelName, message);
    }

    protected final void sendMessage(String channelName, String message) {
        HookManager.sendDiscordMessage(channelName, message);
    }

    protected final void sendWebhookMessage(@Nullable CommandSender sender, String channelName, String message) {
        TextChannel channel;
        List<TextChannel> channels = this.findChannels(channelName);
        TextChannel textChannel = channel = channels.isEmpty() ? null : channels.get(0);
        if (channel == null) {
            return;
        }
        Common.runAsync(() -> {
            try {
                if (sender instanceof Player) {
                    WebhookUtil.deliverMessage((TextChannel)channel, (Player)((Player)sender), (String)message);
                } else {
                    HookManager.sendDiscordMessage(sender, channelName, message);
                }
            }
            catch (ErrorResponseException ex) {
                Debugger.debug("discord", "Unable to send message to Discord channel " + channelName + ", message: " + message);
            }
        });
    }

    protected final void flashMessage(TextChannel channel, String message) {
        String finalMessage = Common.stripColors(message);
        Common.runAsync(() -> {
            Message sentMessage = (Message)channel.sendMessage((CharSequence)finalMessage).complete();
            Common.runLaterAsync(80, () -> {
                block2: {
                    try {
                        channel.deleteMessageById(sentMessage.getIdLong()).complete();
                    }
                    catch (ErrorResponseException ex) {
                        if (ex.getMessage().contains("Unknown Message")) break block2;
                        ex.printStackTrace();
                    }
                }
            });
        });
    }

    protected final void deleteMessageById(TextChannel channel, long messageId) {
        Common.runAsync(() -> {
            long latestMessageId = this.editedMessages.getOrDefault(messageId, messageId);
            try {
                channel.deleteMessageById(latestMessageId).complete();
            }
            catch (Throwable t) {
                if (!(t instanceof ErrorResponseException)) {
                    t.printStackTrace();
                }
                Debugger.debug("discord", "Could not remove Discord message in channel '" + channel.getName() + "' id " + latestMessageId + ", it was probably deleted otherwise or this is a bug.");
            }
        });
    }

    protected final void editMessageById(TextChannel channel, long messageId, String format) {
        Common.runAsync(() -> {
            block3: {
                try {
                    Message message = (Message)channel.retrieveMessageById(messageId).complete();
                    if (message != null) {
                        channel.deleteMessageById(messageId).complete();
                        Message newSentMessage = (Message)channel.sendMessage((CharSequence)format.replace("{player}", message.getAuthor().getName())).complete();
                        this.editedMessages.put(messageId, newSentMessage.getIdLong());
                    }
                }
                catch (Throwable t) {
                    if (t.toString().contains("Unknown Message")) break block3;
                    t.printStackTrace();
                }
            }
        });
    }

    protected final String findPlayerName(Member member, User author) {
        String discordName = Common.getOrDefaultStrict(member.getNickname(), author.getName());
        UUID linkedId = DiscordSRV.getPlugin().getAccountLinkManager().getUuid(author.getId());
        Player player = linkedId != null ? Remain.getPlayerByUUID(linkedId) : Bukkit.getPlayer((String)discordName);
        return player != null && player.isOnline() ? player.getName() : discordName;
    }

    public final void kickMember(DiscordSender discordSender, String reason) {
        Common.runAsync(() -> {
            try {
                Member member = DiscordUtil.getMemberById((String)discordSender.getUser().getId());
                if (member != null) {
                    member.kick(reason).complete();
                }
            }
            catch (HierarchyException ex) {
                Common.log("Unable to kick " + discordSender.getName() + " because he appears to be Discord administrator");
            }
        });
    }

    protected Map<Long, Long> getEditedMessages() {
        return this.editedMessages;
    }

    private static final class RemovedMessageException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private RemovedMessageException() {
        }
    }

    @Deprecated
    public static final class DiscordListenerImpl
    implements Listener {
        private static volatile DiscordListenerImpl instance = new DiscordListenerImpl();

        public void resubscribe() {
            DiscordSRV.api.unsubscribe((Object)this);
            DiscordSRV.api.subscribe((Object)this);
        }

        public void registerHook() {
            try {
                DiscordSRV.getPlugin().getPluginHooks().add(SimplePlugin::getInstance);
            }
            catch (Error error) {
                // empty catch block
            }
        }

        @Subscribe(priority=ListenerPriority.HIGH)
        public void onMessageReceived(DiscordGuildMessagePreProcessEvent event) {
            for (DiscordListener listener : registeredListeners) {
                try {
                    listener.handleMessageReceived(event);
                }
                catch (RemovedMessageException removedMessageException) {
                }
                catch (Throwable t) {
                    Common.error(t, "Failed to handle DiscordSRV->Minecraft message (pre process)!", "Sender: " + event.getAuthor().getName(), "Channel: " + event.getChannel().getName(), "Message: " + event.getMessage().getContentDisplay());
                }
            }
        }

        @Subscribe(priority=ListenerPriority.HIGH)
        public void onMessageReceivedLate(DiscordGuildMessagePostProcessEvent event) {
            for (DiscordListener listener : registeredListeners) {
                try {
                    listener.handleMessageReceivedLate(event);
                }
                catch (RemovedMessageException removedMessageException) {
                }
                catch (Throwable t) {
                    Common.error(t, "Failed to handle DiscordSRV->Minecraft message (post process)!", "Sender: " + event.getAuthor().getName(), "Channel: " + event.getChannel().getName(), "Message: " + event.getMessage().getContentDisplay());
                }
            }
        }

        @Subscribe(priority=ListenerPriority.HIGH)
        public void onMessageSend(GameChatMessagePreProcessEvent event) {
            for (DiscordListener listener : registeredListeners) {
                try {
                    listener.onMessageSent(event);
                }
                catch (RemovedMessageException removedMessageException) {
                }
                catch (Throwable t) {
                    Common.error(t, "Failed to handle Minecraft->DiscordSRV message!", "Sender: " + event.getPlayer().getName(), "Channel: " + event.getChannel(), "Message: " + event.getMessage());
                }
            }
        }

        private DiscordListenerImpl() {
        }

        public static DiscordListenerImpl getInstance() {
            return instance;
        }
    }
}

