/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.model.SimpleTime;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;

public abstract class Countdown
implements Runnable {
    private static final int START_DELAY = 20;
    private static final int TICK_PERIOD = 20;
    private final int countdownSeconds;
    private int secondsSinceStart = 0;
    private int taskId = -1;

    protected Countdown(SimpleTime time) {
        this((int)time.getTimeSeconds());
    }

    protected Countdown(int countdownSeconds) {
        this.countdownSeconds = countdownSeconds;
    }

    @Override
    public final void run() {
        ++this.secondsSinceStart;
        if (this.secondsSinceStart < this.countdownSeconds) {
            try {
                this.onTick();
            }
            catch (Throwable t) {
                try {
                    this.onTickError(t);
                }
                catch (Throwable tt) {
                    Common.log("Unable to handle onTickError, got " + t + ": " + tt.getMessage());
                }
                Common.error(t, "Error in countdown!", "Seconds since start: " + this.secondsSinceStart, "Counting till: " + this.countdownSeconds, "%error");
            }
        } else {
            this.cancel();
            this.onEnd();
        }
    }

    protected void onStart() {
    }

    protected abstract void onTick();

    protected abstract void onEnd();

    protected void onTickError(Throwable t) {
    }

    public int getTimeLeft() {
        return this.countdownSeconds - this.secondsSinceStart;
    }

    public final void launch() {
        Valid.checkBoolean(!this.isRunning(), "Task " + this + " already scheduled!", new Object[0]);
        BukkitTask task = Bukkit.getScheduler().runTaskTimer((Plugin)SimplePlugin.getInstance(), (Runnable)this, 20L, 20L);
        this.taskId = task.getTaskId();
        this.onStart();
    }

    public final void cancel() {
        Bukkit.getScheduler().cancelTask(this.getTaskId());
        this.taskId = -1;
        this.secondsSinceStart = 0;
    }

    public final boolean isRunning() {
        return this.taskId != -1;
    }

    public final int getTaskId() {
        Valid.checkBoolean(this.isRunning(), "Task " + this + " not scheduled yet", new Object[0]);
        return this.taskId;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "{" + this.countdownSeconds + ", id=" + this.taskId + "}";
    }

    public int getCountdownSeconds() {
        return this.countdownSeconds;
    }

    protected int getSecondsSinceStart() {
        return this.secondsSinceStart;
    }
}

