/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.Valid;

public abstract class ChunkedTask {
    private int waitPeriodTicks = 20;
    private final int processAmount;
    private int currentIndex = 0;
    private boolean processing = false;
    private boolean firstLaunch = false;

    public ChunkedTask(int processAmount) {
        this.processAmount = processAmount;
    }

    public ChunkedTask(int processAmount, int waitPeriodTicks) {
        this.processAmount = processAmount;
        this.waitPeriodTicks = waitPeriodTicks;
    }

    public final void startChain() {
        if (!this.firstLaunch) {
            this.processing = true;
            this.firstLaunch = true;
        }
        Common.runLater(() -> {
            if (!this.processing) {
                this.onFinish(false);
                this.firstLaunch = false;
                return;
            }
            long now = System.currentTimeMillis();
            boolean finished = false;
            int processed = 0;
            for (int i = this.currentIndex; i < this.currentIndex + this.processAmount; ++i) {
                if (!this.canContinue(i)) {
                    finished = true;
                    break;
                }
                ++processed;
                try {
                    this.onProcess(i);
                    continue;
                }
                catch (Throwable t) {
                    Common.error(t, "Error in " + this + " processing index " + processed);
                    this.processing = false;
                    this.firstLaunch = false;
                    this.onFinish(false);
                    return;
                }
            }
            if (processed > 0 || !finished) {
                Common.log(this.getProcessMessage(now, processed));
            }
            if (!finished) {
                this.currentIndex += this.processAmount;
                Common.runLaterAsync(this.waitPeriodTicks, this::startChain);
            } else {
                this.processing = false;
                this.firstLaunch = false;
                this.onFinish(true);
            }
        });
    }

    public final void cancel() {
        Valid.checkBoolean(this.processing, "Chunked task is not running: " + this, new Object[0]);
        this.processing = false;
    }

    protected abstract void onProcess(int var1) throws Throwable;

    protected abstract boolean canContinue(int var1);

    protected String getProcessMessage(long initialTime, int processed) {
        return "Processed " + String.format("%,d", processed) + " " + this.getLabel() + ". Took " + (System.currentTimeMillis() - initialTime) + " ms";
    }

    protected void onFinish(boolean gracefully) {
        this.onFinish();
    }

    @Deprecated
    protected void onFinish() {
    }

    protected String getLabel() {
        return "blocks";
    }

    public void setWaitPeriodTicks(int waitPeriodTicks) {
        this.waitPeriodTicks = waitPeriodTicks;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public boolean isProcessing() {
        return this.processing;
    }
}

