/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import sk.adonikeoffice.epicchat.lib.ChatUtil;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.model.SimpleComponent;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.settings.SimpleLocalization;

public final class ChatPaginator {
    public static final int FOUNDATION_HEIGHT = 15;
    private final int linesPerPage;
    private final ChatColor themeColor;
    private final List<SimpleComponent> header = new ArrayList<SimpleComponent>();
    private final Map<Integer, List<SimpleComponent>> pages = new HashMap<Integer, List<SimpleComponent>>();
    private final List<SimpleComponent> footer = new ArrayList<SimpleComponent>();

    public ChatPaginator() {
        this(15, SimpleLocalization.Commands.HEADER_COLOR);
    }

    public ChatPaginator(ChatColor themeColor) {
        this(15, themeColor);
    }

    public ChatPaginator(int linesPerPage) {
        this(linesPerPage, SimpleLocalization.Commands.HEADER_COLOR);
    }

    public ChatPaginator setFoundationHeader(String title) {
        return this.setHeader("&r", this.themeColor + "&m" + ChatUtil.center("&r" + this.themeColor + " " + title + " &m", '-', 150), "&r");
    }

    public ChatPaginator setHeader(SimpleComponent ... components) {
        Collections.addAll(this.header, components);
        return this;
    }

    public ChatPaginator setHeader(String ... messages) {
        for (String message : messages) {
            this.header.add(SimpleComponent.of(message));
        }
        return this;
    }

    public ChatPaginator setPages(SimpleComponent ... components) {
        this.pages.clear();
        this.pages.putAll(Common.fillPages(this.linesPerPage, Arrays.asList(components)));
        return this;
    }

    public ChatPaginator setPages(String ... messages) {
        ArrayList<SimpleComponent> pages = new ArrayList<SimpleComponent>();
        for (String message : messages) {
            pages.add(SimpleComponent.of(message));
        }
        return this.setPages(pages);
    }

    public ChatPaginator setPages(Collection<SimpleComponent> components) {
        this.pages.clear();
        this.pages.putAll(Common.fillPages(this.linesPerPage, components));
        return this;
    }

    public ChatPaginator setFooter(SimpleComponent ... components) {
        Collections.addAll(this.footer, components);
        return this;
    }

    public ChatPaginator setFooter(String ... messages) {
        for (String message : messages) {
            this.footer.add(SimpleComponent.of(message));
        }
        return this;
    }

    public void send(CommandSender sender) {
        this.send(sender, 1);
    }

    public void send(CommandSender sender, int page) {
        if (Bukkit.isPrimaryThread()) {
            this.send0(sender, page);
        } else {
            Common.runLater(() -> this.send0(sender, page));
        }
    }

    private void send0(CommandSender sender, int page) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (player.hasMetadata("FoPages")) {
                Plugin owningPlugin = ((MetadataValue)player.getMetadata("FoPages").get(0)).getOwningPlugin();
                player.removeMetadata("FoPages", owningPlugin);
            }
            player.setMetadata("FoPages", (MetadataValue)new FixedMetadataValue((Plugin)SimplePlugin.getInstance(), (Object)SimplePlugin.getNamed()));
            player.setMetadata(ChatPaginator.getPageNbtTag(), (MetadataValue)new FixedMetadataValue((Plugin)SimplePlugin.getInstance(), (Object)this));
            player.chat("/#flp " + page);
        } else {
            for (SimpleComponent component : this.header) {
                component.send(new CommandSender[]{sender});
            }
            int amount = 1;
            for (List<SimpleComponent> components : this.pages.values()) {
                for (SimpleComponent component : components) {
                    component.replace("{count}", amount++).send(new CommandSender[]{sender});
                }
            }
            for (SimpleComponent component : this.footer) {
                component.send(new CommandSender[]{sender});
            }
        }
    }

    public static String getPageNbtTag() {
        return "FoPages_" + SimplePlugin.getNamed();
    }

    public int getLinesPerPage() {
        return this.linesPerPage;
    }

    public ChatColor getThemeColor() {
        return this.themeColor;
    }

    public List<SimpleComponent> getHeader() {
        return this.header;
    }

    public Map<Integer, List<SimpleComponent>> getPages() {
        return this.pages;
    }

    public List<SimpleComponent> getFooter() {
        return this.footer;
    }

    public ChatPaginator(int linesPerPage, ChatColor themeColor) {
        this.linesPerPage = linesPerPage;
        this.themeColor = themeColor;
    }
}

