/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import lombok.NonNull;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.model.Variables;
import sk.adonikeoffice.epicchat.lib.remain.CompChatColor;

public final class ChatImage {
    private static final char TRANSPARENT_CHAR = ' ';
    private String[] lines;

    public ChatImage appendText(String ... text) {
        for (int y = 0; y < this.lines.length; ++y) {
            if (text.length <= y) continue;
            String line = text[y];
            int n = y;
            this.lines[n] = this.lines[n] + " " + line;
        }
        return this;
    }

    public ChatImage appendCenteredText(String ... text) {
        for (int y = 0; y < this.lines.length; ++y) {
            if (text.length <= y) {
                return this;
            }
            int len = 65 - this.lines[y].length();
            this.lines[y] = this.lines[y] + this.center(text[y], len);
        }
        return this;
    }

    private String center(String message, int length) {
        if (message.length() > length) {
            return message.substring(0, length);
        }
        if (message.length() == length) {
            return message;
        }
        int leftPadding = (length - message.length()) / 2;
        StringBuilder leftBuilder = new StringBuilder();
        for (int i = 0; i < leftPadding; ++i) {
            leftBuilder.append(" ");
        }
        return leftBuilder.toString() + message;
    }

    public void sendToPlayer(CommandSender sender) {
        for (String line : this.lines) {
            sender.sendMessage(Variables.replace(line, sender));
        }
    }

    public static ChatImage fromFile(@NonNull File file, int height, Type characterType) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        Valid.checkBoolean(file.exists(), "Cannot load image from non existing file " + file.toPath(), new Object[0]);
        BufferedImage image = ImageIO.read(file);
        if (image == null) {
            throw new NullPointerException("Unable to load image size " + file.length() + " bytes from " + file.toPath());
        }
        BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        newImage.createGraphics().drawImage(image, 0, 0, Color.WHITE, null);
        CompChatColor[][] chatColors = ChatImage.parseImage(newImage, height);
        ChatImage chatImage = new ChatImage();
        chatImage.lines = ChatImage.parseColors(chatColors, characterType);
        return chatImage;
    }

    public static ChatImage fromLines(String[] lines) {
        ChatImage chatImage = new ChatImage();
        chatImage.lines = lines;
        return chatImage;
    }

    private static CompChatColor[][] parseImage(BufferedImage newImage, int height) {
        double ratio = (double)newImage.getHeight() / (double)newImage.getWidth();
        int width = (int)((double)height / ratio);
        if (width > 10) {
            width = 10;
        }
        BufferedImage resized = ChatImage.resizeImage(newImage, (int)((double)height / ratio), height);
        CompChatColor[][] chatImg = new CompChatColor[resized.getWidth()][resized.getHeight()];
        for (int x = 0; x < resized.getWidth(); ++x) {
            for (int y = 0; y < resized.getHeight(); ++y) {
                CompChatColor closest;
                int rgb = resized.getRGB(x, y);
                chatImg[x][y] = closest = CompChatColor.getClosestLegacyColor(new Color(rgb, true));
            }
        }
        return chatImg;
    }

    private static BufferedImage resizeImage(BufferedImage originalImage, int width, int height) {
        AffineTransform af = new AffineTransform();
        af.scale((double)width / (double)originalImage.getWidth(), (double)height / (double)originalImage.getHeight());
        AffineTransformOp operation = new AffineTransformOp(af, 1);
        return operation.filter(originalImage, null);
    }

    private static String[] parseColors(CompChatColor[][] colors, Type imgchar) {
        String[] lines = new String[colors[0].length];
        for (int y = 0; y < colors[0].length; ++y) {
            String line = "";
            for (CompChatColor[] color2 : colors) {
                CompChatColor color = color2[y];
                line = line + (color != null ? color2[y].toString() + (Object)((Object)imgchar) : Character.valueOf(' '));
            }
            lines[y] = line + ChatColor.RESET;
        }
        return lines;
    }

    private ChatImage() {
    }

    public String[] getLines() {
        return this.lines;
    }

    public static enum Type {
        BLOCK('\u2588'),
        DARK_SHADE('\u2593'),
        MEDIUM_SHADE('\u2592'),
        LIGHT_SHADE('\u2591');

        private char character;

        private Type(char c) {
            this.character = c;
        }

        public String toString() {
            return String.valueOf(this.character);
        }

        public char getCharacter() {
            return this.character;
        }
    }
}

