/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.model;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.TabList.TabListManager;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.Valid;

class CMIHook {
    CMIHook() {
    }

    boolean isVanished(Player player) {
        CMIUser user = this.getUser(player);
        return user != null && user.isVanished();
    }

    void setVanished(Player player, boolean vanished) {
        CMIUser user = this.getUser(player);
        if (user != null && user.isVanished() != vanished) {
            user.setVanished(false);
        }
    }

    boolean isAfk(Player player) {
        CMIUser user = this.getUser(player);
        return user != null && user.isAfk();
    }

    boolean isMuted(Player player) {
        CMIUser user = this.getUser(player);
        try {
            return user != null && user.getMutedUntil() != 0L && user.getMutedUntil() != null && user.getMutedUntil() > System.currentTimeMillis();
        }
        catch (Exception ex) {
            return false;
        }
    }

    boolean hasGodMode(Player player) {
        CMIUser user = this.getUser(player);
        return user != null ? user.isGod() : false;
    }

    void setGodMode(Player player, boolean godMode) {
        CMIUser user = this.getUser(player);
        if (user != null) {
            user.setGod(Boolean.valueOf(godMode));
        }
    }

    void setLastTeleportLocation(Player player, Location location) {
        CMIUser user = this.getUser(player);
        try {
            user.getClass().getMethod("setLastTeleportLocation", Location.class).invoke((Object)user, location);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void setIgnore(UUID player, UUID who, boolean ignore) {
        CMIUser user = CMI.getInstance().getPlayerManager().getUser(player);
        if (ignore) {
            user.addIgnore(who, true);
        } else {
            user.removeIgnore(who);
        }
    }

    boolean isIgnoring(UUID player, UUID who) {
        try {
            CMIUser user = CMI.getInstance().getPlayerManager().getUser(player);
            return user.isIgnoring(who);
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    String getNick(Player player) {
        CMIUser user = this.getUser(player);
        String nick = user == null ? null : user.getNickName();
        return nick == null || "".equals(nick) ? null : nick;
    }

    String getNick(String playerName) {
        CMIUser user = this.getUser(playerName);
        String nick = user == null ? null : user.getNickName();
        return nick == null || "".equals(nick) ? null : nick;
    }

    void setNick(UUID uniqueId, String nick) {
        CMIUser user = this.getUser(uniqueId);
        TabListManager tabManager = CMI.getInstance().getTabListManager();
        if (user != null) {
            boolean isEmpty = nick == null || Common.stripColors(nick).replace(" ", "").isEmpty();
            user.setNickName(isEmpty ? null : Common.colorize(nick), true);
            user.updateDisplayName();
            if (tabManager.isUpdatesOnNickChange()) {
                tabManager.updateTabList(3);
            }
        }
    }

    String getNameFromNick(String nick) {
        for (CMIUser user : CMI.getInstance().getPlayerManager().getAllUsers().values()) {
            if (user == null || user.getNickName() == null || !Valid.colorlessEquals(user.getNickName(), nick)) continue;
            return Common.getOrDefault(user.getName(), nick);
        }
        return nick;
    }

    private CMIUser getUser(Player player) {
        return CMI.getInstance().getPlayerManager().getUser(player);
    }

    private CMIUser getUser(UUID uniqueId) {
        return CMI.getInstance().getPlayerManager().getUser(uniqueId);
    }

    private CMIUser getUser(String name) {
        return CMI.getInstance().getPlayerManager().getUser(name);
    }
}

