/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.menu.tool;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.event.RocketExplosionEvent;
import sk.adonikeoffice.epicchat.lib.menu.tool.Rocket;
import sk.adonikeoffice.epicchat.lib.menu.tool.Tool;
import sk.adonikeoffice.epicchat.lib.remain.Remain;
import sk.adonikeoffice.epicchat.lib.settings.SimpleLocalization;

public final class ToolsListener
implements Listener {
    private final Map<UUID, ShotRocket> shotRockets = new HashMap<UUID, ShotRocket>();

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
    public void onToolClick(PlayerInteractEvent event) {
        if (!Remain.isInteractEventPrimaryHand(event)) {
            return;
        }
        Player player = event.getPlayer();
        Tool tool = Tool.getTool(player.getItemInHand());
        if (tool != null) {
            try {
                if ((event.isCancelled() || !event.hasBlock()) && tool.ignoreCancelled()) {
                    return;
                }
                if (tool instanceof Rocket) {
                    Rocket rocket = (Rocket)tool;
                    if (rocket.canLaunch(player, player.getEyeLocation())) {
                        player.launchProjectile(rocket.getProjectile(), player.getEyeLocation().getDirection().multiply(rocket.getFlightSpeed()));
                    } else {
                        event.setCancelled(true);
                    }
                } else {
                    tool.onBlockClick(event);
                }
                if (tool.autoCancel()) {
                    event.setCancelled(true);
                }
            }
            catch (Throwable t) {
                event.setCancelled(true);
                Common.tell((CommandSender)player, SimpleLocalization.Tool.ERROR);
                Common.error(t, "Failed to handle " + event.getAction() + " using tool: " + tool.getClass());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onToolPlaceBlock(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        Tool tool = Tool.getTool(player.getItemInHand());
        if (tool != null) {
            try {
                if (event.isCancelled() && tool.ignoreCancelled()) {
                    return;
                }
                tool.onBlockPlace(event);
                if (tool.autoCancel()) {
                    event.setCancelled(true);
                }
            }
            catch (Throwable t) {
                event.setCancelled(true);
                Common.tell((CommandSender)player, SimpleLocalization.Tool.ERROR);
                Common.error(t, "Failed to handle placing " + event.getBlock() + " using tool: " + tool.getClass());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onHeltItem(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        Tool current = Tool.getTool(player.getInventory().getItem(event.getNewSlot()));
        Tool previous = Tool.getTool(player.getInventory().getItem(event.getPreviousSlot()));
        if (current != null) {
            if (previous != null) {
                if (previous.equals(current)) {
                    return;
                }
                previous.onHotbarDefocused(player);
            }
            current.onHotbarFocused(player);
        } else if (previous != null) {
            previous.onHotbarDefocused(player);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onRocketShoot(ProjectileLaunchEvent event) {
        ProjectileSource shooter;
        Projectile shot = event.getEntity();
        try {
            shooter = shot.getShooter();
        }
        catch (NoSuchMethodError ex) {
            if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_4)) {
                ex.printStackTrace();
            }
            return;
        }
        if (!(shooter instanceof Player)) {
            return;
        }
        if (this.shotRockets.containsKey(shot.getUniqueId())) {
            return;
        }
        final Player player = (Player)shooter;
        Tool tool = Tool.getTool(player.getItemInHand());
        if (tool instanceof Rocket) {
            try {
                final Rocket rocket = (Rocket)tool;
                if (event.isCancelled() && tool.ignoreCancelled()) {
                    return;
                }
                if (!rocket.canLaunch(player, shot.getLocation())) {
                    event.setCancelled(true);
                    return;
                }
                if (tool.autoCancel() || shot instanceof EnderPearl) {
                    World world = shot.getWorld();
                    Location loc = shot.getLocation();
                    Common.runLater(() -> shot.remove());
                    Common.runLater(1, () -> {
                        Valid.checkNotNull(shot, "shot = null");
                        Valid.checkNotNull(world, "shot.world = null");
                        Valid.checkNotNull(loc, "shot.location = null");
                        Location directedLoc = player.getEyeLocation().add(player.getEyeLocation().getDirection().setY(0).normalize().multiply(1.05)).add(0.0, 0.2, 0.0);
                        final Projectile copy = (Projectile)world.spawn(directedLoc, shot.getClass());
                        copy.setVelocity(shot.getVelocity());
                        this.shotRockets.put(copy.getUniqueId(), new ShotRocket(player, rocket));
                        rocket.onLaunch(copy, player);
                        Common.runTimer(1, (Runnable)new BukkitRunnable(){
                            private long elapsedTicks = 0L;

                            public void run() {
                                if (!copy.isValid() || copy.isOnGround() || this.elapsedTicks++ > 600L) {
                                    this.cancel();
                                } else {
                                    rocket.onFlyTick(copy, player);
                                }
                            }
                        });
                    });
                } else {
                    this.shotRockets.put(shot.getUniqueId(), new ShotRocket(player, rocket));
                    rocket.onLaunch(shot, player);
                }
            }
            catch (Throwable t) {
                event.setCancelled(true);
                Common.tell((CommandSender)player, SimpleLocalization.Tool.ERROR);
                Common.error(t, "Failed to shoot rocket " + tool.getClass());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onRocketHit(ProjectileHitEvent event) {
        Projectile projectile = event.getEntity();
        ShotRocket shot = this.shotRockets.remove(projectile.getUniqueId());
        if (shot != null) {
            Rocket rocket = shot.getRocket();
            Player shooter = shot.getShooter();
            try {
                if (rocket.canExplode(projectile, shooter)) {
                    RocketExplosionEvent rocketEvent = new RocketExplosionEvent(rocket, projectile, rocket.getExplosionPower(), rocket.isBreakBlocks());
                    if (Common.callEvent(rocketEvent)) {
                        Location location = projectile.getLocation();
                        shot.getRocket().onExplode(projectile, shot.getShooter());
                        projectile.getWorld().createExplosion(location.getX(), location.getY(), location.getZ(), rocketEvent.getPower(), false, rocketEvent.isBreakBlocks());
                    }
                } else {
                    projectile.remove();
                }
            }
            catch (Throwable t) {
                Common.tell((CommandSender)shooter, SimpleLocalization.Tool.ERROR);
                Common.error(t, "Failed to handle impact by rocket " + shot.getRocket().getClass());
            }
        }
    }

    private final class ShotRocket {
        private final Player shooter;
        private final Rocket rocket;

        public ShotRocket(Player shooter, Rocket rocket) {
            this.shooter = shooter;
            this.rocket = rocket;
        }

        public Player getShooter() {
            return this.shooter;
        }

        public Rocket getRocket() {
            return this.rocket;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShotRocket)) {
                return false;
            }
            ShotRocket other = (ShotRocket)o;
            Player this$shooter = this.getShooter();
            Player other$shooter = other.getShooter();
            if (this$shooter == null ? other$shooter != null : !this$shooter.equals(other$shooter)) {
                return false;
            }
            Rocket this$rocket = this.getRocket();
            Rocket other$rocket = other.getRocket();
            return !(this$rocket == null ? other$rocket != null : !((Object)this$rocket).equals(other$rocket));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Player $shooter = this.getShooter();
            result = result * 59 + ($shooter == null ? 43 : $shooter.hashCode());
            Rocket $rocket = this.getRocket();
            result = result * 59 + ($rocket == null ? 43 : $rocket.hashCode());
            return result;
        }

        public String toString() {
            return "ToolsListener.ShotRocket(shooter=" + this.getShooter() + ", rocket=" + this.getRocket() + ")";
        }
    }
}

