/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.menu.tool;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import sk.adonikeoffice.epicchat.lib.ItemUtil;
import sk.adonikeoffice.epicchat.lib.Valid;

public abstract class Tool {
    private static final Collection<Tool> tools = new ConcurrentLinkedQueue<Tool>();

    static synchronized void register(Tool tool) {
        Valid.checkBoolean(!Tool.isRegistered(tool), "Tool with itemstack " + tool.getItem() + " already registered", new Object[0]);
        tools.add(tool);
    }

    static synchronized boolean isRegistered(Tool tool) {
        return Tool.getTool(tool.getItem()) != null;
    }

    public static Tool getTool(ItemStack item) {
        for (Tool t : tools) {
            if (!t.isTool(item)) continue;
            return t;
        }
        return null;
    }

    public static Tool[] getTools() {
        return tools.toArray(new Tool[tools.size()]);
    }

    protected Tool() {
        new Thread(() -> {
            try {
                Thread.sleep(3L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Tool instance = this;
            if (!Tool.isRegistered(instance)) {
                Tool.register(instance);
            }
        }).start();
    }

    public final boolean isTool(ItemStack item) {
        return ItemUtil.isSimilar(this.getItem(), item);
    }

    public final boolean hasToolInHand(Player player) {
        return this.isTool(player.getItemInHand());
    }

    public final boolean hasTool(Player player) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (!this.isTool(item)) continue;
            return true;
        }
        return false;
    }

    public abstract ItemStack getItem();

    protected void onBlockClick(PlayerInteractEvent event) {
    }

    protected void onBlockPlace(BlockPlaceEvent event) {
    }

    protected void onHotbarFocused(Player player) {
    }

    protected void onHotbarDefocused(Player player) {
    }

    protected boolean ignoreCancelled() {
        return true;
    }

    protected boolean autoCancel() {
        return false;
    }

    public final boolean giveIfHasnt(Player player) {
        if (this.hasTool(player)) {
            return false;
        }
        this.give(player);
        return true;
    }

    public final void give(Player player, int slot) {
        player.getInventory().setItem(slot, this.getItem());
    }

    public final void give(Player player) {
        player.getInventory().addItem(new ItemStack[]{this.getItem()});
    }

    public final boolean equals(Object obj) {
        return obj instanceof Tool && ((Tool)obj).getItem().equals((Object)this.getItem());
    }
}

