/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.menu.model;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.UUID;
import lombok.NonNull;
import org.bukkit.Material;
import org.bukkit.SkullType;
import org.bukkit.block.Block;
import org.bukkit.block.Skull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.remain.Remain;

public class SkullCreator {
    private static Field blockProfileField;
    private static Method metaSetProfileMethod;
    private static Field metaProfileField;

    public static ItemStack createSkull() {
        try {
            return new ItemStack(Material.valueOf((String)"PLAYER_HEAD"));
        }
        catch (IllegalArgumentException e) {
            return new ItemStack(Material.valueOf((String)"SKULL_ITEM"), 1, 3);
        }
    }

    public static ItemStack itemFromName(String name) {
        return SkullCreator.itemWithName(SkullCreator.createSkull(), name);
    }

    public static ItemStack itemFromUuid(UUID id) {
        return SkullCreator.itemWithUuid(SkullCreator.createSkull(), id);
    }

    public static ItemStack itemFromUrl(String url) {
        return SkullCreator.itemWithUrl(SkullCreator.createSkull(), url);
    }

    public static ItemStack itemFromBase64(String base64) {
        return SkullCreator.itemWithBase64(SkullCreator.createSkull(), base64);
    }

    public static ItemStack itemWithName(@NonNull ItemStack item, @NonNull String name) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        meta.setOwner(name);
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    public static ItemStack itemWithUuid(@NonNull ItemStack item, @NonNull UUID id) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        try {
            meta.setOwningPlayer(Remain.getOfflinePlayerByUUID(id));
        }
        catch (Throwable t) {
            meta.setOwner(Remain.getOfflinePlayerByUUID(id).getName());
        }
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    public static ItemStack itemWithUrl(@NonNull ItemStack item, @NonNull String url) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return SkullCreator.itemWithBase64(item, SkullCreator.urlToBase64(url));
    }

    public static ItemStack itemWithBase64(@NonNull ItemStack item, @NonNull String base64) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (base64 == null) {
            throw new NullPointerException("base64 is marked non-null but is null");
        }
        if (!(item.getItemMeta() instanceof SkullMeta)) {
            return null;
        }
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        SkullCreator.mutateItemMeta(meta, base64);
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    public static SkullMeta metaWithUrl(@NonNull SkullMeta meta, @NonNull String url) {
        if (meta == null) {
            throw new NullPointerException("meta is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        String base64 = SkullCreator.urlToBase64(url);
        SkullCreator.mutateItemMeta(meta, base64);
        return meta;
    }

    public static void blockWithUuid(@NonNull Block block, @NonNull UUID id) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        SkullCreator.setToSkull(block);
        Skull state = (Skull)block.getState();
        try {
            state.setOwningPlayer(Remain.getOfflinePlayerByUUID(id));
        }
        catch (Throwable t) {
            state.setOwner(Remain.getOfflinePlayerByUUID(id).getName());
        }
        state.update(false, false);
    }

    public static void blockWithUrl(@NonNull Block block, @NonNull String url) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        SkullCreator.blockWithBase64(block, SkullCreator.urlToBase64(url));
    }

    public static void blockWithBase64(@NonNull Block block, @NonNull String base64) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        if (base64 == null) {
            throw new NullPointerException("base64 is marked non-null but is null");
        }
        SkullCreator.setToSkull(block);
        Skull state = (Skull)block.getState();
        SkullCreator.mutateBlockState(state, base64);
        state.update(false, false);
    }

    private static void setToSkull(Block block) {
        try {
            block.setType(Material.valueOf((String)"PLAYER_HEAD"), false);
        }
        catch (IllegalArgumentException e) {
            block.setType(Material.valueOf((String)"SKULL"), false);
            Skull state = (Skull)block.getState();
            state.setSkullType(SkullType.PLAYER);
            state.update(false, false);
        }
    }

    private static String urlToBase64(String url) {
        URI actualUrl;
        Valid.checkBoolean(url.startsWith("http://") || url.startsWith("https://"), "URL for skull must start with http:// or https://, given: " + url, new Object[0]);
        try {
            actualUrl = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        String toEncode = "{\"textures\":{\"SKIN\":{\"url\":\"" + actualUrl.toString() + "\"}}}";
        return Base64.getEncoder().encodeToString(toEncode.getBytes());
    }

    private static Object makeProfile(String b64) {
        UUID id = new UUID(b64.substring(b64.length() - 20).hashCode(), b64.substring(b64.length() - 10).hashCode());
        try {
            Class gameProfileClass = ReflectionUtil.lookupClass("com.mojang.authlib.GameProfile");
            Object profile = ReflectionUtil.instantiate(gameProfileClass.getConstructor(UUID.class, String.class), id, "aaaaa");
            Class propertyClass = ReflectionUtil.lookupClass("com.mojang.authlib.properties.Property");
            Object property = ReflectionUtil.instantiate(propertyClass.getConstructor(String.class, String.class), "textures", b64);
            Object propertyMap = ReflectionUtil.invoke("getProperties", profile, new Object[0]);
            ReflectionUtil.invoke("put", propertyMap, "textures", property);
            return profile;
        }
        catch (ReflectiveOperationException ex) {
            Common.throwError(ex, new String[0]);
            return null;
        }
    }

    private static void mutateBlockState(Skull block, String b64) {
        try {
            if (blockProfileField == null) {
                blockProfileField = block.getClass().getDeclaredField("profile");
                blockProfileField.setAccessible(true);
            }
            blockProfileField.set(block, SkullCreator.makeProfile(b64));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    private static void mutateItemMeta(SkullMeta meta, String b64) {
        try {
            if (metaSetProfileMethod == null) {
                metaSetProfileMethod = meta.getClass().getDeclaredMethod("setProfile", ReflectionUtil.lookupClass("com.mojang.authlib.GameProfile"));
                metaSetProfileMethod.setAccessible(true);
            }
            metaSetProfileMethod.invoke((Object)meta, SkullCreator.makeProfile(b64));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            try {
                if (metaProfileField == null) {
                    metaProfileField = meta.getClass().getDeclaredField("profile");
                    metaProfileField.setAccessible(true);
                }
                metaProfileField.set(meta, SkullCreator.makeProfile(b64));
            }
            catch (IllegalAccessException | NoSuchFieldException ex2) {
                ex2.printStackTrace();
            }
        }
    }

    private SkullCreator() {
    }
}

