/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.menu.model;

import java.util.ArrayList;
import java.util.List;
import sk.adonikeoffice.epicchat.lib.Common;

public enum MenuQuantity {
    ONE_TENTH(0.1),
    HALF(0.5),
    ONE(1.0),
    TWO(2.0),
    FIVE(5.0),
    TEN(10.0),
    TWENTY(20.0);

    private final double amountPercent;

    @Deprecated
    public int getAmount() {
        return (int)Math.round(this.getAmountPercent());
    }

    public double getAmountDouble() {
        return this.amountPercent / 100.0;
    }

    public double getAmountPercent() {
        return this.amountPercent;
    }

    public final MenuQuantity previous(boolean allowDecimals) {
        return Common.getNext(this, this.compileQuantities(allowDecimals), false);
    }

    public final MenuQuantity next(boolean allowDecimals) {
        return Common.getNext(this, this.compileQuantities(allowDecimals), true);
    }

    private List<MenuQuantity> compileQuantities(boolean includeDecimals) {
        ArrayList<MenuQuantity> available = new ArrayList<MenuQuantity>();
        for (MenuQuantity quantity : MenuQuantity.values()) {
            if (!includeDecimals && !(quantity.getAmountPercent() >= 1.0)) continue;
            available.add(quantity);
        }
        return available;
    }

    private MenuQuantity(double amountPercent) {
        this.amountPercent = amountPercent;
    }
}

