/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.menu.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.material.MaterialData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.menu.model.SkullCreator;
import sk.adonikeoffice.epicchat.lib.model.SimpleEnchant;
import sk.adonikeoffice.epicchat.lib.model.SimpleEnchantment;
import sk.adonikeoffice.epicchat.lib.remain.CompColor;
import sk.adonikeoffice.epicchat.lib.remain.CompItemFlag;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;
import sk.adonikeoffice.epicchat.lib.remain.CompMetadata;
import sk.adonikeoffice.epicchat.lib.remain.CompMonsterEgg;
import sk.adonikeoffice.epicchat.lib.remain.CompProperty;
import sk.adonikeoffice.epicchat.lib.remain.Remain;
import sk.adonikeoffice.epicchat.lib.remain.nbt.NBTItem;

public final class ItemCreator {
    @Nullable
    private ItemStack item;
    @Nullable
    private ItemMeta meta;
    @Nullable
    private CompMaterial material;
    private int amount = -1;
    private int damage = -1;
    private String name;
    private final List<String> lores = new ArrayList<String>();
    private final Map<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
    private final List<CompItemFlag> flags = new ArrayList<CompItemFlag>();
    private boolean unbreakable = false;
    @Nullable
    private CompColor color;
    private boolean hideTags = false;
    @Nullable
    private Integer modelData;
    private boolean glow = false;
    @Nullable
    private String skullOwner;
    @Nullable
    private String skullUrl;
    private final Map<String, String> tags = new HashMap<String, String>();
    @Nullable
    private List<String> bookPages = null;
    @Nullable
    private String bookAuthor;
    @Nullable
    private String bookTitle;

    public ItemCreator item(ItemStack item) {
        this.item = item;
        return this;
    }

    public ItemCreator meta(ItemMeta meta) {
        this.meta = meta;
        return this;
    }

    public ItemCreator material(CompMaterial material) {
        this.material = material;
        return this;
    }

    public ItemCreator amount(int amount) {
        this.amount = amount;
        return this;
    }

    public ItemCreator damage(int damage) {
        this.damage = damage;
        return this;
    }

    public ItemCreator name(String name) {
        this.name = name;
        return this;
    }

    public ItemCreator clearLore() {
        this.lores.clear();
        return this;
    }

    public ItemCreator lore(String ... lore) {
        return this.lore(Arrays.asList(lore));
    }

    public ItemCreator lore(List<String> lore) {
        this.lores.addAll(lore);
        return this;
    }

    public ItemCreator enchant(SimpleEnchant enchant) {
        return this.enchant(enchant.getEnchant(), enchant.getLevel());
    }

    public ItemCreator enchant(Enchantment enchantment) {
        return this.enchant(enchantment, 1);
    }

    public ItemCreator enchant(Enchantment enchantment, int level) {
        this.enchants.put(enchantment, level);
        return this;
    }

    @Deprecated
    public ItemCreator flag(CompItemFlag ... flags) {
        return this.flags(flags);
    }

    public ItemCreator flags(CompItemFlag ... flags) {
        this.flags.addAll(Arrays.asList(flags));
        return this;
    }

    public ItemCreator unbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
        return this;
    }

    public ItemCreator color(CompColor color) {
        this.color = color;
        return this;
    }

    public ItemCreator hideTags(boolean hideTags) {
        this.hideTags = hideTags;
        return this;
    }

    public ItemCreator modelData(int modelData) {
        this.modelData = modelData;
        return this;
    }

    public ItemCreator glow(boolean glow) {
        this.glow = glow;
        return this;
    }

    public ItemCreator skullOwner(String skullOwner) {
        this.skullOwner = skullOwner;
        return this;
    }

    public ItemCreator skullUrl(String skullUrl) {
        this.skullUrl = skullUrl;
        return this;
    }

    public ItemCreator tag(String key, String value) {
        this.tags.put(key, value);
        return this;
    }

    public ItemCreator bookPages(String ... pages) {
        return this.bookPages(Arrays.asList(pages));
    }

    public ItemCreator bookPages(List<String> pages) {
        if (this.bookPages == null) {
            this.bookPages = new ArrayList<String>();
        }
        this.bookPages.addAll(pages);
        return this;
    }

    public ItemCreator bookAuthor(String bookAuthor) {
        this.bookAuthor = bookAuthor;
        return this;
    }

    public ItemCreator bookTitle(String bookTitle) {
        this.bookTitle = bookTitle;
        return this;
    }

    public void give(Player player) {
        player.getInventory().addItem(new ItemStack[]{this.make()});
    }

    public void drop(Location location) {
        location.getWorld().dropItem(location, this.make());
    }

    @Deprecated
    public ItemCreator build() {
        return this;
    }

    @Deprecated
    public ItemStack makeSurvival() {
        return this.make();
    }

    public ItemStack makeMenuTool() {
        this.hideTags = true;
        return this.make();
    }

    public ItemStack make() {
        ItemMeta compiledMeta;
        ItemStack compiledItem;
        Valid.checkBoolean(this.material != null || this.item != null, "Material or item must be set!", new Object[0]);
        ItemStack itemStack = compiledItem = this.item != null ? this.item.clone() : this.material.toItem();
        ItemMeta itemMeta = Remain.hasItemMeta() ? (this.meta != null ? this.meta.clone() : compiledItem.getItemMeta()) : (compiledMeta = null);
        if (this.material != null) {
            compiledItem.setType(this.material.getMaterial());
            if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_13)) {
                compiledItem.setData(new MaterialData(this.material.getMaterial(), this.material.getData()));
            }
        }
        if (CompMaterial.isAir(compiledItem.getType())) {
            return compiledItem;
        }
        if (this.color != null) {
            if (compiledItem.getType().toString().contains("LEATHER")) {
                if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_4)) {
                    Valid.checkBoolean(compiledMeta instanceof LeatherArmorMeta, "Expected a leather item, cannot apply color to " + compiledItem, new Object[0]);
                    ((LeatherArmorMeta)compiledMeta).setColor(this.color.getColor());
                }
            } else if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_13)) {
                String dye = this.color.getDye().toString();
                List<String> list = Arrays.asList("BANNER", "BED", "CARPET", "CONCRETE", "GLAZED_TERRACOTTA", "SHULKER_BOX", "STAINED_GLASS", "STAINED_GLASS_PANE", "TERRACOTTA", "WALL_BANNER", "WOOL");
                for (String material : list) {
                    String suffix = "_" + material;
                    if (!compiledItem.getType().toString().endsWith(suffix)) continue;
                    compiledItem.setType(Material.valueOf((String)(dye + suffix)));
                    break;
                }
            } else {
                try {
                    byte dataValue = this.color.getDye().getWoolData();
                    compiledItem.setData(new MaterialData(compiledItem.getType(), dataValue));
                    compiledItem.setDurability((short)dataValue);
                }
                catch (NoSuchMethodError dataValue) {
                    // empty catch block
                }
            }
        }
        if (compiledItem.getType().toString().endsWith("SPAWN_EGG") || compiledItem.getType().toString().equals("MONSTER_EGG")) {
            EntityType entity = null;
            if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_13)) {
                CompMonsterEgg.acceptUnsafeEggs = true;
                EntityType entityType = CompMonsterEgg.getEntity(compiledItem);
                CompMonsterEgg.acceptUnsafeEggs = false;
                if (entityType != null && entityType != EntityType.UNKNOWN) {
                    entity = entityType;
                }
            }
            if (entity == null) {
                String string = compiledItem.getType().toString();
                String entityRaw = string.replace("_SPAWN_EGG", "");
                if (entityRaw.equals("MONSTER_EGG") && this.material != null && this.material.toString().endsWith("SPAWN_EGG")) {
                    entityRaw = this.material.toString().replace("_SPAWN_EGG", "");
                }
                if ("MOOSHROOM".equals(entityRaw)) {
                    entityRaw = "MUSHROOM_COW";
                } else if ("ZOMBIE_PIGMAN".equals(entityRaw)) {
                    entityRaw = "PIG_ZOMBIE";
                }
                try {
                    entity = EntityType.valueOf((String)entityRaw);
                }
                catch (Throwable t) {
                    Common.log("The following item could not be transformed into " + entityRaw + " egg, item: " + compiledItem);
                }
            }
            if (entity != null) {
                compiledMeta = CompMonsterEgg.setEntity(compiledItem, entity).getItemMeta();
            }
        }
        if (this.damage != -1) {
            try {
                ReflectionUtil.invoke("setDurability", (Object)compiledItem, (short)this.damage);
            }
            catch (Throwable entity) {
                // empty catch block
            }
            try {
                if (compiledMeta instanceof Damageable) {
                    ((Damageable)compiledMeta).setDamage(this.damage);
                }
            }
            catch (Throwable entity) {
                // empty catch block
            }
        }
        if (compiledMeta instanceof SkullMeta) {
            if (this.skullOwner != null) {
                ((SkullMeta)compiledMeta).setOwner(this.skullOwner);
            }
            if (this.skullUrl != null) {
                compiledMeta = SkullCreator.metaWithUrl((SkullMeta)compiledMeta, this.skullUrl);
            }
        }
        if (compiledMeta instanceof BookMeta) {
            BookMeta bookMeta = (BookMeta)compiledMeta;
            if (this.bookPages != null) {
                bookMeta.setPages(Common.colorize(this.bookPages));
            }
            if (this.bookAuthor != null) {
                bookMeta.setAuthor(Common.getOrEmpty(this.bookAuthor));
            }
            if (this.bookTitle != null) {
                bookMeta.setTitle(Common.getOrEmpty(this.bookTitle));
            }
            if (bookMeta.getPages() == null) {
                bookMeta.setPages(Arrays.asList(""));
            }
            if (bookMeta.getAuthor() == null) {
                bookMeta.setAuthor("Anonymous");
            }
            if (bookMeta.getTitle() == null) {
                bookMeta.setTitle("Book");
            }
        }
        if (compiledMeta instanceof ItemMeta) {
            if (this.glow && this.enchants.isEmpty()) {
                compiledMeta.addEnchant(Enchantment.DURABILITY, 1, true);
                this.flags.add(CompItemFlag.HIDE_ENCHANTS);
            }
            for (Map.Entry entry : this.enchants.entrySet()) {
                Enchantment enchant = (Enchantment)entry.getKey();
                int level = (Integer)entry.getValue();
                if (compiledMeta instanceof EnchantmentStorageMeta) {
                    ((EnchantmentStorageMeta)compiledMeta).addStoredEnchant(enchant, level, true);
                    continue;
                }
                compiledMeta.addEnchant(enchant, level, true);
            }
            if (this.name != null && !"".equals(this.name)) {
                compiledMeta.setDisplayName(Common.colorize("&r&f" + this.name));
            }
            if (!this.lores.isEmpty()) {
                ArrayList coloredLores = new ArrayList();
                for (String lore : this.lores) {
                    if (lore == null) continue;
                    for (String subLore : lore.split("\n")) {
                        coloredLores.add(Common.colorize("&7" + subLore));
                    }
                }
                compiledMeta.setLore((List)coloredLores);
            }
        }
        if (this.unbreakable) {
            this.flags.add(CompItemFlag.HIDE_ATTRIBUTES);
            this.flags.add(CompItemFlag.HIDE_UNBREAKABLE);
            CompProperty.UNBREAKABLE.apply(compiledMeta, true);
        }
        if (this.hideTags) {
            for (CompItemFlag f : CompItemFlag.values()) {
                if (this.flags.contains((Object)f)) continue;
                this.flags.add(f);
            }
        }
        for (CompItemFlag compItemFlag : this.flags) {
            try {
                compiledMeta.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)compItemFlag.toString())});
            }
            catch (Throwable throwable) {}
        }
        if (this.modelData != null && MinecraftVersion.atLeast(MinecraftVersion.V.v1_14)) {
            try {
                compiledMeta.setCustomModelData(this.modelData);
            }
            catch (Throwable coloredLores) {
                // empty catch block
            }
        }
        if (this.amount != -1) {
            compiledItem.setAmount(this.amount);
        }
        if (compiledMeta instanceof ItemMeta) {
            compiledItem.setItemMeta(compiledMeta);
        }
        compiledItem = Common.getOrDefault(SimpleEnchantment.addEnchantmentLores(compiledItem), compiledItem);
        if (this.glow && MinecraftVersion.equals(MinecraftVersion.V.v1_7) && (this.enchants == null || this.enchants.isEmpty())) {
            NBTItem nbtItem = new NBTItem(compiledItem);
            nbtItem.removeKey("ench");
            nbtItem.addCompound("ench");
            compiledItem = nbtItem.getItem();
        }
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_7)) {
            for (Map.Entry<String, String> entry : this.tags.entrySet()) {
                compiledItem = CompMetadata.setMetadata(compiledItem, entry.getKey(), entry.getValue());
            }
        } else if (!this.tags.isEmpty() && this.item != null) {
            Common.log("Item had unsupported tags " + this.tags + " that are not supported on MC " + MinecraftVersion.getServerVersion() + " Item: " + compiledItem);
        }
        return compiledItem;
    }

    public static ItemCreator of(CompMaterial material, String name, @NonNull Collection<String> lore) {
        if (lore == null) {
            throw new NullPointerException("lore is marked non-null but is null");
        }
        return ItemCreator.of(material, name, Common.toArray(lore));
    }

    public static ItemCreator of(CompMaterial material, String name, String ... lore) {
        if (lore == null) {
            throw new NullPointerException("lore is marked non-null but is null");
        }
        return new ItemCreator().material(material).name(name).lore(lore).hideTags(true);
    }

    public static ItemCreator ofWool(CompColor color) {
        return ItemCreator.of(CompMaterial.makeWool(color, 1)).color(color);
    }

    public static ItemCreator ofEgg(EntityType entityType) {
        return ItemCreator.of(CompMonsterEgg.makeEgg(entityType));
    }

    public static ItemCreator ofEgg(EntityType entityType, String name, String ... lore) {
        return ItemCreator.of(CompMonsterEgg.makeEgg(entityType)).name(name).lore(lore);
    }

    public static ItemCreator ofPotion(PotionEffectType potionEffect) {
        return ItemCreator.ofPotion(potionEffect, 1);
    }

    public static ItemCreator ofPotion(PotionEffectType potionEffect, int durationTicks, int level) {
        return ItemCreator.ofPotion(potionEffect, durationTicks, level, null, new String[0]);
    }

    public static ItemCreator ofPotion(PotionEffectType potionEffect, int level) {
        return ItemCreator.ofPotion(potionEffect, Integer.MAX_VALUE, level, null, new String[0]);
    }

    public static ItemCreator ofPotion(PotionEffectType potionEffect, String name, String ... lore) {
        return ItemCreator.ofPotion(potionEffect, Integer.MAX_VALUE, 1, name, lore);
    }

    public static ItemCreator ofPotion(PotionEffect effect, String name, String ... lore) {
        return ItemCreator.ofPotion(effect.getType(), Integer.MAX_VALUE, effect.getAmplifier() + 1, name, lore);
    }

    public static ItemCreator ofPotion(PotionEffectType potionEffect, int durationTicks, int level, String name, String ... lore) {
        boolean noLevel = level == 0;
        ItemStack item = new ItemStack(level == 0 ? CompMaterial.GLASS_BOTTLE.getMaterial() : CompMaterial.POTION.getMaterial());
        if (!noLevel) {
            Remain.setPotion(item, potionEffect, durationTicks, level);
        }
        ItemCreator builder = ItemCreator.of(item);
        if (name != null) {
            builder.name(name);
        }
        if (lore != null) {
            builder.lore(lore);
        }
        return builder;
    }

    public static ItemCreator of(ItemStack item) {
        ItemCreator builder = new ItemCreator();
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.getLore() != null) {
            builder.lore(meta.getLore());
        }
        return builder.item(item);
    }

    public static ItemCreator of(CompMaterial mat) {
        Valid.checkNotNull((Object)mat, "Material cannot be null!");
        return new ItemCreator().material(mat);
    }

    private ItemCreator() {
    }

    public String getName() {
        return this.name;
    }
}

