/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.menu.button;

import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import sk.adonikeoffice.epicchat.lib.menu.Menu;
import sk.adonikeoffice.epicchat.lib.menu.button.Button;
import sk.adonikeoffice.epicchat.lib.menu.model.ItemCreator;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;
import sk.adonikeoffice.epicchat.lib.settings.SimpleLocalization;

public final class ButtonReturnBack
extends Button {
    private static CompMaterial material = CompMaterial.OAK_DOOR;
    private static String title = SimpleLocalization.Menu.BUTTON_RETURN_TITLE;
    private static List<String> lore = Arrays.asList(SimpleLocalization.Menu.BUTTON_RETURN_LORE);
    @NonNull
    private final Menu parentMenu;
    private boolean makeNewInstance = false;

    @Override
    public ItemStack getItem() {
        return ItemCreator.of(material).name(title).lore(lore).make();
    }

    @Override
    public void onClickedInMenu(Player player, Menu menu, ClickType click) {
        if (this.makeNewInstance) {
            Inventory currentChestInventory = player.getOpenInventory().getTopInventory();
            if (currentChestInventory != null) {
                menu.handleClose(currentChestInventory);
            }
            this.parentMenu.newInstance().displayTo(player);
        } else {
            this.parentMenu.displayTo(player);
            this.parentMenu.restartMenu();
        }
    }

    public ButtonReturnBack(@NonNull Menu parentMenu) {
        if (parentMenu == null) {
            throw new NullPointerException("parentMenu is marked non-null but is null");
        }
        this.parentMenu = parentMenu;
    }

    public ButtonReturnBack(@NonNull Menu parentMenu, boolean makeNewInstance) {
        if (parentMenu == null) {
            throw new NullPointerException("parentMenu is marked non-null but is null");
        }
        this.parentMenu = parentMenu;
        this.makeNewInstance = makeNewInstance;
    }

    public static CompMaterial getMaterial() {
        return material;
    }

    public static void setMaterial(CompMaterial material) {
        ButtonReturnBack.material = material;
    }

    public static String getTitle() {
        return title;
    }

    public static void setTitle(String title) {
        ButtonReturnBack.title = title;
    }

    public static List<String> getLore() {
        return lore;
    }

    public static void setLore(List<String> lore) {
        ButtonReturnBack.lore = lore;
    }
}

