/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.menu.button;

import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.menu.Menu;
import sk.adonikeoffice.epicchat.lib.menu.button.Button;
import sk.adonikeoffice.epicchat.lib.menu.button.ButtonReturnBack;
import sk.adonikeoffice.epicchat.lib.menu.model.ItemCreator;
import sk.adonikeoffice.epicchat.lib.model.Replacer;
import sk.adonikeoffice.epicchat.lib.remain.CompColor;
import sk.adonikeoffice.epicchat.lib.remain.CompItemFlag;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;
import sk.adonikeoffice.epicchat.lib.settings.SimpleLocalization;

public class ButtonRemove
extends Button {
    private static String title = "&4&lRemove {name}";
    private static List<String> lore = Arrays.asList("&r", "&7The selected {type} will", "&7be removed permanently.");
    private final Menu parentMenu;
    private final String toRemoveType;
    private final String toRemoveName;
    private final Runnable removeAction;

    @Override
    public ItemStack getItem() {
        return ItemCreator.of(CompMaterial.LAVA_BUCKET).name(title.replace("{name}", this.toRemoveName)).lore(Replacer.replaceArray(lore, "name", this.toRemoveName, "type", this.toRemoveType)).flags(CompItemFlag.HIDE_ATTRIBUTES).make();
    }

    public ItemStack getRemoveConfirmItem() {
        return ItemCreator.ofWool(CompColor.RED).name("&6&lRemove " + this.toRemoveName).lore(Arrays.asList("&r", "&7Confirm that this " + this.toRemoveType + " will", "&7be removed permanently.", "&cCannot be undone.")).flags(CompItemFlag.HIDE_ATTRIBUTES).make();
    }

    public String getMenuTitle() {
        return "&0Confirm removal";
    }

    @Override
    public void onClickedInMenu(Player pl, Menu menu, ClickType click) {
        new MenuDialogRemove(this.parentMenu, new RemoveConfirmButton()).displayTo(pl);
    }

    public ButtonRemove(Menu parentMenu, String toRemoveType, String toRemoveName, Runnable removeAction) {
        this.parentMenu = parentMenu;
        this.toRemoveType = toRemoveType;
        this.toRemoveName = toRemoveName;
        this.removeAction = removeAction;
    }

    public static String getTitle() {
        return title;
    }

    public static void setTitle(String title) {
        ButtonRemove.title = title;
    }

    public static List<String> getLore() {
        return lore;
    }

    public static void setLore(List<String> lore) {
        ButtonRemove.lore = lore;
    }

    final class MenuDialogRemove
    extends Menu {
        private final Button confirmButton;
        private final Button returnButton;

        public MenuDialogRemove(Menu parentMenu, RemoveConfirmButton confirmButton) {
            super(parentMenu);
            this.confirmButton = confirmButton;
            this.returnButton = new ButtonReturnBack(parentMenu);
            this.setSize(27);
            this.setTitle(ButtonRemove.this.getMenuTitle());
        }

        @Override
        public ItemStack getItemAt(int slot) {
            if (slot == 12) {
                return this.confirmButton.getItem();
            }
            if (slot == 14) {
                return this.returnButton.getItem();
            }
            return null;
        }

        @Override
        protected boolean addReturnButton() {
            return false;
        }

        @Override
        protected String[] getInfo() {
            return null;
        }
    }

    final class RemoveConfirmButton
    extends Button {
        @Override
        public ItemStack getItem() {
            return ButtonRemove.this.getRemoveConfirmItem();
        }

        @Override
        public void onClickedInMenu(Player player, Menu menu, ClickType click) {
            player.closeInventory();
            ButtonRemove.this.removeAction.run();
            Common.tell((CommandSender)player, SimpleLocalization.Menu.ITEM_DELETED.replace("{item}", (!ButtonRemove.this.toRemoveType.isEmpty() ? ButtonRemove.this.toRemoveType + " " : "") + ButtonRemove.this.toRemoveName));
        }

        private RemoveConfirmButton() {
        }
    }
}

