/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.menu.button;

import java.util.concurrent.Callable;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.menu.Menu;
import sk.adonikeoffice.epicchat.lib.menu.button.Button;
import sk.adonikeoffice.epicchat.lib.menu.model.ItemCreator;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;

public final class ButtonMenu
extends Button {
    private final Callable<Menu> menuLateBind;
    private final Menu menuToOpen;
    private final ItemStack item;
    private final boolean newInstance;

    public ButtonMenu(Class<? extends Menu> menuClass, CompMaterial material, String name, String ... lore) {
        this(null, () -> (Menu)ReflectionUtil.instantiate(menuClass), ItemCreator.of(material, name, lore).hideTags(true).make(), false);
    }

    public ButtonMenu(Callable<Menu> menuLateBind, ItemCreator item) {
        this(null, menuLateBind, item.hideTags(true).make(), false);
    }

    public ButtonMenu(Callable<Menu> menuLateBind, ItemStack item) {
        this(null, menuLateBind, item, false);
    }

    public ButtonMenu(Menu menu, CompMaterial material, String name, String ... lore) {
        this(menu, ItemCreator.of(material, name, lore));
    }

    public ButtonMenu(Menu menu, ItemCreator item) {
        this(menu, null, item.hideTags(true).make(), false);
    }

    public ButtonMenu(Menu menu, ItemStack item) {
        this(menu, null, item, false);
    }

    public ButtonMenu(Menu menu, ItemStack item, boolean newInstance) {
        this(menu, null, item, newInstance);
    }

    private ButtonMenu(Menu menuToOpen, Callable<Menu> menuLateBind, ItemStack item, boolean newInstance) {
        this.menuToOpen = menuToOpen;
        this.menuLateBind = menuLateBind;
        this.item = item;
        this.newInstance = newInstance;
    }

    @Override
    public void onClickedInMenu(Player pl, Menu menu, ClickType click) {
        if (this.menuLateBind != null) {
            Menu menuToOpen = null;
            try {
                menuToOpen = this.menuLateBind.call();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
            if (this.newInstance) {
                menuToOpen = menuToOpen.newInstance();
            }
            menuToOpen.displayTo(pl);
        } else {
            Valid.checkNotNull(this.menuToOpen, "Report / ButtonTrigger requires either 'late bind menu' or normal menu to be set!");
            if (this.newInstance) {
                this.menuToOpen.newInstance().displayTo(pl);
            } else {
                this.menuToOpen.displayTo(pl);
            }
        }
    }

    @Override
    public ItemStack getItem() {
        return this.item;
    }
}

