/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.menu.button;

import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.conversation.SimpleConversation;
import sk.adonikeoffice.epicchat.lib.conversation.SimplePrompt;
import sk.adonikeoffice.epicchat.lib.menu.Menu;
import sk.adonikeoffice.epicchat.lib.menu.button.Button;
import sk.adonikeoffice.epicchat.lib.menu.model.ItemCreator;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;

public final class ButtonConversation
extends Button {
    private final SimpleConversation conversation;
    private final SimplePrompt prompt;
    private final ItemStack item;

    public ButtonConversation(SimpleConversation convo, CompMaterial material, String title, String ... lore) {
        this(convo, ItemCreator.of(material, title, lore));
    }

    public ButtonConversation(SimpleConversation convo, ItemCreator item) {
        this(convo, null, item.make());
    }

    public ButtonConversation(SimplePrompt prompt, CompMaterial material, String title, String ... lore) {
        this(prompt, ItemCreator.of(material, title, lore));
    }

    public ButtonConversation(SimplePrompt prompt, ItemCreator item) {
        this(null, prompt, item.hideTags(true).make());
    }

    private ButtonConversation(SimpleConversation conversation, SimplePrompt prompt, ItemStack item) {
        this.conversation = conversation;
        this.prompt = prompt;
        this.item = item;
    }

    @Override
    public void onClickedInMenu(Player player, Menu menu, ClickType click) {
        Valid.checkBoolean(this.conversation != null || this.prompt != null, "Conversation and prompt cannot be null!", new Object[0]);
        if (this.conversation != null) {
            this.conversation.setMenuToReturnTo(menu);
            this.conversation.start(player);
        } else {
            this.prompt.show(player);
        }
    }

    @Override
    public ItemStack getItem() {
        return this.item;
    }
}

