/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.menu.button;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.conversation.SimplePrompt;
import sk.adonikeoffice.epicchat.lib.conversation.SimpleStringPrompt;
import sk.adonikeoffice.epicchat.lib.menu.Menu;
import sk.adonikeoffice.epicchat.lib.menu.model.ItemCreator;
import sk.adonikeoffice.epicchat.lib.model.RangedValue;
import sk.adonikeoffice.epicchat.lib.model.Replacer;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;
import sk.adonikeoffice.epicchat.lib.settings.SimpleLocalization;

public abstract class Button {
    private static CompMaterial infoButtonMaterial = CompMaterial.NETHER_STAR;
    private static String infoButtonTitle = SimpleLocalization.Menu.TOOLTIP_INFO;

    public abstract void onClickedInMenu(Player var1, Menu var2, ClickType var3);

    public abstract ItemStack getItem();

    public static final DummyButton makeInfo(String ... description) {
        ArrayList<String> lores = new ArrayList<String>();
        lores.add(" ");
        for (String line : description) {
            lores.add("&7" + line);
        }
        return Button.makeDummy(ItemCreator.of(infoButtonMaterial).name(infoButtonTitle).hideTags(true).lore(lores));
    }

    public static final DummyButton makeEmpty() {
        return Button.makeDummy(ItemCreator.of(CompMaterial.AIR));
    }

    public static final DummyButton makeDummy(CompMaterial material, String title, String ... lore) {
        return Button.makeDummy(ItemCreator.of(material).name(title).lore(lore));
    }

    public static final DummyButton makeDummy(ItemCreator creator) {
        return Button.makeDummy(creator.makeMenuTool());
    }

    public static final DummyButton makeDummy(ItemStack item) {
        return new DummyButton(item);
    }

    public static final Button makeSimple(final CompMaterial icon, final String title, final String label, final Consumer<Player> onClickFunction) {
        return new Button(){

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(icon).name(title).lore("").lore(label.split("\n")).makeMenuTool();
            }

            @Override
            public void onClickedInMenu(Player player, Menu menu, ClickType click) {
                onClickFunction.accept(player);
            }
        };
    }

    public static final Button makeSimple(final ItemCreator builder, final Consumer<Player> onClickFunction) {
        return new Button(){

            @Override
            public ItemStack getItem() {
                return builder.makeMenuTool();
            }

            @Override
            public void onClickedInMenu(Player player, Menu menu, ClickType click) {
                onClickFunction.accept(player);
            }
        };
    }

    public static final Button makeSimple(final CompMaterial icon, final String title, final String label, final BiConsumer<Player, ClickType> onClickFunction) {
        return new Button(){

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(icon, title, "", label).makeMenuTool();
            }

            @Override
            public void onClickedInMenu(Player player, Menu menu, ClickType click) {
                onClickFunction.accept(player, click);
            }
        };
    }

    public static final Button makeBoolean(final ItemCreator creator, final Supplier<Boolean> getter, final Consumer<Boolean> setter) {
        final String menuTitle = creator.getName().toLowerCase();
        return new Button(){

            @Override
            public void onClickedInMenu(Player player, Menu menu, ClickType click) {
                boolean has = (Boolean)getter.get();
                setter.accept(!has);
                Menu newMenu = menu.newInstance();
                newMenu.displayTo(player);
                newMenu.restartMenu((has ? "&4Disabled" : "&2Enabled") + " " + menuTitle + "!");
            }

            @Override
            public ItemStack getItem() {
                boolean has = (Boolean)getter.get();
                ItemStack item = creator.glow(has).make();
                ItemMeta meta = item.getItemMeta();
                meta.setLore(Replacer.replaceArray(meta.getLore(), "status", has ? "&aEnabled" : "&cDisabled"));
                item.setItemMeta(meta);
                return item;
            }
        };
    }

    public static Button makeIntegerPrompt(ItemCreator item, String question, RangedValue minMaxRange, Supplier<Object> getter, Consumer<Integer> setter) {
        return Button.makeIntegerPrompt(item, question, null, minMaxRange, getter, setter);
    }

    public static Button makeIntegerPrompt(final ItemCreator item, final String question, final String menuTitle, final RangedValue minMaxRange, final Supplier<Object> getter, final Consumer<Integer> setter) {
        return new Button(){

            @Override
            public void onClickedInMenu(Player player, Menu menu, ClickType click) {
                new SimplePrompt(){

                    @Override
                    protected String getPrompt(ConversationContext ctx) {
                        return question.replace("{current}", getter.get().toString());
                    }

                    @Override
                    protected boolean isInputValid(ConversationContext context, String input) {
                        return Valid.isInteger(input) && Valid.isInRange(Integer.parseInt(input), minMaxRange.getMinLong(), minMaxRange.getMaxLong());
                    }

                    @Override
                    protected String getFailedValidationText(ConversationContext context, String invalidInput) {
                        return "Invalid input '" + invalidInput + "'! Enter a whole number from " + minMaxRange.getMinLong() + " to " + minMaxRange.getMaxLong() + ".";
                    }

                    @Override
                    protected String getMenuAnimatedTitle() {
                        return menuTitle != null ? "&9" + menuTitle.substring(0, 1).toUpperCase() + menuTitle.substring(1) + " set to " + getter.get() + "!" : null;
                    }

                    protected Prompt acceptValidatedInput(ConversationContext context, String input) {
                        setter.accept(Integer.parseInt(input));
                        return END_OF_CONVERSATION;
                    }
                }.show(player);
            }

            @Override
            public ItemStack getItem() {
                return item.make();
            }
        };
    }

    public static Button makeDecimalPrompt(ItemCreator item, String question, RangedValue minMaxRange, Consumer<Double> setter) {
        return Button.makeDecimalPrompt(item, question, minMaxRange, null, setter);
    }

    public static Button makeDecimalPrompt(ItemCreator item, String question, RangedValue minMaxRange, Supplier<Object> getter, Consumer<Double> setter) {
        return Button.makeDecimalPrompt(item, question, null, minMaxRange, getter, setter);
    }

    public static Button makeDecimalPrompt(final ItemCreator item, final String question, final String menuTitle, final RangedValue minMaxRange, final @Nullable Supplier<Object> getter, final Consumer<Double> setter) {
        return new Button(){

            @Override
            public void onClickedInMenu(Player player, Menu menu, ClickType click) {
                new SimplePrompt(){

                    @Override
                    protected String getPrompt(ConversationContext ctx) {
                        return question.replace("{current}", getter != null ? getter.get().toString() : "");
                    }

                    @Override
                    protected boolean isInputValid(ConversationContext context, String input) {
                        return Valid.isDecimal(input) && Valid.isInRange(Double.parseDouble(input), minMaxRange.getMinDouble(), minMaxRange.getMaxDouble());
                    }

                    @Override
                    protected String getFailedValidationText(ConversationContext context, String invalidInput) {
                        return "Invalid input '" + invalidInput + "'! Enter a whole number from " + minMaxRange.getMinDouble() + " to " + minMaxRange.getMaxDouble() + ".";
                    }

                    @Override
                    protected String getMenuAnimatedTitle() {
                        return menuTitle != null ? "&9" + menuTitle.substring(0, 1).toUpperCase() + menuTitle.substring(1) + " set to " + getter.get() + "!" : null;
                    }

                    protected Prompt acceptValidatedInput(ConversationContext context, String input) {
                        setter.accept(Double.parseDouble(input));
                        return END_OF_CONVERSATION;
                    }
                }.show(player);
            }

            @Override
            public ItemStack getItem() {
                ItemStack itemstack = item.make();
                ItemMeta meta = itemstack.getItemMeta();
                meta.setLore(Replacer.replaceArray(meta.getLore(), "current", getter != null ? getter.get().toString() : ""));
                itemstack.setItemMeta(meta);
                return itemstack;
            }
        };
    }

    public static Button makeStringPrompt(ItemCreator creator, String question, Consumer<String> onPromptFinish) {
        return Button.makeStringPrompt(creator, question, null, onPromptFinish);
    }

    public static Button makeStringPrompt(final ItemCreator creator, final String question, final @Nullable String menuTitle, final Consumer<String> onPromptFinish) {
        return new Button(){

            @Override
            public void onClickedInMenu(Player player, Menu menu, ClickType click) {
                new SimpleStringPrompt(question){

                    @Override
                    protected String getMenuAnimatedTitle() {
                        return menuTitle;
                    }

                    @Override
                    protected void onValidatedInput(ConversationContext context, String input) {
                        onPromptFinish.accept(input);
                    }
                }.show(player);
            }

            @Override
            public ItemStack getItem() {
                return creator.make();
            }
        };
    }

    public final String toString() {
        ItemStack item = this.getItem();
        return this.getClass().getSimpleName() + "{" + (item != null ? item.getType() : "null") + "}";
    }

    public static void setInfoButtonMaterial(CompMaterial infoButtonMaterial) {
        Button.infoButtonMaterial = infoButtonMaterial;
    }

    public static void setInfoButtonTitle(String infoButtonTitle) {
        Button.infoButtonTitle = infoButtonTitle;
    }

    public static final class DummyButton
    extends Button {
        private final ItemStack item;

        @Override
        public void onClickedInMenu(Player player, Menu menu, ClickType click) {
        }

        private DummyButton(ItemStack item) {
            this.item = item;
        }

        @Override
        public ItemStack getItem() {
            return this.item;
        }
    }
}

